/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli;

import com.gemstone.gemfire.management.cli.CommandProcessingException;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.GfshParseResult;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.MultipleValueConverter;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandMultiModeOptionException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandOptionException;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliException;
import com.gemstone.gemfire.management.internal.cli.exceptions.ExceptionHandler;
import com.gemstone.gemfire.management.internal.cli.help.format.NewHelp;
import com.gemstone.gemfire.management.internal.cli.help.utils.HelpUtils;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.modes.CommandModes;
import com.gemstone.gemfire.management.internal.cli.parser.Argument;
import com.gemstone.gemfire.management.internal.cli.parser.AvailabilityTarget;
import com.gemstone.gemfire.management.internal.cli.parser.CommandTarget;
import com.gemstone.gemfire.management.internal.cli.parser.GfshMethodTarget;
import com.gemstone.gemfire.management.internal.cli.parser.MethodParameter;
import com.gemstone.gemfire.management.internal.cli.parser.Option;
import com.gemstone.gemfire.management.internal.cli.parser.OptionSet;
import com.gemstone.gemfire.management.internal.cli.parser.Parameter;
import com.gemstone.gemfire.management.internal.cli.parser.ParserUtils;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.PreprocessorUtils;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.TrimmedInput;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.cli.util.CLIConsoleBufferUtil;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.springframework.shell.core.AbstractShell;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.Parser;
import org.springframework.shell.event.ParseResult;

public class GfshParser
implements Parser {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Short EXACT_TARGET = 0;
    private static final Short MATCHING_TARGETS = 1;
    private static final LogWrapper logWrapper = LogWrapper.getInstance();
    private CommandManager commandManager;
    private final Logger consoleLogger;

    public GfshParser(CommandManager commandManager) {
        this.commandManager = commandManager;
        this.consoleLogger = CliUtil.isGfshVM() ? Logger.getLogger(this.getClass().getCanonicalName()) : logWrapper.getLogger();
    }

    public int complete(String buffer, int cursor, List<String> completionCandidates) {
        ArrayList<Completion> candidates = new ArrayList<Completion>();
        int result = this.completeAdvanced(buffer, cursor, candidates);
        for (Completion completion : candidates) {
            completionCandidates.add(completion.getValue());
        }
        return result;
    }

    public int completeAdvanced(String buffer, int cursor, List<Completion> completionCandidates) {
        if (cursor <= buffer.length() - 1 && !PreprocessorUtils.containsOnlyWhiteSpaces(buffer.substring(cursor)) || ParserUtils.contains(buffer, ";")) {
            return cursor;
        }
        int desiredCursorPosition = 0;
        try {
            TrimmedInput simpleTrim = PreprocessorUtils.simpleTrim(buffer);
            desiredCursorPosition += simpleTrim.getNoOfSpacesRemoved();
            List<CommandTarget> targets = this.locateTargets(simpleTrim.getString());
            if (targets.size() > 1) {
                String padding = desiredCursorPosition != 0 ? ParserUtils.getPadding(desiredCursorPosition) : "";
                for (CommandTarget commandTarget : targets) {
                    completionCandidates.add(new Completion(padding + commandTarget.getGfshMethodTarget().getKey()));
                }
            } else if (targets.size() == 1) {
                CommandTarget commandTarget = targets.get(0);
                if (simpleTrim.getString().length() >= commandTarget.getGfshMethodTarget().getKey().length()) {
                    return this.completeParameters(commandTarget, desiredCursorPosition + commandTarget.getGfshMethodTarget().getKey().length(), commandTarget.getGfshMethodTarget().getRemainingBuffer(), cursor, completionCandidates);
                }
                String padding = desiredCursorPosition != 0 ? ParserUtils.getPadding(desiredCursorPosition) : "";
                completionCandidates.add(new Completion(padding + commandTarget.getGfshMethodTarget().getKey()));
            }
        }
        catch (IllegalArgumentException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (IllegalAccessException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (InvocationTargetException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (RuntimeException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        return 0;
    }

    private void updateCompletionCandidates(List<Completion> completionCandidates, String buffer, int position) {
        ArrayList<Completion> temp = new ArrayList<Completion>();
        while (completionCandidates.size() > 0) {
            temp.add(completionCandidates.remove(0));
        }
        for (Completion completion : temp) {
            completionCandidates.add(new Completion(buffer.substring(0, position) + completion.getValue(), completion.getFormattedValue(), completion.getHeading(), completion.getOrder()));
        }
    }

    private int completeParameters(CommandTarget commandTarget, int cursorStart, String remainingBuffer, int cursor, List<Completion> completionCandidates) {
        int newCursor;
        block71: {
            OptionSet userOptionSet;
            CliCommandOptionException coe;
            boolean sizeReduced;
            int desiredCursorPosition;
            block70: {
                desiredCursorPosition = cursorStart;
                sizeReduced = false;
                coe = null;
                userOptionSet = null;
                try {
                    if (remainingBuffer.length() > 0) {
                        remainingBuffer = remainingBuffer.substring(1);
                        sizeReduced = true;
                    }
                    userOptionSet = commandTarget.getOptionParser().parse(remainingBuffer);
                }
                catch (CliException ce) {
                    if (!(ce instanceof CliCommandOptionException)) break block70;
                    coe = (CliCommandOptionException)ce;
                    coe.setCommandTarget(commandTarget);
                    userOptionSet = coe.getOptionSet();
                }
            }
            ArrayList<Option> mandatoryOptions = new ArrayList<Option>();
            List<Option> unspecifiedOptions = new ArrayList<Option>();
            LinkedHashMap<String, Option> optionsPresentMap = new LinkedHashMap<String, Option>();
            if (userOptionSet != null) {
                String argumentSeparator = " ";
                for (Argument argument : commandTarget.getOptionParser().getArguments()) {
                    if (completionCandidates.size() == 0) {
                        boolean warning = false;
                        if (userOptionSet.hasArgument(argument)) {
                            boolean incrementCursor = true;
                            if (this.getAllPossibleValuesForParameter(completionCandidates, argument, userOptionSet.getValue(argument), commandTarget.getGfshMethodTarget())) {
                                if (completionCandidates.size() > 0) {
                                    if (this.perfectMatch(completionCandidates, userOptionSet.getValue(argument))) {
                                        completionCandidates.clear();
                                    } else {
                                        this.modifyCompletionCandidates(completionCandidates, argumentSeparator, userOptionSet.getValue(argument));
                                        if (completionCandidates.size() > 0) {
                                            incrementCursor = false;
                                        }
                                    }
                                }
                            } else {
                                completionCandidates.clear();
                            }
                            if (incrementCursor) {
                                desiredCursorPosition += userOptionSet.getValue(argument).length() + argumentSeparator.length();
                            }
                        } else {
                            if (argument.isRequired()) {
                                if (this.getAllPossibleValuesForParameter(completionCandidates, argument, null, commandTarget.getGfshMethodTarget())) {
                                    if (completionCandidates.size() == 0) {
                                        warning = true;
                                    }
                                } else {
                                    completionCandidates.clear();
                                    warning = true;
                                }
                            } else {
                                boolean checkForPossibleValues = true;
                                if (this.endsWithOptionSpecifiers(userOptionSet.getUserInput()) || this.hasOptionSpecified(userOptionSet.getUserInput())) {
                                    checkForPossibleValues = false;
                                }
                                if (checkForPossibleValues) {
                                    this.getAllPossibleValuesForParameter(completionCandidates, argument, null, commandTarget.getGfshMethodTarget());
                                }
                            }
                            if (completionCandidates.size() > 0) {
                                this.modifyCompletionCandidates(completionCandidates, argumentSeparator, null);
                            }
                        }
                        if (warning) {
                            String argMessage = argument.getArgumentName() + (argument.getHelp() != null && !argument.getHelp().equals("") ? ": " + argument.getHelp() : "");
                            this.logWarning(CliStrings.format("Required Argument: \"{0}\"", (Object)argMessage));
                            return desiredCursorPosition + userOptionSet.getNoOfSpacesRemoved();
                        }
                    }
                    argumentSeparator = "?";
                }
                if (completionCandidates.size() > 0) {
                    return desiredCursorPosition + userOptionSet.getNoOfSpacesRemoved();
                }
                boolean warningValueRequired = false;
                Option warningOption = null;
                for (Option option : commandTarget.getOptionParser().getOptions()) {
                    if (userOptionSet.hasOption(option)) {
                        block4: for (String string : userOptionSet.getSplit()) {
                            if (!string.startsWith("--")) continue;
                            string = StringUtils.removePrefix(string, "--");
                            if ((string = StringUtils.removeSuffix(string, "=")).equals("")) continue;
                            if (option.getLongOption().equals(string)) {
                                desiredCursorPosition += 1 + "--".length() + option.getLongOption().length();
                                break;
                            }
                            for (String optionSynonym : option.getSynonyms()) {
                                if (!optionSynonym.equals(string)) continue;
                                desiredCursorPosition += 1 + "--".length() + optionSynonym.length();
                                continue block4;
                            }
                        }
                        optionsPresentMap.put(option.getLongOption(), option);
                        if (userOptionSet.hasValue(option)) {
                            String value2 = userOptionSet.getValue(option);
                            boolean valueActuallySpecified = false;
                            String valueSeparator = ",";
                            if (option.getValueSeparator() != null) {
                                valueSeparator = option.getValueSeparator();
                            }
                            boolean bufferEndsWithValueSeparator = remainingBuffer.endsWith(valueSeparator);
                            for (String userOptionElement : userOptionSet.getSplit()) {
                                if (!userOptionElement.equals(value2) && !userOptionElement.equals(value2 + valueSeparator)) continue;
                                valueActuallySpecified = true;
                            }
                            if (!valueActuallySpecified) continue;
                            boolean incrementCursor = true;
                            boolean considerLastValue = false;
                            int lengthToBeAdded = 0;
                            int lastIndexOf = 0;
                            if (completionCandidates.size() == 0) {
                                if (!this.endsWithOptionSpecifiers(userOptionSet.getUserInput()) && this.getAllPossibleValuesForParameter(completionCandidates, option, value2, commandTarget.getGfshMethodTarget())) {
                                    String prefix = "";
                                    String[] split = ParserUtils.splitValues(value2, valueSeparator);
                                    if (completionCandidates.size() > 0) {
                                        if (PreprocessorUtils.isSyntaxValid(value2).booleanValue() && bufferEndsWithValueSeparator) {
                                            prefix = valueSeparator;
                                        } else if (this.perfectMatch(completionCandidates, split)) {
                                            completionCandidates.clear();
                                            considerLastValue = true;
                                        } else if (ParserUtils.contains(value2, valueSeparator)) {
                                            prefix = valueSeparator;
                                        } else {
                                            incrementCursor = false;
                                            prefix = value2.startsWith(" ") ? "  " : (value2.startsWith("\n") ? "\n" : "=");
                                        }
                                    }
                                    this.modifyCompletionCandidates(completionCandidates, prefix, bufferEndsWithValueSeparator, split);
                                    if (completionCandidates.size() == 0) {
                                        incrementCursor = true;
                                        considerLastValue = true;
                                    }
                                } else {
                                    completionCandidates.clear();
                                    considerLastValue = true;
                                }
                            } else {
                                considerLastValue = true;
                            }
                            lastIndexOf = ParserUtils.lastIndexOf(bufferEndsWithValueSeparator ? value2 + valueSeparator : value2, valueSeparator);
                            lengthToBeAdded = value2.substring(0, lastIndexOf > 0 ? lastIndexOf : value2.length()).length();
                            if (incrementCursor) {
                                desiredCursorPosition += "=".length() + lengthToBeAdded + (considerLastValue ? value2.length() - lengthToBeAdded : 0);
                                if (value2.endsWith(" ") && considerLastValue) {
                                    --desiredCursorPosition;
                                }
                            }
                            if (completionCandidates.size() == 0) {
                                if (!PreprocessorUtils.isSyntaxValid(value2).booleanValue()) {
                                    return desiredCursorPosition + userOptionSet.getNoOfSpacesRemoved();
                                }
                                if (value2.endsWith(valueSeparator)) {
                                    return desiredCursorPosition + userOptionSet.getNoOfSpacesRemoved();
                                }
                            }
                        } else if (completionCandidates.size() == 0) {
                            if (this.getAllPossibleValuesForParameter(completionCandidates, option, null, commandTarget.getGfshMethodTarget())) {
                                if (completionCandidates.size() == 0) {
                                    warningValueRequired = true;
                                } else {
                                    this.modifyCompletionCandidates(completionCandidates, "=", new String[]{null});
                                }
                            } else {
                                completionCandidates.clear();
                                warningValueRequired = true;
                            }
                        }
                    } else {
                        block7: for (String userOptString : userOptionSet.getSplit()) {
                            if (!userOptString.startsWith("--")) continue;
                            userOptString = StringUtils.removePrefix(userOptString, "--");
                            if (option.getLongOption().startsWith(userOptString) && !userOptString.equals("") && !option.getLongOption().equals(userOptString) && !optionsPresentMap.containsKey(userOptString)) {
                                completionCandidates.add(new Completion(" --" + option.getLongOption(), option.getLongOption(), "", 0));
                                continue;
                            }
                            for (String optionSynonym : option.getSynonyms()) {
                                if (!optionSynonym.startsWith(userOptString) || userOptString.equals("") || optionSynonym.equals(userOptString)) continue;
                                completionCandidates.add(new Completion(" --" + optionSynonym, optionSynonym, "", 0));
                                continue block7;
                            }
                        }
                        if (completionCandidates.size() == 0) {
                            if (option.isRequired()) {
                                mandatoryOptions.add(option);
                            } else {
                                unspecifiedOptions.add(option);
                            }
                        }
                    }
                    if (!warningValueRequired) continue;
                    warningOption = option;
                    warningValueRequired = false;
                }
                if (warningOption != null) {
                    String optionMsg = warningOption.getLongOption() + (warningOption.getHelp() != null && !warningOption.getHelp().equals("") ? ": " + warningOption.getHelp() : "");
                    this.logWarning(CliStrings.format("Value is required for parameter \"{0}\"", (Object)optionMsg));
                    completionCandidates.add(new Completion("=", "", null, 0));
                    return desiredCursorPosition += userOptionSet.getNoOfSpacesRemoved();
                }
            }
            newCursor = desiredCursorPosition + (userOptionSet != null ? userOptionSet.getNoOfSpacesRemoved() : 0);
            String subString = remainingBuffer;
            if (newCursor != cursorStart) {
                subString = remainingBuffer.substring(newCursor + (sizeReduced ? -1 : 0) - cursorStart).trim();
            }
            if (!(coe == null || newCursor >= cursor || completionCandidates.size() != 0 || PreprocessorUtils.containsOnlyWhiteSpaces(subString) || subString.endsWith("--") && subString.startsWith("--") || subString.startsWith("-") && subString.endsWith("-"))) {
                ExceptionHandler.handleException(coe);
                return cursor;
            }
            if (completionCandidates.size() != 0) break block71;
            if (mandatoryOptions.size() > 0) {
                for (Option option : mandatoryOptions) {
                    completionCandidates.add(new Completion(" --" + option.getLongOption(), option.getLongOption(), "", 0));
                }
            } else {
                unspecifiedOptions = this.getUnspecifiedOptionsWithMode(unspecifiedOptions, commandTarget, optionsPresentMap);
                for (Option option : unspecifiedOptions) {
                    completionCandidates.add(new Completion(" --" + option.getLongOption(), option.getLongOption(), "", 0));
                }
            }
        }
        return newCursor;
    }

    private List<Option> getUnspecifiedOptionsWithMode(List<Option> unspecifiedOptions, CommandTarget commandTarget, Map<String, Option> optionsPresentMap) {
        Collection<CommandModes.CommandMode> cmodes = CommandModes.getInstance().getCommandModes(commandTarget.getCommandName());
        if (cmodes != null) {
            ArrayList<Option> filteredList = new ArrayList<Option>();
            CommandModes.CommandMode defaultMode = CommandModes.getInstance().getCommandMode(commandTarget.getCommandName(), "default");
            for (String opt : defaultMode.options) {
                for (Option option : unspecifiedOptions) {
                    if (!option.getLongOption().equals(opt)) continue;
                    filteredList.add(option);
                }
            }
            boolean leadOptionFound = false;
            for (CommandModes.CommandMode cmd : cmodes) {
                if (!optionsPresentMap.containsKey(cmd.leadOption)) continue;
                leadOptionFound = true;
                for (String opt : cmd.options) {
                    if (optionsPresentMap.containsKey(opt)) continue;
                    for (Option option : unspecifiedOptions) {
                        if (!option.getLongOption().equals(opt)) continue;
                        filteredList.add(option);
                    }
                }
            }
            if (leadOptionFound) {
                return filteredList;
            }
            if (optionsPresentMap.isEmpty()) {
                filteredList.clear();
                for (CommandModes.CommandMode cmd2 : cmodes) {
                    for (Option option2 : unspecifiedOptions) {
                        if (!option2.getLongOption().equals(cmd2.leadOption)) continue;
                        filteredList.add(option2);
                    }
                }
                return filteredList;
            }
            return unspecifiedOptions;
        }
        return unspecifiedOptions;
    }

    private void checkOptionSetForValidCommandModes(OptionSet userOptionSet, CommandTarget commandTarget) throws CliCommandMultiModeOptionException {
        CommandModes modes = CommandModes.getInstance();
        Collection<CommandModes.CommandMode> cmodes = modes.getCommandModes(commandTarget.getCommandName());
        if (cmodes != null) {
            CommandModes.CommandMode defaultMode = modes.getCommandMode(commandTarget.getCommandName(), "default");
            HashMap<String, Option> userOptions = new HashMap<String, Option>();
            HashMap<String, CommandModes.CommandMode> loToModeMap = new HashMap<String, CommandModes.CommandMode>();
            for (Option option : commandTarget.getOptionParser().getOptions()) {
                if (!userOptionSet.hasOption(option)) continue;
                userOptions.put(option.getLongOption(), option);
            }
            ArrayList<String> leadOptionList = new ArrayList<String>();
            for (CommandModes.CommandMode cmd : cmodes) {
                loToModeMap.put(cmd.leadOption, cmd);
                if (userOptions.containsKey(cmd.leadOption)) {
                    leadOptionList.add(cmd.leadOption);
                }
                if (leadOptionList.size() <= 1) continue;
                StringBuilder sb = new StringBuilder();
                for (String leadOption : leadOptionList) {
                    sb.append(((CommandModes.CommandMode)loToModeMap.get((Object)leadOption)).name).append(",");
                }
                throw new CliCommandMultiModeOptionException(commandTarget, (Option)userOptions.get(cmd.leadOption), sb.toString(), 1);
            }
            if (leadOptionList.size() == 1) {
                CommandModes.CommandMode modeDetected = (CommandModes.CommandMode)loToModeMap.get(leadOptionList.get(0));
                for (Option opt : userOptions.values()) {
                    if (this.isDefaultOption(opt.getLongOption(), defaultMode)) continue;
                    boolean isOptionFromDetectedMode = false;
                    if (modeDetected.options.length <= 0) continue;
                    for (String commandOpt : modeDetected.options) {
                        if (!commandOpt.equals(opt.getLongOption())) continue;
                        isOptionFromDetectedMode = true;
                    }
                    if (isOptionFromDetectedMode) continue;
                    throw new CliCommandMultiModeOptionException(commandTarget, opt, opt.getLongOption(), 2);
                }
            }
        }
    }

    private boolean isDefaultOption(String longOption, CommandModes.CommandMode commandMode) {
        for (String str : commandMode.options) {
            if (!longOption.equals(str)) continue;
            return true;
        }
        return false;
    }

    private boolean endsWithOptionSpecifiers(String userInput) {
        return (userInput = userInput.trim()).endsWith(" --") || userInput.endsWith(" -");
    }

    private boolean hasOptionSpecified(String userInput) {
        userInput = userInput.trim();
        return Pattern.matches("^(.*)(-+)(\\w+)(.*)$", userInput);
    }

    private String getSystemProvidedValue(Parameter parameter) {
        if (parameter.isSystemProvided()) {
            return null;
        }
        return null;
    }

    private boolean perfectMatch(List<Completion> completionCandidates, String ... argumentValue) {
        if (argumentValue.length > 0) {
            for (Completion completion : completionCandidates) {
                if (!completion.getValue().equals(argumentValue[argumentValue.length - 1])) continue;
                return true;
            }
        }
        return false;
    }

    private void modifyCompletionCandidates(List<Completion> completionCandidates, String prefix, String ... existingData) {
        this.modifyCompletionCandidates(completionCandidates, prefix, false, existingData);
    }

    private void modifyCompletionCandidates(List<Completion> completionCandidates, String prefix, boolean endsWithValueSeparator, String ... existingData) {
        ArrayList<Completion> temp = new ArrayList<Completion>();
        while (completionCandidates.size() > 0) {
            temp.add(completionCandidates.remove(0));
        }
        for (Completion completion : temp) {
            boolean includeCompletion = true;
            String value2 = completion.getValue();
            if (existingData != null) {
                for (String string : existingData) {
                    if (string == null || !value2.equals(string)) continue;
                    includeCompletion = false;
                }
                if (includeCompletion && existingData[existingData.length - 1] != null && !value2.startsWith(existingData[existingData.length - 1]) && !endsWithValueSeparator) {
                    includeCompletion = false;
                }
            }
            if (!includeCompletion) continue;
            completionCandidates.add(new Completion(prefix + completion.getValue(), completion.getValue(), "", 0));
        }
    }

    private boolean getAllPossibleValuesForParameter(List<Completion> completionCandidates, Parameter parameter, String existingData, GfshMethodTarget gfshMethodTarget) {
        Converter<?> converter = parameter.getConverter();
        if (converter == null) {
            parameter.setConverter(this.commandManager.getConverter(parameter.getDataType(), parameter.getContext()));
            converter = parameter.getConverter();
        }
        if (converter == null) {
            return false;
        }
        String valueSeparator = ",";
        if (parameter instanceof Option && ((Option)parameter).getValueSeparator() != null) {
            valueSeparator = ((Option)parameter).getValueSeparator();
        }
        if (converter instanceof MultipleValueConverter) {
            ((MultipleValueConverter)converter).getAllPossibleValues(completionCandidates, parameter.getDataType(), ParserUtils.splitValues(existingData, valueSeparator), parameter.getContext(), new MethodTarget(gfshMethodTarget.getMethod(), gfshMethodTarget.getTarget(), gfshMethodTarget.getRemainingBuffer(), gfshMethodTarget.getKey()));
        } else {
            converter.getAllPossibleValues(completionCandidates, parameter.getDataType(), existingData, parameter.getContext(), new MethodTarget(gfshMethodTarget.getMethod(), gfshMethodTarget.getTarget(), gfshMethodTarget.getRemainingBuffer(), gfshMethodTarget.getKey()));
        }
        return completionCandidates.size() > 0;
    }

    public ParseResult parse(String userInput) {
        GfshParseResult parseResult;
        block18: {
            parseResult = null;
            if (ParserUtils.contains(userInput = StringUtils.trimTrailingWhitespace(userInput), ";") && StringUtils.endsWithIgnoreCase(userInput, ";")) {
                userInput = StringUtils.removeSuffix(userInput, ";");
            }
            try {
                boolean error = false;
                CliCommandOptionException coe = null;
                List<CommandTarget> targets = this.locateTargets(ParserUtils.trimBeginning(userInput), false);
                if (targets.size() > 1) {
                    if (userInput.length() > 0) {
                        this.handleCondition(CliStrings.format("Ambigious command \"{0}\" (for assistance press \"{1}\" or type \"hint\" or \"help <command name>\" & then hit ENTER)", userInput, AbstractShell.completionKeys), CommandProcessingException.COMMAND_NAME_AMBIGUOUS, userInput);
                    }
                    break block18;
                }
                if (targets.size() == 1) {
                    GfshMethodTarget gfshMethodTarget;
                    CommandTarget commandTarget;
                    HashMap<String, String> paramValMap;
                    ArrayList<MethodParameter> parameters;
                    OptionSet parse;
                    block19: {
                        parse = null;
                        parameters = new ArrayList<MethodParameter>();
                        paramValMap = new HashMap<String, String>();
                        commandTarget = targets.get(0);
                        gfshMethodTarget = commandTarget.getGfshMethodTarget();
                        this.preConfigureConverters(commandTarget);
                        try {
                            parse = commandTarget.getOptionParser().parse(gfshMethodTarget.getRemainingBuffer());
                        }
                        catch (CliException ce) {
                            if (!(ce instanceof CliCommandOptionException)) break block19;
                            coe = (CliCommandOptionException)ce;
                            coe.setCommandTarget(commandTarget);
                            parse = coe.getOptionSet();
                            error = true;
                        }
                    }
                    try {
                        this.checkOptionSetForValidCommandModes(parse, commandTarget);
                    }
                    catch (CliCommandMultiModeOptionException ce) {
                        error = true;
                        coe = ce;
                    }
                    error = this.processArguments(parse, commandTarget, paramValMap, parameters, error);
                    error = this.processOptions(parse, commandTarget, paramValMap, parameters, error);
                    if (!error) {
                        Object[] methodParameters = new Object[parameters.size()];
                        for (MethodParameter parameter : parameters) {
                            methodParameters[parameter.getParameterNo()] = parameter.getParameter();
                        }
                        parseResult = new GfshParseResult(gfshMethodTarget.getMethod(), gfshMethodTarget.getTarget(), methodParameters, userInput, paramValMap);
                    } else if (coe != null) {
                        logWrapper.fine("Handling exception: " + coe.getMessage());
                        ExceptionHandler.handleException(coe);
                        if (!CliUtil.isGfshVM()) {
                            this.handleCondition(CliStrings.format("Invalid command String: {0}", (Object)userInput), coe, CommandProcessingException.COMMAND_INVALID, userInput);
                        }
                    }
                    break block18;
                }
                String message = CliStrings.format("Command \"{0}\" is not valid.", (Object)userInput);
                CommandTarget commandTarget = this.locateExactMatchingTarget(userInput);
                if (commandTarget != null) {
                    String commandName = commandTarget.getCommandName();
                    AvailabilityTarget availabilityIndicator = commandTarget.getAvailabilityIndicator();
                    message = CliStrings.format("\"{0}\" is not available. Reason: {1}", commandName, availabilityIndicator.getAvailabilityDescription());
                }
                this.handleCondition(message, CommandProcessingException.COMMAND_INVALID_OR_UNAVAILABLE, userInput);
            }
            catch (IllegalArgumentException e1) {
                logWrapper.warning(CliUtil.stackTraceAsString(e1));
            }
            catch (IllegalAccessException e1) {
                logWrapper.warning(CliUtil.stackTraceAsString(e1));
            }
            catch (InvocationTargetException e1) {
                logWrapper.warning(CliUtil.stackTraceAsString(e1));
            }
        }
        return parseResult;
    }

    private void preConfigureConverters(CommandTarget commandTarget) {
        Converter<?> converter;
        for (Option option : commandTarget.getOptionParser().getOptions()) {
            converter = option.getConverter();
            if (converter != null) continue;
            option.setConverter(this.commandManager.getConverter(option.getDataType(), option.getContext()));
            converter = option.getConverter();
        }
        for (Argument argument : commandTarget.getOptionParser().getArguments()) {
            converter = argument.getConverter();
            if (converter != null) continue;
            argument.setConverter(this.commandManager.getConverter(argument.getDataType(), argument.getContext()));
            converter = argument.getConverter();
        }
    }

    private boolean processOptions(OptionSet parse, CommandTarget commandTarget, Map<String, String> paramValMap, List<MethodParameter> parameters, boolean errorState) {
        boolean error = errorState;
        for (Option option : commandTarget.getOptionParser().getOptions()) {
            String value2 = null;
            if (parse.hasOption(option)) {
                if (parse.hasValue(option)) {
                    value2 = parse.getValue(option);
                }
                if (value2 == null) {
                    this.handleCondition(CliStrings.format("Value is required for parameter \"{0}\"", (Object)option.getLongOption()), CommandProcessingException.OPTION_VALUE_REQUIRED, option.getLongOption());
                    logWrapper.fine("Value required for Parameter " + option.getLongOption());
                    error = true;
                }
            } else if (option.isRequired()) {
                this.handleCondition(CliStrings.format("Parameter \"{0}\" is required. Use \"help <command name>\" for assistance.", (Object)option.getLongOption()), CommandProcessingException.REQUIRED_OPTION_MISSING, option.getLongOption());
                logWrapper.fine("Required Parameter " + option.getLongOption());
                error = true;
            } else {
                value2 = option.getUnspecifiedDefaultValue();
                if (value2 == null) {
                    value2 = this.getSystemProvidedValue(option);
                }
            }
            String valueSeparator = ",";
            if (option.getValueSeparator() != null) {
                valueSeparator = option.getValueSeparator();
            }
            Object object = this.getConversionObject(option.getConverter(), value2, option.getDataType(), option.getContext(), valueSeparator);
            if (value2 != null && object == null) {
                this.handleCondition(CliStrings.format("Value \"{0}\" is not applicable for \"{1}\".", value2.trim(), option.getLongOption()), CommandProcessingException.OPTION_VALUE_INVALID, option.getLongOption() + "=" + value2);
                logWrapper.fine("Value \"" + value2.trim() + "\" is not applicable for " + option.getLongOption());
                error = true;
            }
            parameters.add(new MethodParameter(object, option.getParameterNo()));
            paramValMap.put(option.getLongOption(), value2);
        }
        return error;
    }

    private boolean processArguments(OptionSet parse, CommandTarget commandTarget, Map<String, String> paramValMap, List<MethodParameter> parameters, boolean errorState) {
        boolean error = errorState;
        for (Argument argument : commandTarget.getOptionParser().getArguments()) {
            String value2 = null;
            if (parse.hasArgument(argument)) {
                value2 = parse.getValue(argument);
            } else if (argument.isRequired()) {
                this.handleCondition(CliStrings.format("Command parameter \"{0}\" is required. Use \"help <command name>\" for assistance.", (Object)argument.getArgumentName()), CommandProcessingException.REQUIRED_ARGUMENT_MISSING, argument.getArgumentName());
                logWrapper.fine("Required Argument " + argument.getArgumentName());
                error = true;
            } else {
                value2 = argument.getUnspecifiedDefaultValue();
                if (value2 == null) {
                    value2 = this.getSystemProvidedValue(argument);
                }
            }
            Object conversionObject = this.getConversionObject(argument.getConverter(), value2, argument.getDataType(), argument.getContext(), ",");
            if (value2 != null && conversionObject == null) {
                this.handleCondition(CliStrings.format("Value \"{0}\" is not applicable for \"{1}\".", value2.trim(), argument.getArgumentName()), CommandProcessingException.ARGUMENT_INVALID, argument.getArgumentName() + "=" + value2);
                logWrapper.fine("Value '" + value2.trim() + "' not applicable for argument: " + argument.getArgumentName());
                error = true;
                continue;
            }
            parameters.add(new MethodParameter(conversionObject, argument.getParameterNo()));
            paramValMap.put(argument.getArgumentName(), value2);
        }
        return error;
    }

    private Object getConversionObject(Converter<?> converter, String string, Class<?> dataType, String context, String valueSeparator) {
        block14: {
            try {
                if (converter != null && converter instanceof MultipleValueConverter) {
                    return ((MultipleValueConverter)converter).convertFromText(ParserUtils.splitValues(string != null ? string.trim() : null, valueSeparator), dataType, context);
                }
                if (string != null && (string.endsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'"))) {
                    string = string.substring(1, string.length() - 1);
                }
                if (converter != null) {
                    return converter.convertFromText(string != null ? string.trim() : null, dataType, context);
                }
                if (string == null) break block14;
                if (String.class.isAssignableFrom(dataType)) {
                    return string.trim();
                }
                if (Byte.class.isAssignableFrom(dataType) || Byte.TYPE.isAssignableFrom(dataType)) {
                    return Integer.parseInt(string);
                }
                if (Short.class.isAssignableFrom(dataType) || Short.TYPE.isAssignableFrom(dataType)) {
                    return Integer.parseInt(string);
                }
                if (Boolean.class.isAssignableFrom(dataType) || Boolean.TYPE.isAssignableFrom(dataType)) {
                    return Integer.parseInt(string);
                }
                if (Integer.class.isAssignableFrom(dataType) || Integer.TYPE.isAssignableFrom(dataType)) {
                    return Integer.parseInt(string);
                }
                if (Long.class.isAssignableFrom(dataType) || Long.TYPE.isAssignableFrom(dataType)) {
                    return Long.parseLong(string);
                }
                if (Float.class.isAssignableFrom(dataType) || Float.TYPE.isAssignableFrom(dataType)) {
                    return Float.valueOf(Float.parseFloat(string));
                }
                if (Double.class.isAssignableFrom(dataType) || Double.TYPE.isAssignableFrom(dataType)) {
                    return Double.parseDouble(string);
                }
                if (!Character.class.isAssignableFrom(dataType) && !Character.TYPE.isAssignableFrom(dataType)) break block14;
                if (string.length() == 1) {
                    string.charAt(0);
                    break block14;
                }
                return Character.valueOf('0');
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private List<CommandTarget> locateTargets(String userInput) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.locateTargets(userInput, true);
    }

    private List<CommandTarget> locateTargets(String userInput, boolean matchIncomplete) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ArrayList<CommandTarget> commandTargets = new ArrayList<CommandTarget>();
        Map<String, CommandTarget> commands = this.commandManager.getCommands();
        for (String commandName : commands.keySet()) {
            CommandTarget commandTarget;
            if (userInput.startsWith(commandName)) {
                String remainingBuffer;
                commandTarget = commands.get(commandName);
                if (!this.isAvailable(commandTarget, commandName) || (remainingBuffer = StringUtils.removePrefix(userInput, commandName)).length() != 0 && !remainingBuffer.startsWith(" ") && !remainingBuffer.startsWith(LINE_SEPARATOR) || commandTargets.contains(commandTarget)) continue;
                commandTargets.add(commandTarget.duplicate(commandName, remainingBuffer));
                continue;
            }
            if (!matchIncomplete || !commandName.startsWith(userInput) || !this.isAvailable(commandTarget = commands.get(commandName), commandName) || commandTargets.contains(commandTarget)) continue;
            commandTargets.add(commandTarget.duplicate(commandName));
        }
        return commandTargets;
    }

    private CommandTarget locateExactMatchingTarget(String userInput) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        CommandTarget commandTarget = null;
        Map<String, CommandTarget> commandTargetsMap = this.commandManager.getCommands();
        TreeSet commandNamesReverseSorted = new TreeSet(Collections.reverseOrder());
        commandNamesReverseSorted.addAll(commandTargetsMap.keySet());
        for (String commandName : commandNamesReverseSorted) {
            if (!userInput.startsWith(commandName) || !GfshParser.commandWordsMatch(userInput, commandName) || (commandTarget = commandTargetsMap.get(commandName)) == null) continue;
            String remainingBuffer = StringUtils.removePrefix(userInput, commandName);
            commandTarget = commandTarget.duplicate(commandName, remainingBuffer);
            break;
        }
        return commandTarget;
    }

    private static boolean commandWordsMatch(String userInput, String commandName) {
        String[] userInputWords;
        boolean commandWordsMatch = true;
        String[] commandNameWords = commandName.split(" ");
        if (commandNameWords.length <= (userInputWords = userInput.split(" ")).length) {
            for (int i = 0; i < commandNameWords.length; ++i) {
                if (commandNameWords[i].equals(userInputWords[i])) continue;
                commandWordsMatch = false;
                break;
            }
        } else {
            commandWordsMatch = false;
        }
        return commandWordsMatch;
    }

    private Map<String, CommandTarget> getRequiredCommandTargets(Set<String> requiredCommands) {
        Map<String, CommandTarget> existingCommands;
        Map<String, CommandTarget> requiredCommandsMap = existingCommands = this.commandManager.getCommands();
        if (requiredCommands != null && !requiredCommands.isEmpty()) {
            requiredCommandsMap = new TreeMap<String, CommandTarget>();
            for (String commandName : requiredCommands) {
                CommandTarget commandTarget = existingCommands.get(commandName);
                if (commandTarget == null) continue;
                requiredCommandsMap.put(commandName, commandTarget);
            }
        }
        return requiredCommandsMap;
    }

    private Map<Short, List<CommandTarget>> findMatchingCommands(String userSpecifiedCommand, Set<String> requiredCommands) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Map<String, CommandTarget> existingCommands = this.getRequiredCommandTargets(requiredCommands);
        CommandTarget exactCommandTarget = existingCommands.get(userSpecifiedCommand);
        List<Object> exactCommandTargets = Collections.emptyList();
        if (exactCommandTarget != null) {
            exactCommandTargets = Collections.singletonList(exactCommandTarget);
        }
        ArrayList<CommandTarget> possibleCommandTargets = new ArrayList<CommandTarget>();
        for (Map.Entry<String, CommandTarget> entry : existingCommands.entrySet()) {
            CommandTarget commandTarget = entry.getValue();
            String commandName = commandTarget.getCommandName();
            if (!entry.getKey().equals(commandName) || !commandName.startsWith(userSpecifiedCommand) || commandTarget.equals(exactCommandTarget)) continue;
            possibleCommandTargets.add(commandTarget);
        }
        HashMap<Short, List<CommandTarget>> commandTargetsArr = new HashMap<Short, List<CommandTarget>>();
        commandTargetsArr.put(EXACT_TARGET, exactCommandTargets);
        commandTargetsArr.put(MATCHING_TARGETS, possibleCommandTargets);
        return commandTargetsArr;
    }

    private boolean isAvailable(CommandTarget commandTarget, String commandName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        AvailabilityTarget availabilityIndicator = commandTarget.getAvailabilityIndicator();
        if (availabilityIndicator == null) {
            availabilityIndicator = this.commandManager.getAvailabilityIndicator(commandName);
            commandTarget.setAvailabilityIndicator(availabilityIndicator);
        }
        return commandTarget.isAvailable();
    }

    public List<String> obtainHelpCommandNames(String userInput) {
        ArrayList<String> commandNames = new ArrayList<String>();
        try {
            if (userInput == null) {
                userInput = "";
            }
            ArrayList commandTargets = new ArrayList();
            Map<Short, List<CommandTarget>> matchingCommandsMap = this.findMatchingCommands(userInput, null);
            commandTargets.addAll(matchingCommandsMap.get(EXACT_TARGET));
            commandTargets.addAll(matchingCommandsMap.get(MATCHING_TARGETS));
            for (CommandTarget commandTarget : commandTargets) {
                commandNames.add(commandTarget.getCommandName());
            }
        }
        catch (IllegalArgumentException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (IllegalAccessException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (InvocationTargetException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        return commandNames;
    }

    public String obtainHelp(String userInput, Set<String> commandNames) {
        boolean withinShell = commandNames == null || commandNames.isEmpty();
        String appName = withinShell ? "" : "gfsh ";
        StringBuilder helpText = new StringBuilder();
        try {
            if (userInput == null) {
                userInput = "";
            }
            Map<Short, List<CommandTarget>> matchingCommandsMap = this.findMatchingCommands(userInput, commandNames);
            List<CommandTarget> exactCommandTargets = matchingCommandsMap.get(EXACT_TARGET);
            List<CommandTarget> matchingCommandTargets = matchingCommandsMap.get(MATCHING_TARGETS);
            matchingCommandsMap.clear();
            if (exactCommandTargets.isEmpty() && matchingCommandTargets.isEmpty()) {
                helpText.append("No matching command").append(LINE_SEPARATOR);
            } else if (exactCommandTargets.size() == 1) {
                helpText.append(this.obtainCommandSpecificHelp(exactCommandTargets.get(0), withinShell));
                if (!matchingCommandTargets.isEmpty()) {
                    helpText.append(LINE_SEPARATOR);
                    helpText.append(CliStrings.format("Other commands starting with \"{0}\" are: ", (Object)userInput));
                    for (int i = 0; i < matchingCommandTargets.size(); ++i) {
                        CommandTarget commandTarget = matchingCommandTargets.get(i);
                        helpText.append(commandTarget.getCommandName());
                        if (i >= matchingCommandTargets.size() - 1) continue;
                        helpText.append(", ");
                    }
                    helpText.append(LINE_SEPARATOR);
                }
            } else {
                ArrayList<CommandTarget> commandTargets = new ArrayList<CommandTarget>();
                commandTargets.addAll(exactCommandTargets);
                commandTargets.addAll(matchingCommandTargets);
                for (CommandTarget commandTarget : commandTargets) {
                    String availability = commandTarget.isAvailable() ? "Available" : "Not Available";
                    helpText.append(commandTarget.getCommandName());
                    if (withinShell) {
                        helpText.append(" (").append(availability).append(")");
                    }
                    helpText.append(LINE_SEPARATOR);
                    helpText.append(Gfsh.wrapText(commandTarget.getCommandHelp(), 1)).append(LINE_SEPARATOR);
                }
                helpText.append(LINE_SEPARATOR);
                if (withinShell) {
                    helpText.append(Gfsh.wrapText(CliStrings.format("Use {0}help <command name> to display detailed usage information for a specific command.", (Object)appName), 0)).append(LINE_SEPARATOR);
                    helpText.append(Gfsh.wrapText(CliStrings.format("Help with command and parameter completion can also be obtained by entering all or a portion of either followed by the \"{0}\" key.", (Object)AbstractShell.completionKeys), 0));
                }
            }
        }
        catch (IllegalArgumentException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (IllegalAccessException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (InvocationTargetException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        return helpText.toString();
    }

    private String obtainCommandSpecificHelp(CommandTarget commandTarget, boolean withinShell) {
        NewHelp newHelp = HelpUtils.getNewHelp(commandTarget, withinShell);
        return newHelp.toString();
    }

    public List<String> getCommandNames(String string) {
        ArrayList<String> commandNames = new ArrayList<String>();
        try {
            if (string == null) {
                string = "";
            }
            List<CommandTarget> locateTargets = this.locateTargets(string);
            for (CommandTarget commandTarget : locateTargets) {
                String key2 = commandTarget.getGfshMethodTarget().getKey();
                if (!key2.startsWith(string)) continue;
                commandNames.add(key2);
            }
        }
        catch (IllegalArgumentException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (IllegalAccessException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        catch (InvocationTargetException e) {
            logWrapper.warning(CliUtil.stackTraceAsString(e));
        }
        return commandNames;
    }

    private void handleCondition(String message, int errorType, Object errorData) {
        this.handleCondition(message, null, errorType, errorData);
    }

    private void handleCondition(String message, Throwable th, int errorType, Object errorData) {
        if (!CliUtil.isGfshVM()) {
            if (th != null) {
                throw new CommandProcessingException(message + ": " + th.getMessage(), errorType, errorData);
            }
            throw new CommandProcessingException(message, errorType, errorData);
        }
        this.logWarning(message);
    }

    private void logWarning(String message) {
        if (this.canLogToConsole()) {
            this.consoleLogger.warning(CLIConsoleBufferUtil.processMessegeForExtraCharactersFromConsoleBuffer(message));
        } else {
            Gfsh.println(message);
        }
    }

    private boolean canLogToConsole() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return gfsh != null && !gfsh.isHeadlessMode() && this.consoleLogger != null;
    }
}

