/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli;

import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import java.text.DateFormat;
import java.util.Date;

public class CommandResponse {
    private final String sender;
    private final String version;
    private final int status;
    private final String contentType;
    private final String page;
    private final String when;
    private final String tokenAccessor;
    private final String debugInfo;
    private final Data data;
    private final boolean failedToPersist;

    CommandResponse(String sender, String contentType, int status, String page, String tokenAccessor, String debugInfo, String header, GfJsonObject content, String footer, boolean failedToPersist) {
        this.sender = sender;
        this.contentType = contentType;
        this.status = status;
        this.page = page;
        this.tokenAccessor = tokenAccessor;
        this.debugInfo = debugInfo;
        this.data = new Data(header, content, footer);
        this.when = DateFormat.getInstance().format(new Date());
        this.version = GemFireVersion.getGemFireVersion();
        this.failedToPersist = failedToPersist;
    }

    CommandResponse(GfJsonObject jsonObject) {
        this.sender = jsonObject.getString("sender");
        this.contentType = jsonObject.getString("contentType");
        this.status = jsonObject.getInt("status");
        this.page = jsonObject.getString("page");
        this.tokenAccessor = jsonObject.getString("tokenAccessor");
        this.debugInfo = jsonObject.getString("debugInfo");
        this.data = new Data(jsonObject.getJSONObject("data"));
        this.when = jsonObject.getString("when");
        this.version = jsonObject.getString("version");
        this.failedToPersist = jsonObject.getBoolean("failedToPersist");
    }

    public String getSender() {
        return this.sender;
    }

    public String getVersion() {
        return this.version;
    }

    public int getStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getPage() {
        return this.page;
    }

    public String getWhen() {
        return this.when;
    }

    public String getTokenAccessor() {
        return this.tokenAccessor;
    }

    public Data getData() {
        return this.data;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public boolean isFailedToPersist() {
        return this.failedToPersist;
    }

    public static class Data {
        private String header;
        private GfJsonObject content;
        private String footer;

        public Data(String header, GfJsonObject content, String footer) {
            this.header = header;
            this.content = content;
            this.footer = footer;
        }

        public Data(GfJsonObject dataJsonObject) {
            this.header = dataJsonObject.getString("header");
            this.content = dataJsonObject.getJSONObject("content");
            this.footer = dataJsonObject.getString("footer");
        }

        public String getHeader() {
            return this.header;
        }

        public Object getContent() {
            return this.content.getInternalJsonObject();
        }

        public String getFooter() {
            return this.footer;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Data [header=").append(this.header).append(", content=").append(this.content).append(", footer=").append(this.footer).append("]");
            return builder.toString();
        }
    }
}

