/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli;

import com.gemstone.gemfire.management.internal.cli.CliAroundInterceptor;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.io.IOException;

public abstract class AbstractCliAroundInterceptor
implements CliAroundInterceptor {
    public boolean interactionSupported() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return gfsh != null && !gfsh.isQuietMode() && !gfsh.isHeadlessMode();
    }

    protected String interact(String message) throws IOException {
        return Gfsh.getCurrentInstance().interact(message);
    }

    protected Response readYesNo(String message, Response defaultResponse) {
        message = defaultResponse == Response.YES ? message + " (" + Response.YES.toUpperPrompt() + "/" + Response.NO.toLowerPrompt() + "): " : message + " (" + Response.YES.toLowerPrompt() + "/" + Response.NO.toUpperPrompt() + "): ";
        if (!this.interactionSupported()) {
            return defaultResponse;
        }
        Response response = null;
        do {
            try {
                String userInput = this.interact(message);
                if (userInput == null || userInput == "") {
                    return defaultResponse;
                }
                response = Response.fromString(userInput);
            }
            catch (IOException ioex) {
                AbstractCliAroundInterceptor.severe("Could not read user response", ioex);
            }
        } while (response == null);
        return response;
    }

    protected static void info(String msg, Throwable th) {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null) {
            gfsh.logInfo(msg, th);
        } else {
            LogWrapper.getInstance().info(msg, th);
        }
    }

    protected static void warning(String msg, Throwable th) {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null) {
            gfsh.logWarning(msg, th);
        } else {
            LogWrapper.getInstance().warning(msg, th);
        }
    }

    protected static void severe(String msg, Throwable th) {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null) {
            gfsh.logSevere(msg, th);
        } else {
            LogWrapper.getInstance().severe(msg, th);
        }
    }

    protected static enum Response {
        YES("yes"),
        NO("no");

        private String text;

        private Response(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }

        public String toUpperPrompt() {
            return this.text.substring(0, 1).toUpperCase();
        }

        public String toLowerPrompt() {
            return this.text.substring(0, 1).toLowerCase();
        }

        public static Response fromString(String text) {
            if (text != null) {
                for (Response response : Response.values()) {
                    if (!text.equalsIgnoreCase(response.text) && (text.length() != 1 || !text.equalsIgnoreCase(response.text.substring(0, 1)))) continue;
                    return response;
                }
            }
            return null;
        }
    }
}

