/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans.stats;

import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;
import com.gemstone.gemfire.management.internal.beans.stats.StatType;

public class StatsRate {
    private long prevLongCounter = 0L;
    private int prevIntCounter = 0;
    private MBeanStatsMonitor monitor;
    private String[] statsKeys;
    private StatType type;

    public StatsRate(String statsKey, StatType type, MBeanStatsMonitor monitor) {
        this.statsKeys = new String[]{statsKey};
        this.monitor = monitor;
        this.type = type;
    }

    public StatsRate(String[] statsKeys, StatType type, MBeanStatsMonitor monitor) {
        this.statsKeys = statsKeys;
        this.monitor = monitor;
        this.type = type;
    }

    public float getRate() {
        long currentTime = System.currentTimeMillis();
        return this.getRate(currentTime);
    }

    public float getRate(long pollTime) {
        float rate = 0.0f;
        switch (this.type) {
            case INT_TYPE: {
                int currentIntCounter = this.getCurrentIntCounter();
                rate = currentIntCounter - this.prevIntCounter;
                this.prevIntCounter = currentIntCounter;
                return rate;
            }
            case LONG_TYPE: {
                long currentLongCounter = this.getCurrentLongCounter();
                rate = currentLongCounter - this.prevLongCounter;
                this.prevLongCounter = currentLongCounter;
                return rate;
            }
        }
        return rate;
    }

    private int getCurrentIntCounter() {
        int currentCounter = 0;
        for (String statKey : this.statsKeys) {
            currentCounter += this.monitor.getStatistic(statKey).intValue();
        }
        return currentCounter;
    }

    private long getCurrentLongCounter() {
        long currentCounter = 0L;
        for (String statKey : this.statsKeys) {
            currentCounter += this.monitor.getStatistic(statKey).longValue();
        }
        return currentCounter;
    }
}

