/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans.stats;

import com.gemstone.gemfire.management.internal.FederationComponent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class IntegerStatsDeltaAggregator {
    private AtomicIntegerArray prevCounters;
    private AtomicIntegerArray currCounters;
    private List<String> keys;

    public IntegerStatsDeltaAggregator(List<String> keys) {
        this.keys = keys;
        this.prevCounters = new AtomicIntegerArray(keys.size());
        this.currCounters = new AtomicIntegerArray(keys.size());
        this.initializeArray(this.currCounters);
    }

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.incData(newState, oldState);
    }

    private void incData(FederationComponent newComp, FederationComponent oldComp) {
        Map<String, Object> oldState;
        Map<String, Object> newState;
        Map<String, Object> map = newState = newComp != null ? newComp.getObjectState() : null;
        if (oldComp != null && oldComp.getOldState().size() > 0) {
            oldState = oldComp.getOldState();
        } else {
            Map<String, Object> map2 = oldState = oldComp != null ? oldComp.getObjectState() : null;
        }
        if (newState != null) {
            for (int index2 = 0; index2 < this.keys.size(); ++index2) {
                Object val;
                this.prevCounters.set(index2, this.currCounters.get(index2));
                Integer newVal = (Integer)newState.get(this.keys.get(index2));
                if (newVal == null) continue;
                Integer oldVal = 0;
                if (oldState != null && (val = oldState.get(this.keys.get(index2))) != null) {
                    oldVal = (Integer)val;
                }
                this.currCounters.addAndGet(index2, newVal - oldVal);
            }
        }
    }

    public int getDelta(String key2) {
        int index2 = this.keys.indexOf(key2);
        if (index2 == -1) {
            return 0;
        }
        return this.currCounters.get(this.keys.indexOf(key2)) - this.prevCounters.get(this.keys.indexOf(key2));
    }

    private void initializeArray(AtomicIntegerArray arr) {
        for (int i = 0; i < arr.length(); ++i) {
            arr.set(i, 0);
        }
    }
}

