/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.management.internal.JmxManagerAdvisor;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.beans.BeanUtilFuncs;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class LocatorMBeanBridge {
    private static final Logger logger = LogService.getLogger();
    private Locator loc;
    private InternalDistributedSystem system;
    private GemFireCacheImpl cache;

    public LocatorMBeanBridge(Locator loc) {
        this.loc = loc;
        this.system = (InternalDistributedSystem)loc.getDistributedSystem();
        this.cache = GemFireCacheImpl.getInstance();
    }

    public String getBindAddress() {
        return this.loc.getBindAddress().getCanonicalHostName();
    }

    public String getHostnameForClients() {
        return this.loc.getHostnameForClients();
    }

    public String viewLog() {
        return this.fetchLog(this.loc.getLogFile(), 30);
    }

    public int getPort() {
        return this.loc.getPort();
    }

    public boolean isPeerLocator() {
        return this.loc.isPeerLocator();
    }

    public boolean isServerLocator() {
        return this.loc.isServerLocator();
    }

    public String[] listManagers() {
        List<JmxManagerAdvisor.JmxManagerProfile> alreadyManaging;
        if (this.cache != null && !(alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging()).isEmpty()) {
            String[] managers = new String[alreadyManaging.size()];
            int j = 0;
            for (JmxManagerAdvisor.JmxManagerProfile profile : alreadyManaging) {
                managers[j] = profile.getDistributedMember().getId();
                ++j;
            }
            return managers;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String[] listPotentialManagers() {
        List<JmxManagerAdvisor.JmxManagerProfile> willingToManage;
        if (this.cache != null && !(willingToManage = this.cache.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
            String[] managers = new String[willingToManage.size()];
            int j = 0;
            for (JmxManagerAdvisor.JmxManagerProfile profile : willingToManage) {
                managers[j] = profile.getDistributedMember().getId();
                ++j;
            }
            return managers;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    private String fetchLog(File logFile, int numLines) {
        if (numLines > 100) {
            numLines = 100;
        }
        if (numLines == 0 || numLines < 0) {
            numLines = 30;
        }
        String mainTail = null;
        try {
            InternalDistributedSystem sys = this.system;
            mainTail = BeanUtilFuncs.tailSystemLog(logFile, numLines);
            if (mainTail == null) {
                mainTail = ManagementStrings.TailLogResponse_NO_LOG_FILE_WAS_SPECIFIED_IN_THE_CONFIGURATION_MESSAGES_IS_BEING_DIRECTED_TO_STDOUT.toLocalizedString();
            }
        }
        catch (IOException e) {
            logger.warn(LocalizedMessage.create(ManagementStrings.TailLogResponse_ERROR_OCCURRED_WHILE_READING_LOGFILE_LOG__0, e));
            mainTail = "";
        }
        if (mainTail == null) {
            return LocalizedStrings.SystemMemberImpl_NO_LOG_FILE_CONFIGURED_LOG_MESSAGES_WILL_BE_DIRECTED_TO_STDOUT.toLocalizedString();
        }
        StringBuffer result = new StringBuffer();
        if (mainTail != null) {
            result.append(mainTail);
        }
        return result.toString();
    }
}

