/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueStats;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;

public class AsyncEventQueueMBeanBridge {
    private AsyncEventQueueImpl queueImpl;
    private MBeanStatsMonitor monitor;

    public AsyncEventQueueMBeanBridge(AsyncEventQueue queue) {
        this.queueImpl = (AsyncEventQueueImpl)queue;
        this.monitor = new MBeanStatsMonitor(ManagementStrings.ASYNC_EVENT_QUEUE_MONITOR.toLocalizedString());
        AsyncEventQueueStats stats = this.queueImpl.getStatistics();
        this.addAsyncEventQueueStats(stats);
    }

    public AsyncEventQueueMBeanBridge() {
        this.monitor = new MBeanStatsMonitor(ManagementStrings.ASYNC_EVENT_QUEUE_MONITOR.toLocalizedString());
    }

    public void addAsyncEventQueueStats(AsyncEventQueueStats asyncEventQueueStats) {
        this.monitor.addStatisticsToMonitor(asyncEventQueueStats.getStats());
    }

    public String getAsyncEventListener() {
        return this.queueImpl.getAsyncEventListener().getClass().getCanonicalName();
    }

    public int getBatchSize() {
        return this.queueImpl.getBatchSize();
    }

    public int getBatchTimeInteval() {
        return this.queueImpl.getBatchTimeInterval();
    }

    public boolean isBatchConflationEnabled() {
        return this.queueImpl.isBatchConflationEnabled();
    }

    public String getId() {
        return this.queueImpl.getId();
    }

    public int getMaximumQueueMemory() {
        return this.queueImpl.getMaximumQueueMemory();
    }

    public String getOverflowDiskStoreName() {
        return this.queueImpl.getDiskStoreName();
    }

    public boolean isPersistent() {
        return this.queueImpl.isPersistent();
    }

    public boolean isParallel() {
        return this.queueImpl.isParallel();
    }

    public boolean isPrimary() {
        return this.queueImpl.isPrimary();
    }

    public int getDispatcherThreads() {
        return this.queueImpl.getDispatcherThreads();
    }

    public String getOrderPolicy() {
        return this.queueImpl.getOrderPolicy() != null ? this.queueImpl.getOrderPolicy().name() : null;
    }

    public boolean isDiskSynchronous() {
        return this.queueImpl.isDiskSynchronous();
    }

    public int getEventQueueSize() {
        return this.getStatistic("eventQueueSize").intValue();
    }

    private Number getStatistic(String statName) {
        if (this.monitor != null) {
            return this.monitor.getStatistic(statName);
        }
        return 0;
    }
}

