/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.JettyHelper;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import java.io.File;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.springframework.util.Assert;

public class RestAgent {
    private static final Logger logger = LogService.getLogger();
    private boolean running = false;
    private final DistributionConfig config;
    private Server httpServer;

    public RestAgent(DistributionConfig config) {
        this.config = config;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private boolean isManagementRestServiceRunning(GemFireCacheImpl cache) {
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(cache);
        return managementService.getManagementAgent() != null && managementService.getManagementAgent().isHttpServiceRunning();
    }

    public synchronized void start(GemFireCacheImpl cache) {
        if (!this.running && this.config.getHttpServicePort() != 0 && !this.isManagementRestServiceRunning(cache)) {
            try {
                this.startHttpService();
                this.running = true;
                cache.setRESTServiceRunning(true);
                RestAgent.createParameterizedQueryRegion();
            }
            catch (RuntimeException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.stopHttpService();
            if (logger.isDebugEnabled()) {
                logger.debug("Gemfire Rest Http service stopped");
            }
            this.running = false;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Attempt to stop Gemfire Rest Http service which is not running");
        }
    }

    private String getGemFireAPIWarLocation(String gemfireHome) {
        Assert.isTrue((!StringUtils.isBlank(gemfireHome) ? 1 : 0) != 0, (String)"The GEMFIRE environment variable must be set!");
        if (new File(gemfireHome + "/tools/Extensions/gemfire-api.war").isFile()) {
            return gemfireHome + "/tools/Extensions/gemfire-api.war";
        }
        if (new File(gemfireHome + "/lib/gemfire-api.war").isFile()) {
            return gemfireHome + "/lib/gemfire-api.war";
        }
        return null;
    }

    private boolean isRunningInTomcat() {
        return System.getProperty("catalina.base") != null || System.getProperty("catalina.home") != null;
    }

    private boolean isWebApplicationAvailable(String warFileLocation) {
        return !StringUtils.isBlank(warFileLocation);
    }

    public void startHttpService() {
        String gemfireAPIWar;
        logger.info("Attempting to start HTTP service on port ({}) at bind-address ({})...", this.config.getHttpServicePort(), this.config.getHttpServiceBindAddress());
        String gemfireHome = System.getenv("GEMFIRE");
        if (StringUtils.isBlank(gemfireHome)) {
            String gemfire = System.getProperty("gemfire.home");
            logger.info("Reading gemfire.home System Property -> {}", gemfire);
            if (StringUtils.isBlank(gemfire)) {
                logger.info("GEMFIRE environment variable not set; HTTP service will not start.");
                return;
            }
            gemfireHome = gemfire;
        }
        if ((gemfireAPIWar = this.getGemFireAPIWarLocation(gemfireHome)) == null) {
            logger.info("Unable to find GemFire Developer REST API WAR file; the Developer REST API for GemFire will not be exported and accessible.");
        }
        try {
            if (this.isRunningInTomcat()) {
                logger.warn("Detected presence of catalina system properties. HTTP service will not be started. To enable the GemFire developer REST API, please deploy the gemfire-web.war file in your application server.");
            } else if (this.isWebApplicationAvailable(gemfireAPIWar)) {
                String bindAddress = this.config.getHttpServiceBindAddress();
                int port = this.config.getHttpServicePort();
                this.httpServer = JettyHelper.initJetty(bindAddress, port, this.config.getHttpServiceSSLEnabled(), this.config.getHttpServiceSSLRequireAuthentication(), this.config.getHttpServiceSSLProtocols(), this.config.getHttpServiceSSLCiphers(), this.config.getHttpServiceSSLProperties());
                this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/gemfire-api", gemfireAPIWar);
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting HTTP embedded server on port ({}) at bind-address ({})...", ((ServerConnector)this.httpServer.getConnectors()[0]).getPort(), bindAddress);
                }
                this.httpServer = JettyHelper.startJetty(this.httpServer);
                logger.info("HTTP service started successfully...!!");
            }
        }
        catch (Exception e) {
            this.stopHttpService();
            throw new RuntimeException("HTTP service failed to start due to " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void stopHttpService() {
        if (this.httpServer != null) {
            logger.info("Stopping the HTTP service...");
            this.httpServer.stop();
            try {
                this.httpServer.destroy();
            }
            catch (Exception ignore) {
                logger.error("Failed to properly release resources held by the HTTP service: {}", ignore.getMessage(), ignore);
            }
            finally {
                this.httpServer = null;
                System.clearProperty("catalina.base");
                System.clearProperty("catalina.home");
            }
            catch (Exception e) {
                try {
                    logger.warn("Failed to stop the HTTP service because: {}", e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    try {
                        this.httpServer.destroy();
                    }
                    catch (Exception ignore) {
                        logger.error("Failed to properly release resources held by the HTTP service: {}", ignore.getMessage(), ignore);
                    }
                    finally {
                        this.httpServer = null;
                        System.clearProperty("catalina.base");
                        System.clearProperty("catalina.home");
                    }
                    throw throwable;
                }
                try {
                    this.httpServer.destroy();
                }
                catch (Exception ignore) {
                    logger.error("Failed to properly release resources held by the HTTP service: {}", ignore.getMessage(), ignore);
                }
                finally {
                    this.httpServer = null;
                    System.clearProperty("catalina.base");
                    System.clearProperty("catalina.home");
                }
            }
        }
    }

    public static void createParameterizedQueryRegion() {
        block6: {
            try {
                GemFireCacheImpl cache;
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting creation of  __ParameterizedQueries__ region");
                }
                if ((cache = (GemFireCacheImpl)CacheFactory.getAnyInstance()) != null) {
                    InternalRegionArguments regionArguments = new InternalRegionArguments();
                    regionArguments.setIsUsedForMetaRegion(true);
                    AttributesFactory<String, String> attributesFactory = new AttributesFactory<String, String>();
                    attributesFactory.setConcurrencyChecksEnabled(false);
                    attributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                    attributesFactory.setKeyConstraint(String.class);
                    attributesFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    attributesFactory.setStatisticsEnabled(false);
                    attributesFactory.setValueConstraint(String.class);
                    RegionAttributes regionAttributes = attributesFactory.create();
                    cache.createVMRegion("__ParameterizedQueries__", regionAttributes, regionArguments);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully created __ParameterizedQueries__ region");
                    }
                } else {
                    logger.error("Cannot create ParameterizedQueries Region as no cache found!");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Error creating __ParameterizedQueries__ Region with cause {}", e.getMessage(), e);
            }
        }
    }
}

