/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ManagerStartupMessage
extends PooledDistributionMessage {
    int alertLevel;

    public static ManagerStartupMessage create(int level) {
        ManagerStartupMessage m = new ManagerStartupMessage();
        m.setLevel(level);
        return m;
    }

    public void setLevel(int alertLevel) {
        this.alertLevel = alertLevel;
    }

    @Override
    public void process(DistributionManager dm) {
        if (this.alertLevel != Integer.MAX_VALUE) {
            AlertAppender.getInstance().addAlertListener(this.getSender(), this.alertLevel);
        }
    }

    @Override
    public int getDSFID() {
        return 2149;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.alertLevel);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.alertLevel = in.readInt();
    }

    @Override
    public String toString() {
        return "ManagerStartupMessage from " + this.getSender() + " level=" + this.alertLevel;
    }
}

