/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.ManagementStrings;
import com.gemstone.gemfire.management.internal.SSLUtil;
import java.io.File;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyHelper {
    private static final Logger logger = LogService.getLogger();
    private static final String FILE_PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String HTTPS = "https";
    private static String bindAddress = "0.0.0.0";
    private static int port = 0;
    private static final CountDownLatch latch = new CountDownLatch(1);

    public static Server initJetty(String bindAddress, int port, boolean useSSL, boolean needClientAuth, String protocols, String ciphers, Properties sysProps) throws Exception {
        Server jettyServer = new Server();
        jettyServer.setHandler((Handler)new HandlerCollection());
        ServerConnector connector = null;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme(HTTPS);
        httpConfig.setSecurePort(port);
        if (useSSL) {
            String protocol;
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setNeedClientAuth(needClientAuth);
            if (!StringUtils.isBlank(ciphers) && !"any".equalsIgnoreCase(ciphers)) {
                sslContextFactory.setIncludeCipherSuites(SSLUtil.readArray(ciphers));
            }
            if ((protocol = SSLUtil.getSSLAlgo(SSLUtil.readArray(protocols))) != null) {
                sslContextFactory.setProtocol(protocol);
            } else {
                logger.warn(ManagementStrings.SSL_PROTOCOAL_COULD_NOT_BE_DETERMINED);
            }
            if (StringUtils.isBlank(sysProps.getProperty("javax.net.ssl.keyStore"))) {
                throw new GemFireConfigException("Key store can't be empty if SSL is enabled for HttpService");
            }
            sslContextFactory.setKeyStorePath(sysProps.getProperty("javax.net.ssl.keyStore"));
            if (!StringUtils.isBlank(sysProps.getProperty("javax.net.ssl.keyStoreType"))) {
                sslContextFactory.setKeyStoreType(sysProps.getProperty("javax.net.ssl.keyStoreType"));
            }
            if (!StringUtils.isBlank(sysProps.getProperty("javax.net.ssl.keyStorePassword"))) {
                sslContextFactory.setKeyStorePassword(sysProps.getProperty("javax.net.ssl.keyStorePassword"));
            }
            if (!StringUtils.isBlank(sysProps.getProperty("javax.net.ssl.trustStore"))) {
                sslContextFactory.setTrustStorePath(sysProps.getProperty("javax.net.ssl.trustStore"));
            }
            if (!StringUtils.isBlank(sysProps.getProperty("javax.net.ssl.trustStorePassword"))) {
                sslContextFactory.setTrustStorePassword(sysProps.getProperty("javax.net.ssl.trustStorePassword"));
            }
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new ServerConnector(jettyServer, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        } else {
            connector = new ServerConnector(jettyServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        }
        jettyServer.setConnectors(new Connector[]{connector});
        if (!StringUtils.isBlank(bindAddress)) {
            connector.setHost(bindAddress);
        }
        if (bindAddress != null && !bindAddress.isEmpty()) {
            JettyHelper.bindAddress = bindAddress;
        }
        JettyHelper.port = port;
        return jettyServer;
    }

    public static Server startJetty(Server jetty) throws Exception {
        jetty.start();
        return jetty;
    }

    public static Server addWebApplication(Server jetty, String webAppContext, String warFilePath) {
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(webAppContext);
        webapp.setWar(warFilePath);
        webapp.setParentLoaderPriority(false);
        File tmpPath = new File(JettyHelper.getWebAppBaseDirectory(webAppContext));
        tmpPath.mkdirs();
        webapp.setTempDirectory(tmpPath);
        ((HandlerCollection)jetty.getHandler()).addHandler((Handler)webapp);
        return jetty;
    }

    private static String getWebAppBaseDirectory(String context) {
        String underscoredContext = context.replace("/", "_");
        String workingDirectory = USER_DIR.concat(FILE_PATH_SEPARATOR).concat("GemFire_" + USER_NAME).concat(FILE_PATH_SEPARATOR).concat("services").concat(FILE_PATH_SEPARATOR).concat("http").concat(FILE_PATH_SEPARATOR).concat(StringUtils.isBlank(bindAddress) ? "0.0.0.0" : bindAddress).concat("_").concat(String.valueOf(port).concat(underscoredContext));
        return workingDirectory;
    }

    private static String normalizeWebAppArchivePath(String webAppArchivePath) {
        return (webAppArchivePath.startsWith(File.separator) ? new File(webAppArchivePath) : new File(".", webAppArchivePath)).getAbsolutePath();
    }

    private static String normalizeWebAppContext(String webAppContext) {
        return webAppContext.startsWith("/") ? webAppContext : "/" + webAppContext;
    }

    public static void main(String ... args) throws Exception {
        if (args.length > 1) {
            System.out.printf("Temporary Directory @ ($1%s)%n", USER_DIR);
            Server jetty = JettyHelper.initJetty(null, 8090, false, false, null, null, null);
            for (int index2 = 0; index2 < args.length; index2 += 2) {
                String webAppContext = args[index2];
                String webAppArchivePath = args[index2 + 1];
                JettyHelper.addWebApplication(jetty, JettyHelper.normalizeWebAppContext(webAppContext), JettyHelper.normalizeWebAppArchivePath(webAppArchivePath));
            }
            JettyHelper.startJetty(jetty);
            latch.await();
        } else {
            System.out.printf("usage:%n>java com.gemstone.gemfire.management.internal.TomcatHelper <web-app-context> <war-file-path> [<web-app-context> <war-file-path>]*", new Object[0]);
        }
    }
}

