/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.OpenMethod;
import com.gemstone.gemfire.management.internal.OpenTypeUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.logging.log4j.Logger;

public class FederationComponent
implements Serializable,
DataSerializable,
DataSerializableFixedID {
    private static final Logger logger = LogService.getLogger();
    private static final String THIS_COMPONENT = FederationComponent.class.getName();
    private static final long serialVersionUID = 3123549507449088591L;
    private String objectName;
    private String interfaceClassName;
    private boolean notificationEmitter;
    private Map<String, Object> objectState = new HashMap<String, Object>();
    private transient Map<String, Method> getterMethodMap;
    private transient Object mbeanObject;
    private transient Class mbeanInterfaceClass;
    private transient Map<String, Object> oldObjectState = new HashMap<String, Object>();
    private final transient Map<Method, OpenMethod> methodHandlerMap = OpenTypeUtil.newMap();
    private transient boolean prevRefreshChangeDetected = false;

    public FederationComponent(Object object, ObjectName objectName, Class interfaceClass, boolean notificationEmitter) {
        this.objectName = objectName.toString();
        this.interfaceClassName = interfaceClass.getCanonicalName();
        this.mbeanInterfaceClass = interfaceClass;
        this.notificationEmitter = notificationEmitter;
        this.mbeanObject = object;
        this.getterMethodMap = new HashMap<String, Method>();
        this.initGetters(interfaceClass);
    }

    public FederationComponent() {
    }

    private void initGetters(Class<?> mbeanInterface) {
        Method[] methodArray;
        for (Method m : methodArray = mbeanInterface.getMethods()) {
            String name = m.getName();
            String attrName = "";
            if (name.startsWith("get")) {
                attrName = name.substring(3);
            } else if (name.startsWith("is") && m.getReturnType() == Boolean.TYPE) {
                attrName = name.substring(2);
            }
            if (attrName.length() == 0 || m.getParameterTypes().length != 0 || m.getReturnType() == Void.TYPE) continue;
            m.setAccessible(true);
            this.getterMethodMap.put(attrName, m);
            this.methodHandlerMap.put(m, OpenMethod.from(m));
        }
    }

    public String getMBeanInterfaceClass() {
        return this.interfaceClassName;
    }

    public boolean isNotificationEmitter() {
        return this.notificationEmitter;
    }

    public boolean refreshObjectState(boolean keepOldState) {
        boolean changeDetected = false;
        Object[] args = null;
        if (keepOldState) {
            this.oldObjectState.putAll(this.objectState);
        }
        for (Map.Entry<String, Method> gettorMethodEntry : this.getterMethodMap.entrySet()) {
            Object propertyValue;
            String property2;
            block5: {
                property2 = gettorMethodEntry.getKey();
                propertyValue = null;
                try {
                    Method m = gettorMethodEntry.getValue();
                    propertyValue = m.invoke(this.mbeanObject, args);
                    OpenMethod op = this.methodHandlerMap.get(m);
                    propertyValue = op.toOpenReturnValue(propertyValue);
                }
                catch (Exception e) {
                    propertyValue = null;
                    if (!logger.isTraceEnabled()) break block5;
                    logger.trace(e.getMessage());
                }
            }
            Object oldValue = this.objectState.put(property2, propertyValue);
            if (changeDetected) continue;
            if (propertyValue != null) {
                if (propertyValue.equals(oldValue)) continue;
                changeDetected = true;
                continue;
            }
            if (oldValue == null) continue;
            changeDetected = true;
        }
        boolean retVal = this.prevRefreshChangeDetected || changeDetected;
        this.prevRefreshChangeDetected = changeDetected;
        return retVal;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof FederationComponent) {
            FederationComponent anotherFedComp = (FederationComponent)anObject;
            if (anotherFedComp.interfaceClassName.equals(this.interfaceClassName) && anotherFedComp.notificationEmitter == this.notificationEmitter && anotherFedComp.objectState.equals(this.objectState) && anotherFedComp.objectName.equals(this.objectName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.objectName.hashCode();
    }

    public Object getValue(String propertyName) {
        return this.objectState.get(propertyName);
    }

    public String toString() {
        if (Boolean.getBoolean("debug.Management")) {
            return " ObjectName = " + this.objectName + ",InterfaceClassName = " + this.interfaceClassName + ", NotificationEmitter = " + this.notificationEmitter + ", ObjectState = " + this.objectState.toString();
        }
        return "ObjectName = " + this.objectName;
    }

    public Map<String, Object> getObjectState() {
        return this.objectState;
    }

    public Map<String, Object> getOldState() {
        return this.oldObjectState;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.notificationEmitter = DataSerializer.readPrimitiveBoolean(in);
        this.interfaceClassName = DataSerializer.readString(in);
        this.objectState = DataSerializer.readHashMap(in);
        this.objectName = DataSerializer.readString(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writePrimitiveBoolean(this.notificationEmitter, out);
        DataSerializer.writeString(this.interfaceClassName, out);
        DataSerializer.writeHashMap((HashMap)this.objectState, out);
        DataSerializer.writeString(this.objectName, out);
    }

    @Override
    public int getDSFID() {
        return 2154;
    }

    public Object getMBeanObject() {
        return this.mbeanObject;
    }

    public Class getInterfaceClass() {
        return this.mbeanInterfaceClass;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

