/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.management.internal.OpenTypeConverter;
import java.io.InvalidObjectException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

public class CompositeConverter
extends OpenTypeConverter {
    private final String[] itemNames;
    private final Method[] getters;
    private final OpenTypeConverter[] getterConverters;
    private OpenTypeConverter.CompositeBuilder compositeBuilder;

    CompositeConverter(Class targetClass, CompositeType compositeType, String[] itemNames, Method[] getters) throws OpenDataException {
        super(targetClass, compositeType, CompositeData.class);
        assert (itemNames.length == getters.length);
        this.itemNames = itemNames;
        this.getters = getters;
        this.getterConverters = new OpenTypeConverter[getters.length];
        for (int i = 0; i < getters.length; ++i) {
            Type retType = getters[i].getGenericReturnType();
            this.getterConverters[i] = OpenTypeConverter.toConverter(retType);
        }
    }

    @Override
    final Object toNonNullOpenValue(Object value2) throws OpenDataException {
        CompositeType ct = (CompositeType)this.getOpenType();
        if (value2 instanceof CompositeDataView) {
            return ((CompositeDataView)value2).toCompositeData(ct);
        }
        if (value2 == null) {
            return null;
        }
        Object[] values = new Object[this.getters.length];
        for (int i = 0; i < this.getters.length; ++i) {
            try {
                Object got = this.getters[i].invoke(value2, (Object[])null);
                values[i] = this.getterConverters[i].toOpenValue(got);
                continue;
            }
            catch (Exception e) {
                throw CompositeConverter.openDataException("Error calling getter for " + this.itemNames[i] + ": " + e, e);
            }
        }
        return new CompositeDataSupport(ct, this.itemNames, values);
    }

    private synchronized void makeCompositeBuilder() throws InvalidObjectException {
        if (this.compositeBuilder != null) {
            return;
        }
        Class targetClass = (Class)this.getTargetType();
        OpenTypeConverter.CompositeBuilder[][] builders = new OpenTypeConverter.CompositeBuilder[][]{{new OpenTypeConverter.CompositeBuilderViaFrom(targetClass, this.itemNames)}, {new OpenTypeConverter.CompositeBuilderViaConstructor(targetClass, this.itemNames)}, {new OpenTypeConverter.CompositeBuilderCheckGetters(targetClass, this.itemNames, this.getterConverters), new OpenTypeConverter.CompositeBuilderViaSetters(targetClass, this.itemNames), new OpenTypeConverter.CompositeBuilderViaProxy(targetClass, this.itemNames)}};
        OpenTypeConverter.CompositeBuilder foundBuilder = null;
        StringBuilder whyNots = new StringBuilder();
        Throwable possibleCause = null;
        block0: for (OpenTypeConverter.CompositeBuilder[] relatedBuilders : builders) {
            for (int i = 0; i < relatedBuilders.length; ++i) {
                OpenTypeConverter.CompositeBuilder builder = relatedBuilders[i];
                String whyNot = builder.applicable(this.getters);
                if (whyNot == null) {
                    foundBuilder = builder;
                    break block0;
                }
                Throwable cause = builder.possibleCause();
                if (cause != null) {
                    possibleCause = cause;
                }
                if (whyNot.length() <= 0) continue;
                if (whyNots.length() > 0) {
                    whyNots.append("; ");
                }
                whyNots.append(whyNot);
                if (i == 0) continue block0;
            }
        }
        if (foundBuilder == null) {
            String msg = "Do not know how to make a " + targetClass.getName() + " from a CompositeData: " + whyNots;
            if (possibleCause != null) {
                msg = msg + ". Remaining exceptions show a POSSIBLE cause.";
            }
            throw CompositeConverter.invalidObjectException(msg, possibleCause);
        }
        this.compositeBuilder = foundBuilder;
    }

    @Override
    void checkReconstructible() throws InvalidObjectException {
        this.makeCompositeBuilder();
    }

    @Override
    public final Object fromNonNullOpenValue(Object value2) throws InvalidObjectException {
        this.makeCompositeBuilder();
        return this.compositeBuilder.fromCompositeData((CompositeData)value2, this.itemNames, this.getterConverters);
    }
}

