/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.cli;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.management.DependenciesNotFoundException;
import com.gemstone.gemfire.management.cli.CommandServiceException;
import com.gemstone.gemfire.management.cli.CommandStatement;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.remote.MemberCommandService;
import java.util.Collections;
import java.util.Map;

public abstract class CommandService {
    protected static final Map<String, String> EMPTY_ENV = Collections.emptyMap();
    private static CommandService localCommandService;

    public abstract boolean isUsable();

    public abstract Result processCommand(String var1);

    protected abstract Result processCommand(String var1, Map<String, String> var2);

    public abstract CommandStatement createCommandStatement(String var1);

    protected abstract CommandStatement createCommandStatement(String var1, Map<String, String> var2);

    public static final CommandService createLocalCommandService(Cache cache) throws CommandServiceException {
        if (cache == null || cache.isClosed()) {
            throw new CacheClosedException("Can not create command service as cache doesn't exist or cache is closed.");
        }
        if (localCommandService == null || !localCommandService.isUsable()) {
            String nonExistingDependency = CliUtil.cliDependenciesExist(false);
            if (nonExistingDependency != null) {
                throw new DependenciesNotFoundException(LocalizedStrings.CommandServiceManager_COULD_NOT_FIND__0__LIB_NEEDED_FOR_CLI_GFSH.toLocalizedString(nonExistingDependency));
            }
            localCommandService = new MemberCommandService(cache);
        }
        return localCommandService;
    }

    public static final CommandService getUsableLocalCommandService() {
        if (localCommandService != null && localCommandService.isUsable()) {
            return localCommandService;
        }
        return null;
    }
}

