/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util.concurrent;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCondition;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class StoppableReentrantLock {
    private final ReentrantLock lock;
    private static final long RETRY_TIME = 15000L;
    private final CancelCriterion stopper;

    public StoppableReentrantLock(CancelCriterion stopper) {
        Assert.assertTrue(stopper != null);
        this.lock = new ReentrantLock();
        this.stopper = stopper;
    }

    public StoppableReentrantLock(boolean fair, CancelCriterion stopper) {
        Assert.assertTrue(stopper != null);
        this.stopper = stopper;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        while (true) {
            boolean interrupted = Thread.interrupted();
            try {
                this.lockInterruptibly();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void lockInterruptibly() throws InterruptedException {
        do {
            this.stopper.checkCancelInProgress(null);
        } while (!this.lock.tryLock(15000L, TimeUnit.MILLISECONDS));
    }

    public boolean tryLock() {
        this.stopper.checkCancelInProgress(null);
        return this.lock.tryLock();
    }

    public boolean tryLock(long timeoutMs) throws InterruptedException {
        this.stopper.checkCancelInProgress(null);
        return this.lock.tryLock(timeoutMs, TimeUnit.MILLISECONDS);
    }

    public void unlock() {
        this.lock.unlock();
    }

    public StoppableCondition newCondition() {
        return new StoppableCondition(this.lock.newCondition(), this.stopper);
    }

    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }
}

