/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util.concurrent;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class CopyOnWriteWeakHashMap<K, V>
extends AbstractMap<K, V> {
    private volatile Map<K, V> map = Collections.emptyMap();

    @Override
    public V get(Object key2) {
        return this.map.get(key2);
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.map.containsValue(value2);
    }

    @Override
    public synchronized V put(K key2, V value2) {
        WeakHashMap<K, V> tmp = new WeakHashMap<K, V>(this.map);
        V result = tmp.put(key2, value2);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        WeakHashMap<? extends K, ? extends V> tmp = new WeakHashMap<K, V>(this.map);
        tmp.putAll(m);
        this.map = Collections.unmodifiableMap(tmp);
    }

    @Override
    public synchronized V remove(Object key2) {
        WeakHashMap<K, V> tmp = new WeakHashMap<K, V>(this.map);
        V result = tmp.remove(key2);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void clear() {
        this.map = Collections.emptyMap();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

