/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util;

import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public abstract class DebuggerSupport {
    private DebuggerSupport() {
    }

    public static void waitForJavaDebugger(LogWriterI18n logger) {
        DebuggerSupport.waitForJavaDebugger(logger, null);
    }

    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"}, justification="Endless loop is for debugging purposes.")
    public static void waitForJavaDebugger(LogWriterI18n logger, String extraLogMsg) {
        boolean cont = false;
        String msg = ":";
        if (extraLogMsg != null) {
            msg = msg + extraLogMsg;
        }
        logger.severe(LocalizedStrings.DebuggerSupport_WAITING_FOR_DEBUGGER_TO_ATTACH_0, msg);
        boolean interrupted = false;
        while (!cont) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        logger.info(LocalizedStrings.DebuggerSupport_DEBUGGER_CONTINUING);
    }
}

