/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util;

import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.EventID;

public class Breadcrumbs {
    private static ThreadLocal<EventID> EventIDs = new ThreadLocal();
    public static boolean ENABLED = Boolean.getBoolean("gemfire.enable-breadcrumbs");
    static final String CrumbDelimiter = "/";
    static final String CommonBreadcrumbStart = "\n\t/";
    private static CrumbType Crumbiest = CrumbType.PROBLEM;
    private static String[] crumbLabels = new String[]{"rcv", "evt", "snd", "oops"};
    private static String[] crumbStarts = new String[Crumbiest.ordinal() + 1];
    private static String[] crumbEnds = new String[Crumbiest.ordinal() + 1];

    public static void setReceiveSide(Object crumb) {
        if (ENABLED) {
            Breadcrumbs.setBreadcrumb(Thread.currentThread(), CrumbType.RECEIVE_SIDE, crumb);
        }
    }

    public static void setSendSide(Object crumb) {
        if (ENABLED) {
            Breadcrumbs.setBreadcrumb(Thread.currentThread(), CrumbType.SEND_SIDE, crumb);
        }
    }

    public static void setEventId(Object crumb) {
        if (ENABLED) {
            if (crumb instanceof EventID) {
                EventID other = EventIDs.get();
                if (other != null && other != crumb) {
                    ((EventID)crumb).incBreadcrumbCounter();
                    Breadcrumbs.setBreadcrumb(Thread.currentThread(), CrumbType.EVENTID, crumb);
                }
            } else {
                Breadcrumbs.setBreadcrumb(Thread.currentThread(), CrumbType.EVENTID, crumb);
            }
        }
    }

    public static void setProblem(StringId msg, Object[] args) {
        if (ENABLED) {
            Breadcrumbs.setBreadcrumb(Thread.currentThread(), CrumbType.PROBLEM, msg.toLocalizedString(args));
        }
    }

    public static void setProblem(Object crumb) {
        if (ENABLED) {
            Breadcrumbs.setBreadcrumb(Thread.currentThread(), CrumbType.PROBLEM, crumb);
        }
    }

    public static void clearBreadcrumb() {
        if (ENABLED) {
            Breadcrumbs.clearBreadcrumb(Thread.currentThread());
            EventIDs.set(null);
        }
    }

    private static void setBreadcrumb(Thread t, CrumbType type, Object crumb) {
        Breadcrumbs.setCrumbInThread(t, type, crumb);
    }

    private static void clearBreadcrumb(Thread t) {
        String name = t.getName();
        int i = name.indexOf(CommonBreadcrumbStart);
        if (i >= 0) {
            t.setName(name.substring(0, i));
        }
    }

    private static void setCrumbInThread(Thread t, CrumbType type, Object crumb) {
        int typeIndex = type.ordinal();
        String name = t.getName();
        String crumbString = crumb == null ? "" : crumbStarts[typeIndex] + crumb + crumbEnds[typeIndex];
        int startIndex = name.indexOf(crumbStarts[typeIndex]);
        int endIndex = -1;
        if (startIndex < 0) {
            for (int i = typeIndex + 1; startIndex < 0 && i <= Crumbiest.ordinal(); ++i) {
                startIndex = name.indexOf(crumbStarts[i]);
                if (startIndex < 0) continue;
                endIndex = name.indexOf(crumbEnds[i], startIndex + 1);
            }
        }
        if (startIndex < 0) {
            t.setName(name + crumbString);
        } else if (endIndex > 0) {
            t.setName(name.substring(0, startIndex) + crumbString + name.substring(startIndex, name.length()));
        } else {
            endIndex = name.indexOf(crumbEnds[typeIndex], startIndex + 1);
            assert (endIndex > 0) : "odd thread name: " + name;
            t.setName(name.substring(0, startIndex) + crumbString + name.substring(endIndex + crumbEnds[typeIndex].length(), name.length()));
        }
    }

    private static void clearCrumbInThread(Thread t) {
        String name = t.getName();
        int i = name.indexOf(CommonBreadcrumbStart);
        if (i >= 0) {
            t.setName(name.substring(0, i));
        }
    }

    public static void main(String[] args) {
        String threadName = null;
        ENABLED = true;
        Breadcrumbs.setReceiveSide("processorId=17332");
        threadName = Thread.currentThread().getName();
        System.out.println("thread name with sender=" + threadName);
        Breadcrumbs.setEventId("eventId");
        threadName = Thread.currentThread().getName();
        System.out.println("thread name with eventId=" + threadName);
        Breadcrumbs.setEventId("eventId2");
        threadName = Thread.currentThread().getName();
        System.out.println("replaced eventId: " + threadName);
        Breadcrumbs.setSendSide("recipients");
        threadName = Thread.currentThread().getName();
        System.out.println("with recipients: " + threadName);
        Breadcrumbs.setEventId("eventId3");
        threadName = Thread.currentThread().getName();
        System.out.println("replaced eventId3: " + threadName);
        Breadcrumbs.setSendSide("recipients2");
        threadName = Thread.currentThread().getName();
        System.out.println("with recipients2: " + threadName);
        Breadcrumbs.setReceiveSide("processorId=22222");
        threadName = Thread.currentThread().getName();
        System.out.println("thread name with processor 22222=" + threadName);
        Breadcrumbs.setSendSide(null);
        threadName = Thread.currentThread().getName();
        System.out.println("with recipients removed: " + threadName);
        Breadcrumbs.clearBreadcrumb();
        threadName = Thread.currentThread().getName();
        System.out.println("thread name cleared=" + threadName);
    }

    static {
        for (int i = 0; i <= Crumbiest.ordinal(); ++i) {
            Breadcrumbs.crumbStarts[i] = CommonBreadcrumbStart + crumbLabels[i] + CrumbDelimiter + " ";
            Breadcrumbs.crumbEnds[i] = " /" + crumbLabels[i] + CrumbDelimiter;
        }
    }

    private static enum CrumbType {
        RECEIVE_SIDE,
        EVENTID,
        SEND_SIDE,
        PROBLEM;

    }
}

