/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util;

import java.lang.reflect.Array;

public abstract class ArrayUtils {
    public static <T> T getElementAtIndex(T[] array, int index2, T defaultValue) {
        try {
            return array[index2];
        }
        catch (ArrayIndexOutOfBoundsException ignore) {
            return defaultValue;
        }
    }

    public static <T> T getFirst(T ... array) {
        return array != null && array.length > 0 ? (T)array[0] : null;
    }

    public static String toString(Object ... array) {
        StringBuilder buffer = new StringBuilder("[");
        int count = 0;
        if (array != null) {
            for (Object element : array) {
                buffer.append(count++ > 0 ? ", " : "").append(element);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toString(String ... array) {
        return ArrayUtils.toString((Object[])array);
    }

    public static Object[] insert(Object[] originalArray, int pos, Object element) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length + 1);
        if (pos > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, pos);
        }
        newArray[pos] = element;
        if (pos < originalArray.length) {
            System.arraycopy(originalArray, pos, newArray, pos + 1, originalArray.length - pos);
        }
        return newArray;
    }

    public static Object[] remove(Object[] originalArray, int pos) {
        Object[] newArray = (Object[])Array.newInstance(originalArray.getClass().getComponentType(), originalArray.length - 1);
        if (pos > 0) {
            System.arraycopy(originalArray, 0, newArray, 0, pos);
        }
        if (pos < originalArray.length - 1) {
            System.arraycopy(originalArray, pos + 1, newArray, pos, originalArray.length - 1 - pos);
        }
        return newArray;
    }

    public static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static Integer[] toIntegerArray(int[] array) {
        Integer[] integerArray = new Integer[array == null ? 0 : array.length];
        if (array != null) {
            for (int index2 = 0; index2 < array.length; ++index2) {
                integerArray[index2] = array[index2];
            }
        }
        return integerArray;
    }

    public static Byte[][] toByteArray(byte[][] array) {
        if (array == null) {
            return null;
        }
        Byte[][] byteArray = new Byte[array.length][];
        for (int i = 0; i < array.length; ++i) {
            byteArray[i] = new Byte[array[i].length];
            for (int j = 0; j < array[i].length; ++j) {
                byteArray[i][j] = array[i][j];
            }
        }
        return byteArray;
    }

    public static byte[][] toBytes(Byte[][] byteArray) {
        if (byteArray == null) {
            return null;
        }
        byte[][] array = new byte[byteArray.length][];
        for (int i = 0; i < byteArray.length; ++i) {
            array[i] = new byte[byteArray[i].length];
            for (int j = 0; j < byteArray[i].length; ++j) {
                array[i][j] = byteArray[i][j];
            }
        }
        return array;
    }
}

