/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.command;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractCommandTask
implements CommandTask {
    private static final long serialVersionUID = 1L;
    private static final String KEY_RESULTS_DEFAULT = "results";
    private static final String REGION_NAME_ASYNC = "async";
    private static int ASYNC_REGION_TIMEOUT = Integer.getInteger("AbstractCommandTask.ASYNC_REGION_TIMEOUT", 120);
    Region commandRegion;
    private String resultSetRegionFullPath;

    protected Region getCommandRegion() {
        return this.commandRegion;
    }

    public void setCommandRegion(Region commandRegion) {
        this.commandRegion = commandRegion;
    }

    public void setResultSetRegionPath(String resultSetRegionFullPath) {
        this.resultSetRegionFullPath = resultSetRegionFullPath;
    }

    private Region getAsyncRegion() {
        Region<Object, Object> asyncRegion = this.getCommandRegion().getSubregion(REGION_NAME_ASYNC);
        if (asyncRegion == null) {
            AttributesFactory factory = new AttributesFactory();
            factory.setStatisticsEnabled(true);
            factory.setScope(Scope.LOCAL);
            factory.setDataPolicy(DataPolicy.NORMAL);
            factory.setEntryIdleTimeout(new ExpirationAttributes(ASYNC_REGION_TIMEOUT, ExpirationAction.LOCAL_DESTROY));
            factory.addCacheListener(new CacheListenerAdapter(){

                @Override
                public void afterDestroy(EntryEvent event) {
                    String regionPath = (String)event.getKey();
                    AbstractCommandTask.this.getCommandRegion().getSubregion(regionPath).destroyRegion();
                }
            });
            try {
                asyncRegion = this.getCommandRegion().createSubregion(REGION_NAME_ASYNC, factory.create());
            }
            catch (Exception ex) {
                asyncRegion = this.getCommandRegion().getSubregion(REGION_NAME_ASYNC);
            }
        }
        return asyncRegion;
    }

    protected void sendResults(CommandResults results) {
        try {
            Region resultSetRegion = RegionUtil.getRegion(this.resultSetRegionFullPath, Scope.LOCAL, DataPolicy.EMPTY, null);
            resultSetRegion.put(KEY_RESULTS_DEFAULT, results);
            Region asyncRegion = this.getAsyncRegion();
            asyncRegion.put(resultSetRegion.getName(), true);
        }
        catch (CacheException ex) {
            Cache cache = CacheFactory.getAnyInstance();
            cache.getLogger().error(ex);
        }
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.resultSetRegionFullPath = DataSerializer.readString(input);
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        DataSerializer.writeString(this.resultSetRegionFullPath, output);
    }

    @Override
    public abstract CommandResults runTask(Object var1);
}

