/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.util;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.StringUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.SimplePrintUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class PrintUtil {
    private static boolean tableFormat = false;

    public static boolean isTableFormat() {
        return tableFormat;
    }

    public static void setTableFormat(boolean tableFormat) {
        PrintUtil.tableFormat = tableFormat;
    }

    public static int printEntries(Region region, Iterator regionIterator, int startIndex, int startRowNum, int rowCount, List keyList) throws Exception {
        int index2;
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printEntries(region, regionIterator, startIndex, startRowNum, rowCount, keyList);
        }
        if (region == null || regionIterator == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        int endIndex = startIndex + rowCount;
        if (endIndex >= region.size()) {
            endIndex = region.size();
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        ArrayList keyMaxLenList = new ArrayList();
        ArrayList valueMaxLenList = new ArrayList();
        Object key2 = null;
        Object value2 = null;
        Set nameSet = region.entrySet();
        ArrayList<Region.Entry> entryList = new ArrayList<Region.Entry>();
        Iterator itr = regionIterator;
        for (index2 = startIndex; index2 < endIndex && itr.hasNext(); ++index2) {
            Region.Entry entry = (Region.Entry)itr.next();
            entryList.add(entry);
            key2 = entry.getKey();
            value2 = entry.getValue();
            PrintUtil.computeMaxLengths(keyMaxLenList, valueMaxLenList, key2, value2);
            keyNameSet.add(key2.getClass().getName());
            if (value2 == null) continue;
            valueNameSet.add(value2.getClass().getName());
        }
        if (key2 == null) {
            return 0;
        }
        int rowMax = String.valueOf(endIndex).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(keyMaxLenList, valueMaxLenList, key2, value2, rowMax);
        int row = startRowNum;
        Iterator itr2 = entryList.iterator();
        for (index2 = startIndex; index2 < endIndex && itr2.hasNext(); ++index2) {
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            Region.Entry entry = (Region.Entry)itr2.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            if (keyList != null) {
                keyList.add(key2);
            }
            PrintUtil.printObject(keyMaxLenList, key2, true);
            System.out.print(" | ");
            PrintUtil.printObject(valueMaxLenList, value2, false);
            System.out.println();
            ++row;
        }
        System.out.println();
        System.out.println(" Fetch size: " + rowCount);
        System.out.println("   Returned: " + (row - 1) + "/" + region.size());
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return endIndex - startIndex;
    }

    public static int printEntries(Region region, Map keyMap, List keyList) throws Exception {
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printEntries(region, keyMap, keyList);
        }
        if (region == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        ArrayList keyMaxLenList = new ArrayList();
        ArrayList valueMaxLenList = new ArrayList();
        ArrayList indexList = new ArrayList(keyMap.keySet());
        Collections.sort(indexList);
        Object key2 = null;
        Object value2 = null;
        for (Object index2 : indexList) {
            key2 = keyMap.get(index2);
            value2 = region.get(key2);
            PrintUtil.computeMaxLengths(keyMaxLenList, valueMaxLenList, key2, value2);
            keyNameSet.add(key2.getClass().getName());
            if (value2 == null) continue;
            valueNameSet.add(value2.getClass().getName());
        }
        if (key2 == null) {
            return 0;
        }
        int rowCount = keyMap.size();
        int rowMax = String.valueOf(rowCount).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(keyMaxLenList, valueMaxLenList, key2, value2, rowMax);
        int row = 1;
        Iterator iterator = indexList.iterator();
        while (iterator.hasNext()) {
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            Object k = iterator.next();
            key2 = keyMap.get(k);
            value2 = region.get(key2);
            if (keyList != null) {
                keyList.add(key2);
            }
            PrintUtil.printObject(keyMaxLenList, key2, true);
            System.out.print(" | ");
            PrintUtil.printObject(valueMaxLenList, value2, false);
            System.out.println();
            ++row;
        }
        System.out.println();
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return rowCount;
    }

    public static int printEntries(Region region, Set keySet, List keyList) throws Exception {
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printEntries(region, keySet, keyList);
        }
        if (region == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        ArrayList keyMaxLenList = new ArrayList();
        ArrayList valueMaxLenList = new ArrayList();
        Object key222 = null;
        Object value2 = null;
        for (Object key222 : keySet) {
            value2 = region.get(key222);
            PrintUtil.computeMaxLengths(keyMaxLenList, valueMaxLenList, key222, value2);
            keyNameSet.add(key222.getClass().getName());
            if (value2 == null) continue;
            valueNameSet.add(value2.getClass().getName());
        }
        if (key222 == null) {
            return 0;
        }
        int rowCount = keySet.size();
        int rowMax = String.valueOf(rowCount).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(keyMaxLenList, valueMaxLenList, key222, value2, rowMax);
        int row = 1;
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            key222 = iterator.next();
            value2 = region.get(key222);
            if (keyList != null) {
                keyList.add(key222);
            }
            PrintUtil.printObject(keyMaxLenList, key222, true);
            System.out.print(" | ");
            PrintUtil.printObject(valueMaxLenList, value2, false);
            System.out.println();
            ++row;
        }
        System.out.println();
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return rowCount;
    }

    public static int printEntries(Map map, int startIndex, int startRowNum, int rowCount, int actualSize, List keyList) throws Exception {
        int count;
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printEntries(map, startIndex, startRowNum, rowCount, actualSize, keyList);
        }
        if (map == null) {
            System.out.println("Error: map is null");
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        ArrayList keyMaxLenList = new ArrayList();
        ArrayList valueMaxLenList = new ArrayList();
        Object key2 = null;
        Object value2 = null;
        Set entrySet = map.entrySet();
        Iterator itr = entrySet.iterator();
        for (count = 0; count < rowCount && itr.hasNext(); ++count) {
            Map.Entry entry = itr.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            PrintUtil.computeMaxLengths(keyMaxLenList, valueMaxLenList, key2, value2);
            keyNameSet.add(key2.getClass().getName());
            if (value2 == null) continue;
            valueNameSet.add(value2.getClass().getName());
        }
        if (key2 == null) {
            return 0;
        }
        int rowMax = String.valueOf(startRowNum + rowCount - 1).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(keyMaxLenList, valueMaxLenList, key2, value2, rowMax);
        int row = startRowNum;
        int lastRow = startRowNum + rowCount - 1;
        Iterator itr2 = entrySet.iterator();
        for (count = 0; count < rowCount && itr2.hasNext(); ++count) {
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            Map.Entry entry = itr2.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            if (keyList != null) {
                keyList.add(key2);
            }
            PrintUtil.printObject(keyMaxLenList, key2, true);
            System.out.print(" | ");
            PrintUtil.printObject(valueMaxLenList, value2, false);
            System.out.println();
            ++row;
        }
        System.out.println();
        System.out.println(" Fetch size: " + rowCount);
        System.out.println("   Returned: " + (row - 1) + "/" + actualSize);
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return count;
    }

    public static int printSet(Set set, int rowCount, List keyList) throws Exception {
        return PrintUtil.printSet(set, rowCount, keyList, true);
    }

    public static int printSet(Set set, int rowCount, List keyList, boolean showSummary) throws Exception {
        return PrintUtil.printSet(set, rowCount, keyList, "Key", showSummary);
    }

    public static int printSet(Set set, int rowCount, List keyList, String keyColumnName, boolean showSummary) throws Exception {
        int count;
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printSet(set, rowCount, keyList, keyColumnName, showSummary);
        }
        if (set == null) {
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        ArrayList keyMaxLenList = new ArrayList();
        Object key2 = null;
        Set nameSet = set;
        int keyMin = keyColumnName.length();
        Iterator itr = nameSet.iterator();
        for (count = 0; count < rowCount && itr.hasNext(); ++count) {
            key2 = itr.next();
            PrintUtil.computeMaxLengths(keyMaxLenList, key2, true, keyMin, 0);
            keyNameSet.add(key2.getClass().getName());
        }
        if (key2 == null) {
            return 0;
        }
        int rowMax = String.valueOf(rowCount).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(keyMaxLenList, null, key2, null, rowMax, keyColumnName, null, false);
        int row = 1;
        Iterator itr2 = nameSet.iterator();
        for (count = 0; count < rowCount && itr2.hasNext(); ++count) {
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            key2 = itr2.next();
            if (keyList != null) {
                keyList.add(key2);
            }
            PrintUtil.printObject(keyMaxLenList, key2, true);
            System.out.println();
            ++row;
        }
        if (showSummary) {
            System.out.println();
            System.out.println("Displayed (fetched): " + (row - 1));
            System.out.println("        Actual Size: " + set.size());
            for (Object e : keyNameSet) {
                System.out.println("          " + keyColumnName + " Class: " + e);
            }
        }
        return row - 1;
    }

    public static int printEntries(Map map, int rowCount, List keyList) throws Exception {
        return PrintUtil.printEntries(map, rowCount, keyList, true, true);
    }

    public static int printEntries(Map map, int rowCount, List keyList, boolean showSummary, boolean showValues) throws Exception {
        return PrintUtil.printEntries(map, rowCount, keyList, "Key", "Value", showSummary, showValues);
    }

    public static int printEntries(Map map, int rowCount, List keyList, String keyColumnName, String valueColumnName, boolean showSummary, boolean showValues) throws Exception {
        int count;
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printEntries(map, rowCount, keyList, keyColumnName, valueColumnName, showSummary, showValues);
        }
        if (map == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        ArrayList keyMaxLenList = new ArrayList();
        ArrayList valueMaxLenList = new ArrayList();
        Object key2 = null;
        Object value2 = null;
        Set nameSet = map.entrySet();
        int keyMin = keyColumnName.length();
        int valueMin = valueColumnName.length();
        Iterator itr = nameSet.iterator();
        for (count = 0; count < rowCount && itr.hasNext(); ++count) {
            Map.Entry entry = itr.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            PrintUtil.computeMaxLengths(keyMaxLenList, valueMaxLenList, key2, value2, keyMin, valueMin);
            keyNameSet.add(key2.getClass().getName());
            if (value2 == null) continue;
            valueNameSet.add(value2.getClass().getName());
        }
        if (key2 == null) {
            return 0;
        }
        int rowMax = String.valueOf(rowCount).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(keyMaxLenList, valueMaxLenList, key2, value2, rowMax, keyColumnName, valueColumnName, showValues);
        int row = 1;
        Iterator itr2 = nameSet.iterator();
        for (count = 0; count < rowCount && itr2.hasNext(); ++count) {
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            Map.Entry entry = itr2.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            if (keyList != null) {
                keyList.add(key2);
            }
            PrintUtil.printObject(keyMaxLenList, key2, true);
            if (showValues) {
                System.out.print(" | ");
                PrintUtil.printObject(valueMaxLenList, value2, false);
            }
            System.out.println();
            ++row;
        }
        if (showSummary) {
            System.out.println();
            System.out.println("Displayed (fetched): " + (row - 1));
            System.out.println("        Actual Size: " + map.size());
            for (Object e : keyNameSet) {
                System.out.println("          " + keyColumnName + " Class: " + e);
            }
            for (Object e : valueNameSet) {
                System.out.println("        " + valueColumnName + " Class: " + e);
            }
        }
        return row - 1;
    }

    private static void computeMaxLengths(List keyList, List valueList, Object key2, Object value2) {
        PrintUtil.computeMaxLengths(keyList, valueList, key2, value2, 3, 5);
    }

    private static void computeMaxLengths(List keyList, List valueList, Object key2, Object value2, int keyMin, int valueMin) {
        PrintUtil.computeMaxLengths(keyList, key2, true, keyMin, valueMin);
        PrintUtil.computeMaxLengths(valueList, value2, false, keyMin, valueMin);
    }

    private static void printTopHeaders(List list, Object obj, boolean printLastColumnSpaces, String primitiveHeader) {
        block17: {
            Object object;
            block18: {
                block16: {
                    object = obj;
                    if (object == null) {
                        object = "null";
                    }
                    if (!(object instanceof String) && !object.getClass().isPrimitive() && object.getClass() != Boolean.class && object.getClass() != Byte.class && object.getClass() != Character.class && object.getClass() != Short.class && object.getClass() != Integer.class && object.getClass() != Long.class && object.getClass() != Float.class && object.getClass() != Double.class && !object.getClass().isArray() && !(object instanceof Date)) break block16;
                    int maxLen = (Integer)list.get(0);
                    if (maxLen < primitiveHeader.length()) {
                        maxLen = primitiveHeader.length();
                    }
                    if (printLastColumnSpaces) {
                        System.out.print(StringUtil.getRightPaddedString(primitiveHeader, maxLen, ' '));
                    } else {
                        System.out.print(primitiveHeader);
                    }
                    break block17;
                }
                if (!(object instanceof Map)) break block18;
                Map map = (Map)object;
                Set set = map.keySet();
                if (set == null) break block17;
                TreeSet keySet = new TreeSet(set);
                int listIndex = 0;
                for (Object header : keySet) {
                    int maxLen = (Integer)list.get(listIndex);
                    if (listIndex == list.size() - 1) {
                        if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(header.toString(), maxLen, ' '));
                        } else {
                            System.out.print(header);
                        }
                    } else {
                        System.out.print(StringUtil.getRightPaddedString(header.toString(), maxLen, ' '));
                        System.out.print("  ");
                    }
                    ++listIndex;
                }
                break block17;
            }
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            int listIndex = 0;
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value2 = method.invoke(object, (Object[])null);
                    value2 = PrintUtil.getPrintableValue(value2);
                    int maxLen = (Integer)list.get(listIndex);
                    String header = name.substring(3);
                    if (listIndex == list.size() - 1) {
                        if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                        } else {
                            System.out.print(header);
                        }
                    } else {
                        System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                        System.out.print("  ");
                    }
                    ++listIndex;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private static void printBottomHeaders(List list, Object obj, boolean printLastColumnSpaces, String primitiveHeader) {
        block17: {
            Object object;
            block18: {
                block16: {
                    object = obj;
                    if (object == null) {
                        object = "null";
                    }
                    if (!(object instanceof String) && !object.getClass().isPrimitive() && object.getClass() != Boolean.class && object.getClass() != Byte.class && object.getClass() != Character.class && object.getClass() != Short.class && object.getClass() != Integer.class && object.getClass() != Long.class && object.getClass() != Float.class && object.getClass() != Double.class && !object.getClass().isArray() && !(object instanceof Date)) break block16;
                    int maxLen = (Integer)list.get(0);
                    if (maxLen < primitiveHeader.length()) {
                        maxLen = primitiveHeader.length();
                    }
                    if (printLastColumnSpaces) {
                        System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", primitiveHeader.length(), '-'), maxLen, ' '));
                    } else {
                        System.out.print(StringUtil.getRightPaddedString("", primitiveHeader.length(), '-'));
                    }
                    break block17;
                }
                if (!(object instanceof Map)) break block18;
                Map map = (Map)object;
                Set set = map.keySet();
                if (set == null) break block17;
                TreeSet keySet = new TreeSet(set);
                int listIndex = 0;
                for (Object header : keySet) {
                    Object value2 = map.get(header);
                    value2 = PrintUtil.getPrintableValue(value2);
                    int maxLen = (Integer)list.get(listIndex);
                    if (listIndex == list.size() - 1) {
                        if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.toString().length(), '-'), maxLen, ' '));
                        } else {
                            System.out.print(StringUtil.getRightPaddedString("", header.toString().length(), '-'));
                        }
                    } else {
                        System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.toString().length(), '-'), maxLen, ' '));
                        System.out.print("  ");
                    }
                    ++listIndex;
                }
                break block17;
            }
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            int listIndex = 0;
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value3 = method.invoke(object, (Object[])null);
                    value3 = PrintUtil.getPrintableValue(value3);
                    int maxLen = (Integer)list.get(listIndex);
                    String header = name.substring(3);
                    if (listIndex == list.size() - 1) {
                        if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                        } else {
                            System.out.print(StringUtil.getRightPaddedString("", header.length(), '-'));
                        }
                    } else {
                        System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                        System.out.print("  ");
                    }
                    ++listIndex;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private static void printHeaders(List keyList, List valueList, Object key2, Object value2, int rowMaxLen) throws Exception {
        PrintUtil.printHeaders(keyList, valueList, key2, value2, rowMaxLen, "Key", "Value", true);
    }

    private static void printHeaders(List keyList, List valueList, Object key2, Object value2, int rowMaxLen, String keyColumnName, String valueColumnName, boolean showValues) throws Exception {
        System.out.print(StringUtil.getRightPaddedString("Row", rowMaxLen, ' '));
        System.out.print("  ");
        PrintUtil.printTopHeaders(keyList, key2, true, keyColumnName);
        if (showValues) {
            System.out.print(" | ");
            PrintUtil.printTopHeaders(valueList, value2, false, valueColumnName);
        }
        System.out.println();
        if (rowMaxLen < 3) {
            rowMaxLen = 3;
        }
        System.out.print(StringUtil.getRightPaddedString("", rowMaxLen, '-'));
        System.out.print("  ");
        PrintUtil.printBottomHeaders(keyList, key2, true, keyColumnName);
        if (showValues) {
            System.out.print(" | ");
            PrintUtil.printBottomHeaders(valueList, value2, false, valueColumnName);
        }
        System.out.println();
    }

    public static int printSelectResults(SelectResults sr, int startIndex, int startRowNum, int rowCount) {
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printSelectResults(sr, startIndex, startRowNum, rowCount);
        }
        if (sr == null) {
            System.out.println("Error: SelectResults is null");
            return 0;
        }
        int endIndex = startIndex + rowCount;
        if (endIndex >= sr.size()) {
            endIndex = sr.size();
        }
        CollectionType type = sr.getCollectionType();
        ObjectType elementType = type.getElementType();
        int row = 1;
        if (rowCount == -1) {
            rowCount = sr.size();
        }
        HashSet<String> elementNameSet = new HashSet<String>();
        ArrayList maxLenList = new ArrayList();
        Object element = null;
        boolean isStructType = false;
        StructType structType = null;
        Struct struct = null;
        List srList = sr.asList();
        for (int i = startIndex; i < endIndex; ++i) {
            element = srList.get(i);
            if (elementType.isStructType()) {
                structType = (StructType)elementType;
                struct = (Struct)element;
                PrintUtil.computeMaxLengths(maxLenList, structType, struct);
                isStructType = true;
            } else {
                PrintUtil.computeMaxLengths(maxLenList, element, false);
                if (element != null) {
                    elementNameSet.add(element.getClass().getName());
                }
            }
            ++row;
        }
        if (element == null && struct == null) {
            return 0;
        }
        int rowMax = String.valueOf(startRowNum + rowCount - 1).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        if (isStructType) {
            PrintUtil.printHeaders(maxLenList, structType, struct, rowMax);
        } else {
            PrintUtil.printHeaders(maxLenList, element, rowMax);
        }
        row = startRowNum;
        for (int i = startIndex; i < endIndex; ++i) {
            element = srList.get(i);
            if (elementType.isStructType()) {
                structType = (StructType)elementType;
                struct = (Struct)element;
                System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
                System.out.print("  ");
                PrintUtil.printStruct(maxLenList, structType, struct);
                System.out.println();
            } else {
                System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
                System.out.print("  ");
                PrintUtil.printObject(maxLenList, element, false);
                System.out.println();
            }
            ++row;
        }
        System.out.println();
        for (Object e : elementNameSet) {
            System.out.println("Class: " + e);
        }
        return endIndex - startIndex;
    }

    private static int printSelectResults_iterator(SelectResults sr, int startRowNum, int rowCount) {
        if (sr == null) {
            System.out.println("SelectResults is null");
            return 0;
        }
        CollectionType type = sr.getCollectionType();
        ObjectType elementType = type.getElementType();
        int row = 1;
        if (rowCount == -1) {
            rowCount = sr.size();
        }
        HashSet<String> elementNameSet = new HashSet<String>();
        ArrayList maxLenList = new ArrayList();
        Object element = null;
        boolean isStructType = false;
        StructType structType = null;
        Struct struct = null;
        Iterator iter = sr.iterator();
        while (iter.hasNext() && row <= rowCount) {
            element = iter.next();
            if (elementType.isStructType()) {
                structType = (StructType)elementType;
                struct = (Struct)element;
                PrintUtil.computeMaxLengths(maxLenList, structType, struct);
                isStructType = true;
            } else {
                PrintUtil.computeMaxLengths(maxLenList, element, false);
                elementNameSet.add(element.getClass().getName());
            }
            ++row;
        }
        if (element == null && struct == null) {
            return 0;
        }
        int rowMax = String.valueOf(startRowNum + rowCount - 1).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        if (isStructType) {
            PrintUtil.printHeaders(maxLenList, structType, struct, rowMax);
        } else {
            PrintUtil.printHeaders(maxLenList, element, rowMax);
        }
        int lastRow = startRowNum + rowCount - 1;
        Iterator iter2 = sr.iterator();
        for (row = startRowNum; iter2.hasNext() && row <= lastRow; ++row) {
            element = iter2.next();
            if (elementType.isStructType()) {
                structType = (StructType)elementType;
                struct = (Struct)element;
                System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
                System.out.print("  ");
                PrintUtil.printStruct(maxLenList, structType, struct);
                System.out.println();
                continue;
            }
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            PrintUtil.printObject(maxLenList, element, false);
            System.out.println();
        }
        System.out.println();
        for (Object e : elementNameSet) {
            System.out.println("Class: " + e);
        }
        return row - 1;
    }

    private static void computeMaxLengths(List list, StructType structType, Struct struct) {
        ObjectType[] fieldTypes = structType.getFieldTypes();
        String[] fieldNames = structType.getFieldNames();
        Object[] fieldValues = struct.getFieldValues();
        int listIndex = 0;
        for (int i = 0; i < fieldTypes.length; ++i) {
            Integer len;
            ObjectType fieldType = fieldTypes[i];
            String fieldName = fieldNames[i];
            Object fieldValue = fieldValues[i];
            if (listIndex >= list.size()) {
                len = fieldName.length();
                list.add(len);
            } else {
                len = (Integer)list.get(listIndex);
            }
            if (fieldValue == null) {
                if (len < 4) {
                    len = 4;
                }
            } else {
                int valueLen = fieldValue.toString().length();
                if (len < valueLen) {
                    len = valueLen;
                }
            }
            list.set(listIndex, len);
            ++listIndex;
        }
    }

    private static void computeMaxLengths(List list, Object obj, boolean isKey) {
        PrintUtil.computeMaxLengths(list, obj, isKey, 3, 5);
    }

    private static void computeMaxLengths(List list, Object obj, boolean isKey, int keyMin, int valueMin) {
        block28: {
            Object object;
            block26: {
                block27: {
                    object = obj;
                    if (obj == null) {
                        object = "null";
                    }
                    if (!(object instanceof String) && !object.getClass().isPrimitive() && object.getClass() != Boolean.class && object.getClass() != Byte.class && object.getClass() != Character.class && object.getClass() != Short.class && object.getClass() != Integer.class && object.getClass() != Long.class && object.getClass() != Float.class && object.getClass() != Double.class && !object.getClass().isArray() && !(object instanceof Date)) break block26;
                    if (list.size() <= 0) break block27;
                    int len = (Integer)list.get(0);
                    if (len >= object.toString().length()) break block28;
                    list.set(0, object.toString().length());
                    break block28;
                }
                if (isKey) {
                    if (object.toString().length() < keyMin) {
                        list.add(keyMin);
                    } else {
                        list.add(object.toString().length());
                    }
                } else if (object.toString().length() < valueMin) {
                    list.add(valueMin);
                } else {
                    list.add(object.toString().length());
                }
                break block28;
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                Set set = map.keySet();
                if (set != null) {
                    TreeSet keySet = new TreeSet(set);
                    int listIndex = 0;
                    for (Object name : keySet) {
                        Integer len;
                        Object value2 = map.get(name);
                        value2 = PrintUtil.getPrintableValue(value2);
                        if (listIndex >= list.size()) {
                            len = name.toString().length();
                            list.add(len);
                        } else {
                            len = (Integer)list.get(listIndex);
                        }
                        if (value2 == null) {
                            if (len < 4) {
                                len = 4;
                            }
                        } else {
                            int valueLen = value2.toString().length();
                            if (len < valueLen) {
                                len = valueLen;
                            }
                        }
                        list.set(listIndex, len);
                        ++listIndex;
                    }
                }
            } else {
                Class<?> cls = object.getClass();
                Method[] methods = cls.getMethods();
                int listIndex = 0;
                for (int i = 0; i < methods.length; ++i) {
                    Class<?> retType;
                    Method method = methods[i];
                    String name = method.getName();
                    if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                    try {
                        Integer len;
                        Object value3 = method.invoke(object, (Object[])null);
                        value3 = PrintUtil.getPrintableValue(value3);
                        if (listIndex >= list.size()) {
                            len = name.length() - 3;
                            list.add(len);
                        } else {
                            len = (Integer)list.get(listIndex);
                        }
                        if (value3 == null) {
                            if (len < 4) {
                                len = 4;
                            }
                        } else {
                            int valueLen = value3.toString().length();
                            if (len < valueLen) {
                                len = valueLen;
                            }
                        }
                        list.set(listIndex, len);
                        ++listIndex;
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void printHeaders(List list, StructType structType, Struct struct, int rowMaxLen) {
        String header;
        int maxLen;
        Object fieldValue;
        String fieldName;
        ObjectType fieldType;
        int i;
        System.out.print(StringUtil.getRightPaddedString("Row", rowMaxLen, ' '));
        System.out.print("  ");
        ObjectType[] fieldTypes = structType.getFieldTypes();
        String[] fieldNames = structType.getFieldNames();
        Object[] fieldValues = struct.getFieldValues();
        int listIndex = 0;
        for (i = 0; i < fieldTypes.length; ++i) {
            fieldType = fieldTypes[i];
            fieldName = fieldNames[i];
            fieldValue = fieldValues[i];
            fieldValue = PrintUtil.getPrintableValue(fieldValue);
            maxLen = (Integer)list.get(listIndex);
            header = fieldName;
            System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
            System.out.print("  ");
            ++listIndex;
        }
        System.out.println();
        System.out.print(StringUtil.getRightPaddedString("", rowMaxLen, '-'));
        System.out.print("  ");
        listIndex = 0;
        for (i = 0; i < fieldTypes.length; ++i) {
            fieldType = fieldTypes[i];
            fieldName = fieldNames[i];
            fieldValue = fieldValues[i];
            fieldValue = PrintUtil.getPrintableValue(fieldValue);
            maxLen = (Integer)list.get(listIndex);
            header = fieldName;
            System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
            System.out.print("  ");
            ++listIndex;
        }
        System.out.println();
    }

    private static void printHeaders(List list, Object object, int rowMaxLen) {
        System.out.print(StringUtil.getRightPaddedString("Row", rowMaxLen, ' '));
        System.out.print("  ");
        PrintUtil.printTopHeaders(list, object, false, "Value");
        System.out.println();
        System.out.print(StringUtil.getRightPaddedString("", rowMaxLen, '-'));
        System.out.print("  ");
        PrintUtil.printBottomHeaders(list, object, false, "Value");
        System.out.println();
    }

    private static void printStruct(List list, StructType structType, Struct struct) {
        ObjectType[] fieldTypes = structType.getFieldTypes();
        String[] fieldNames = structType.getFieldNames();
        Object[] fieldValues = struct.getFieldValues();
        int listIndex = 0;
        for (int i = 0; i < fieldTypes.length; ++i) {
            ObjectType fieldType = fieldTypes[i];
            String fieldName = fieldNames[i];
            Object fieldValue = fieldValues[i];
            int maxLen = (Integer)list.get(listIndex);
            if (listIndex == list.size() - 1) {
                if (fieldValue == null) {
                    System.out.println("null");
                } else {
                    System.out.print(fieldValue.toString());
                }
            } else {
                if (fieldValue == null) {
                    System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                } else {
                    System.out.print(StringUtil.getRightPaddedString(fieldValue.toString(), maxLen, ' '));
                }
                System.out.print("  ");
            }
            ++listIndex;
        }
    }

    private static void printObject(List list, Object obj, boolean printLastColumnSpaces) {
        block30: {
            Object object;
            block31: {
                block29: {
                    object = obj;
                    if (object == null) {
                        object = "null";
                    }
                    if (!(object instanceof String) && !object.getClass().isPrimitive() && object.getClass() != Boolean.class && object.getClass() != Byte.class && object.getClass() != Character.class && object.getClass() != Short.class && object.getClass() != Integer.class && object.getClass() != Long.class && object.getClass() != Float.class && object.getClass() != Double.class && !object.getClass().isArray() && !(object instanceof Date)) break block29;
                    object = PrintUtil.getPrintableValue(object);
                    if (list.size() > 0) {
                        int maxLen = (Integer)list.get(0);
                        if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(object.toString(), maxLen, ' '));
                        } else {
                            System.out.print(object.toString());
                        }
                    } else {
                        System.out.print(object.toString());
                    }
                    break block30;
                }
                if (!(object instanceof Map)) break block31;
                Map map = (Map)object;
                Set set = map.keySet();
                if (set == null) break block30;
                TreeSet keySet = new TreeSet(set);
                int listIndex = 0;
                for (Object key2 : keySet) {
                    Object value2 = map.get(key2);
                    value2 = PrintUtil.getPrintableValue(value2);
                    int maxLen = (Integer)list.get(listIndex);
                    if (listIndex == list.size() - 1) {
                        if (value2 == null) {
                            if (printLastColumnSpaces) {
                                System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                            } else {
                                System.out.print("null");
                            }
                        } else if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(value2.toString(), maxLen, ' '));
                        } else {
                            System.out.print(value2.toString());
                        }
                    } else {
                        if (value2 == null) {
                            System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                        } else {
                            System.out.print(StringUtil.getRightPaddedString(value2.toString(), maxLen, ' '));
                        }
                        System.out.print("  ");
                    }
                    ++listIndex;
                }
                break block30;
            }
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            int listIndex = 0;
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value3 = method.invoke(object, (Object[])null);
                    value3 = PrintUtil.getPrintableValue(value3);
                    int maxLen = (Integer)list.get(listIndex);
                    if (listIndex == list.size() - 1) {
                        if (value3 == null) {
                            if (printLastColumnSpaces) {
                                System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                            } else {
                                System.out.print("null");
                            }
                        } else if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(value3.toString(), maxLen, ' '));
                        } else {
                            System.out.print(value3.toString());
                        }
                    } else {
                        if (value3 == null) {
                            System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                        } else {
                            System.out.print(StringUtil.getRightPaddedString(value3.toString(), maxLen, ' '));
                        }
                        System.out.print("  ");
                    }
                    ++listIndex;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public static void printList(List resultList) {
        ArrayList maxLenList = new ArrayList();
        Object nonNullObject = null;
        for (int i = 0; i < resultList.size(); ++i) {
            Object object = resultList.get(i);
            if (object != null) {
                nonNullObject = object;
            }
            PrintUtil.computeMaxLengths(maxLenList, object, true);
        }
        if (nonNullObject == null) {
            return;
        }
        int rowMax = String.valueOf(resultList.size()).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(maxLenList, nonNullObject, rowMax);
        for (int i = 0; i < resultList.size(); ++i) {
            Object object = resultList.get(i);
            System.out.print(StringUtil.getRightPaddedString(i + 1 + "", rowMax, ' '));
            System.out.print("  ");
            PrintUtil.printObject(maxLenList, object, false);
            System.out.println();
        }
    }

    public static int printList(List list, int startIndex, int startRowNum, int rowCount, int actualSize, List keyList) throws Exception {
        int count;
        if (list == null || list.size() == 0) {
            return 0;
        }
        if (!PrintUtil.isTableFormat()) {
            return SimplePrintUtil.printList(list, startIndex, startRowNum, rowCount, actualSize, keyList);
        }
        HashSet<String> objectNameSet = new HashSet<String>();
        ArrayList maxLenList = new ArrayList();
        Object object = null;
        Iterator itr = list.iterator();
        for (count = 0; count < rowCount && itr.hasNext(); ++count) {
            object = itr.next();
            PrintUtil.computeMaxLengths(maxLenList, object, true);
            objectNameSet.add(object.getClass().getName());
        }
        if (object == null) {
            return 0;
        }
        int rowMax = String.valueOf(startRowNum + rowCount - 1).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printHeaders(maxLenList, object, rowMax);
        int row = startRowNum;
        int lastRow = startRowNum + rowCount - 1;
        Iterator itr2 = list.iterator();
        for (count = 0; count < rowCount && itr2.hasNext(); ++count) {
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            object = itr2.next();
            if (keyList != null) {
                keyList.add(object);
            }
            PrintUtil.printObject(maxLenList, object, true);
            System.out.println();
            ++row;
        }
        System.out.println();
        System.out.println(" Fetch size: " + rowCount);
        System.out.println("   Returned: " + (row - 1) + "/" + actualSize);
        for (Object e : objectNameSet) {
            System.out.println("      Class: " + e);
        }
        return count;
    }

    private static void computeMappableMaxLengths(List list, Mappable mappable) {
        PrintUtil.computeMappableMaxLengths(list, mappable, null);
    }

    private static void computeMappableMaxLengths(List list, Mappable mappable, List<String> keyList) {
        int listIndex = 0;
        if (keyList == null) {
            keyList = new ArrayList<String>(mappable.getKeys());
            Collections.sort(keyList);
        }
        for (int i = 0; i < keyList.size(); ++i) {
            Integer len;
            String name = keyList.get(i);
            Object value2 = mappable.getValue(name);
            value2 = PrintUtil.getPrintableValue(value2);
            if (listIndex >= list.size()) {
                len = name.length();
                list.add(len);
            } else {
                len = (Integer)list.get(listIndex);
            }
            if (value2 == null) {
                if (len < 4) {
                    len = 4;
                }
            } else {
                int valueLen = value2.toString().length();
                if (len < valueLen) {
                    len = valueLen;
                }
            }
            list.set(listIndex, len);
            ++listIndex;
        }
    }

    private static void printMappableHeaders(List list, Mappable mappable, int rowMaxLen) {
        PrintUtil.printMappableHeaders(list, mappable, rowMaxLen, null);
    }

    private static void printMappableHeaders(List list, Mappable mappable, int rowMaxLen, List<String> keyList) {
        System.out.print(StringUtil.getRightPaddedString("Row", rowMaxLen, ' '));
        System.out.print("  ");
        PrintUtil.printMappableTopHeaders(list, mappable, false, keyList);
        System.out.println();
        if (rowMaxLen < 3) {
            rowMaxLen = 3;
        }
        System.out.print(StringUtil.getRightPaddedString("", rowMaxLen, '-'));
        System.out.print("  ");
        PrintUtil.printMappableBottomHeaders(list, mappable, false, keyList);
        System.out.println();
    }

    private static void printMappableTopHeaders(List list, Mappable mappable, boolean printLastColumnSpaces, List<String> keyList) {
        int listIndex = 0;
        if (keyList == null) {
            keyList = new ArrayList<String>(mappable.getKeys());
            Collections.sort(keyList);
        }
        for (int i = 0; i < keyList.size(); ++i) {
            String header = keyList.get(i);
            int maxLen = (Integer)list.get(listIndex);
            if (listIndex == list.size() - 1) {
                if (printLastColumnSpaces) {
                    System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                } else {
                    System.out.print(header);
                }
            } else {
                System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                System.out.print("  ");
            }
            ++listIndex;
        }
    }

    private static void printMappableBottomHeaders(List list, Mappable mappable, boolean printLastColumnSpaces, List<String> keyList) {
        int listIndex = 0;
        if (keyList == null) {
            keyList = new ArrayList<String>(mappable.getKeys());
            Collections.sort(keyList);
        }
        for (int i = 0; i < keyList.size(); ++i) {
            String header = keyList.get(i);
            int maxLen = (Integer)list.get(listIndex);
            if (listIndex == list.size() - 1) {
                if (printLastColumnSpaces) {
                    System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                } else {
                    System.out.print(StringUtil.getRightPaddedString("", header.length(), '-'));
                }
            } else {
                System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                System.out.print("  ");
            }
            ++listIndex;
        }
    }

    private static void printMappable(List list, Mappable mappable, boolean printLastColumnSpaces) {
        PrintUtil.printMappable(list, mappable, printLastColumnSpaces, null);
    }

    private static void printMappable(List list, Mappable mappable, boolean printLastColumnSpaces, List<String> keyList) {
        int listIndex = 0;
        if (keyList == null) {
            keyList = new ArrayList<String>(mappable.getKeys());
            Collections.sort(keyList);
        }
        for (int i = 0; i < keyList.size(); ++i) {
            String name = keyList.get(i);
            Object value2 = mappable.getValue(name);
            value2 = PrintUtil.getPrintableValue(value2);
            int maxLen = (Integer)list.get(listIndex);
            if (listIndex == list.size() - 1) {
                if (value2 == null) {
                    if (printLastColumnSpaces) {
                        System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                    } else {
                        System.out.print("null");
                    }
                } else if (printLastColumnSpaces) {
                    System.out.print(StringUtil.getRightPaddedString(value2.toString(), maxLen, ' '));
                } else {
                    System.out.print(value2.toString());
                }
            } else {
                if (value2 == null) {
                    System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                } else {
                    System.out.print(StringUtil.getRightPaddedString(value2.toString(), maxLen, ' '));
                }
                System.out.print("  ");
            }
            ++listIndex;
        }
    }

    public static void printMappableList(List<Mappable> resultList) {
        PrintUtil.printMappableList(resultList, null);
    }

    public static void printMappableList(List<Mappable> resultList, String sortByKey) {
        List<Mappable> list;
        if (sortByKey != null) {
            TreeMap<Object, Mappable> map = new TreeMap<Object, Mappable>();
            for (int i = 0; i < resultList.size(); ++i) {
                Mappable mappable = resultList.get(i);
                map.put(mappable.getValue(sortByKey), mappable);
            }
            list = new ArrayList(map.values());
        } else {
            list = resultList;
        }
        if (!PrintUtil.isTableFormat()) {
            SimplePrintUtil.printMappableList(list);
            return;
        }
        ArrayList maxLenList = new ArrayList();
        Mappable nonNullMappable = null;
        for (int i = 0; i < list.size(); ++i) {
            Mappable mappable = list.get(i);
            if (mappable != null) {
                nonNullMappable = mappable;
            }
            PrintUtil.computeMappableMaxLengths(maxLenList, mappable);
        }
        if (nonNullMappable == null) {
            return;
        }
        int rowMax = String.valueOf(list.size()).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printMappableHeaders(maxLenList, nonNullMappable, rowMax);
        for (int i = 0; i < list.size(); ++i) {
            Mappable mappable = list.get(i);
            System.out.print(StringUtil.getRightPaddedString(i + 1 + "", rowMax, ' '));
            System.out.print("  ");
            PrintUtil.printMappable(maxLenList, mappable, false);
            System.out.println();
        }
    }

    public static void printMappableList(List<Mappable> resultList, String sortByKey, List<String> keyList) {
        List<Mappable> list;
        if (sortByKey != null) {
            TreeMap<Object, Mappable> map = new TreeMap<Object, Mappable>();
            for (int i = 0; i < resultList.size(); ++i) {
                Mappable mappable = resultList.get(i);
                map.put(mappable.getValue(sortByKey), mappable);
            }
            list = new ArrayList(map.values());
        } else {
            list = resultList;
        }
        if (!PrintUtil.isTableFormat()) {
            SimplePrintUtil.printMappableList(list);
            return;
        }
        ArrayList maxLenList = new ArrayList();
        Mappable nonNullMappable = null;
        for (int i = 0; i < list.size(); ++i) {
            Mappable mappable = list.get(i);
            if (mappable != null) {
                nonNullMappable = mappable;
            }
            PrintUtil.computeMappableMaxLengths(maxLenList, mappable, keyList);
        }
        if (nonNullMappable == null) {
            return;
        }
        int rowMax = String.valueOf(list.size()).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        PrintUtil.printMappableHeaders(maxLenList, nonNullMappable, rowMax, keyList);
        for (int i = 0; i < list.size(); ++i) {
            Mappable mappable = list.get(i);
            System.out.print(StringUtil.getRightPaddedString(i + 1 + "", rowMax, ' '));
            System.out.print("  ");
            PrintUtil.printMappable(maxLenList, mappable, false, keyList);
            System.out.println();
        }
    }

    private static Object getPrintableValue(Object value2) {
        if (value2 instanceof Byte) {
            value2 = ((Byte)value2).toString();
        } else if (value2 instanceof byte[]) {
            value2 = "[B " + ((byte[])value2).length;
        } else if (value2 instanceof boolean[]) {
            value2 = "[Z " + ((boolean[])value2).length;
        } else if (value2 instanceof short[]) {
            value2 = "[S " + ((short[])value2).length;
        } else if (value2 instanceof int[]) {
            value2 = "[I " + ((int[])value2).length;
        } else if (value2 instanceof long[]) {
            value2 = "[J " + ((long[])value2).length;
        } else if (value2 instanceof float[]) {
            value2 = "[F " + ((float[])value2).length;
        } else if (value2 instanceof double[]) {
            value2 = "[D " + ((double[])value2).length;
        }
        return value2;
    }
}

