/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.util;

import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class ObjectUtil {
    public static Object updateObject(Gfsh gfsh, Map<String, Method> setterMap, Object obj, String setterMethodName, String value2, SimpleDateFormat dateFormat, boolean isCsvFormat) throws Exception {
        Method setterMethod = setterMap.get(setterMethodName);
        if (setterMethod == null) {
            return obj;
        }
        Class<?>[] types = setterMethod.getParameterTypes();
        Class<?> arg = types[0];
        if (arg == Byte.TYPE || arg == Byte.class) {
            setterMethod.invoke(obj, Byte.parseByte(value2));
        } else if (arg == Character.TYPE || arg == Character.class) {
            setterMethod.invoke(obj, Character.valueOf(value2.charAt(0)));
        } else if (arg == Short.TYPE || arg == Short.class) {
            setterMethod.invoke(obj, Short.parseShort(value2));
        } else if (arg == Integer.TYPE || arg == Integer.class) {
            setterMethod.invoke(obj, Integer.parseInt(value2));
        } else if (arg == Long.TYPE || arg == Long.class) {
            setterMethod.invoke(obj, Long.parseLong(value2));
        } else if (arg == Float.TYPE || arg == Float.class) {
            setterMethod.invoke(obj, Float.valueOf(Float.parseFloat(value2)));
        } else if (arg == Double.TYPE || arg == Double.class) {
            setterMethod.invoke(obj, Double.parseDouble(value2));
        } else if (arg == Date.class) {
            Date date = dateFormat.parse(value2);
            setterMethod.invoke(obj, date);
        } else if (arg == String.class) {
            if (isCsvFormat) {
                if ((value2 = value2.replaceAll("\"\"", "\"")).startsWith("\"")) {
                    value2 = value2.substring(1);
                }
                if (value2.endsWith("\"")) {
                    value2 = value2.substring(0, value2.length() - 1);
                }
            }
            setterMethod.invoke(obj, value2);
        } else {
            gfsh.println("Error: unsupported type: " + setterMethod.getName() + "(" + arg.getName() + ")");
        }
        return obj;
    }

    public static Object getPrimitive(Gfsh gfsh, String value2, boolean quoted) throws ParseException {
        if (quoted) {
            return value2;
        }
        if ((value2 = value2.trim().toLowerCase()).length() == 0) {
            return null;
        }
        char firstChar = value2.charAt(0);
        if (firstChar != '.' && (firstChar < '0' || firstChar > '9')) {
            return null;
        }
        Serializable obj = null;
        obj = value2.endsWith("b") ? new Byte(value2.substring(0, value2.length() - 1)) : (value2.endsWith("c") ? Character.valueOf(value2.charAt(0)) : (value2.endsWith("s") ? new Short(value2.substring(0, value2.length() - 1)) : (value2.endsWith("i") ? new Integer(value2.substring(0, value2.length() - 1)) : (value2.endsWith("l") ? new Long(value2.substring(0, value2.length() - 1)) : (value2.endsWith("f") ? new Float(value2.substring(0, value2.length() - 1)) : (value2.endsWith("d") ? new Double(value2.substring(0, value2.length() - 1)) : (value2.startsWith("to_date") ? gfsh.getDate(value2) : (value2.indexOf(".") != -1 || value2.indexOf("e") != -1 ? (Number)new Double(value2) : (Number)new Integer(value2)))))))));
        return obj;
    }

    public static Object updateObject(Gfsh gfsh, Map<String, Method> setterMap, Object obj, String tableColumnName, Object value2) throws Exception {
        Method setterMethod = setterMap.get("set" + tableColumnName);
        if (setterMethod == null) {
            return obj;
        }
        setterMethod.invoke(obj, value2);
        return obj;
    }

    public static Object getPrintableObject(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof String || object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class) {
            return object.toString();
        }
        if (object instanceof Date) {
            return object.toString();
        }
        return ReflectionUtil.toStringGettersAnd(object);
    }
}

