/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.util;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.gemstone.gnu.trove.TObjectIntIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class GfshResultsBag
extends AbstractCollection
implements SelectResults,
DataSerializable {
    protected ObjectType elementType;
    protected TObjectIntHashMap map;
    protected int size = 0;
    protected int numNulls = 0;
    private int limit = -1;
    boolean hasLimitIterator = false;
    final Object limitLock = new Object();

    public GfshResultsBag() {
        this.map = new TObjectIntHashMap();
    }

    @Override
    public void setElementType(ObjectType elementType) {
        this.elementType = elementType;
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return new SetView();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Collection.class, this.elementType);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    public int occurrences(Object element) {
        if (this.hasLimitIterator) {
            int count = 0;
            boolean encounteredObject = false;
            for (Object v : this) {
                if (element == null ? v == null : element.equals(v)) {
                    ++count;
                    encounteredObject = true;
                    continue;
                }
                if (!encounteredObject) continue;
                break;
            }
            return count;
        }
        if (element == null) {
            return this.numNulls;
        }
        return this.map.get(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                return new LimitResultsBagIterator();
            }
        }
        return new ResultsBagIterator();
    }

    @Override
    public boolean contains(Object element) {
        if (this.hasLimitIterator) {
            return super.contains(element);
        }
        if (element == null) {
            return this.numNulls > 0;
        }
        return this.map.containsKey(element);
    }

    @Override
    public boolean add(Object element) {
        if (this.limit > -1) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as the query result is constrained by LIMIT");
        }
        if (element == null) {
            ++this.numNulls;
        } else {
            int count = this.map.get(element);
            this.map.put(element, count + 1);
        }
        ++this.size;
        assert (this.size >= 0) : this.size;
        return true;
    }

    public int addAndGetOccurence(Object element) {
        int occurence;
        if (element == null) {
            ++this.numNulls;
            occurence = this.numNulls;
        } else {
            occurence = this.map.get(element);
            this.map.put(element, ++occurence);
        }
        ++this.size;
        assert (this.size >= 0) : this.size;
        return occurence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                return this.limit;
            }
        }
        return this.size;
    }

    @Override
    public boolean remove(Object element) {
        if (this.hasLimitIterator) {
            return super.remove(element);
        }
        if (element == null) {
            if (this.numNulls > 0) {
                --this.numNulls;
                --this.size;
                assert (this.size >= 0) : this.size;
                return true;
            }
            return false;
        }
        int count = this.map.get(element);
        if (count == 0) {
            return false;
        }
        if (count == 1) {
            this.map.remove(element);
        } else {
            this.map.put(element, --count);
        }
        --this.size;
        assert (this.size >= 0) : this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.map.clear();
        this.numNulls = 0;
        this.size = 0;
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                this.limit = 0;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GfshResultsBag)) {
            return false;
        }
        GfshResultsBag otherBag = (GfshResultsBag)o;
        return this.size == otherBag.size && this.elementType.equals(otherBag.elementType) && this.map.equals(otherBag.map) && this.numNulls == otherBag.numNulls;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean addAll(Collection coll) {
        if (this.limit > -1) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as the query result is constrained by LIMIT");
        }
        return super.addAll(coll);
    }

    protected TObjectIntHashMap createMapForFromData() {
        return new TObjectIntHashMap(this.size);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int occurence;
        this.elementType = (ObjectType)DataSerializer.readObject(in);
        this.size = in.readInt();
        assert (this.size >= 0) : this.size;
        this.readNumNulls(in);
        for (int numLeft = this.size - this.numNulls; numLeft > 0; numLeft -= occurence) {
            Object key2 = DataSerializer.readObject(in);
            occurence = in.readInt();
            this.map.put(key2, occurence);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        int occurence;
        DataSerializer.writeObject(this.elementType, out);
        out.writeInt(this.size());
        this.writeNumNulls(out);
        TObjectIntIterator itr = this.map.iterator();
        for (int numLeft = this.size() - this.numNulls; itr.hasNext() && numLeft > 0; numLeft -= occurence) {
            itr.advance();
            Object key2 = itr.key();
            DataSerializer.writeObject(key2, out);
            occurence = itr.value();
            if (numLeft < occurence) {
                occurence = numLeft;
            }
            out.writeInt(occurence);
        }
    }

    void writeNumNulls(DataOutput out) throws IOException {
        out.writeInt(this.numNulls);
    }

    void readNumNulls(DataInput in) throws IOException {
        this.numNulls = in.readInt();
    }

    void createTObjectIntHashMap() {
        this.map = new TObjectIntHashMap(this.size - this.numNulls);
    }

    void applyLimit(int limit) {
        this.limit = limit;
        if (this.limit > -1 && this.size > this.limit) {
            this.hasLimitIterator = true;
        }
    }

    protected class LimitResultsBagIterator
    extends ResultsBagIterator {
        private final int localLimit;
        private int currPos;

        public LimitResultsBagIterator() {
            this.currPos = 0;
            this.localLimit = GfshResultsBag.this.limit;
        }

        @Override
        public boolean hasNext() {
            return this.currPos < this.localLimit;
        }

        @Override
        public Object next() {
            if (this.currPos == this.localLimit) {
                throw new NoSuchElementException();
            }
            Object next2 = super.next();
            ++this.currPos;
            return next2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.currPos == 0) {
                throw new IllegalStateException("next() must be called before remove()");
            }
            Object object = GfshResultsBag.this.limitLock;
            synchronized (object) {
                super.remove();
                --GfshResultsBag.this.limit;
            }
        }
    }

    class SetView
    extends AbstractSet {
        private int localLimit;

        SetView() {
            this.localLimit = GfshResultsBag.this.limit;
        }

        @Override
        public Iterator iterator() {
            if (this.localLimit > -1) {
                return new LimitSetViewIterator();
            }
            return new SetViewIterator();
        }

        @Override
        public boolean add(Object o) {
            if (this.contains(o)) {
                return false;
            }
            return GfshResultsBag.this.add(o);
        }

        @Override
        public void clear() {
            GfshResultsBag.this.clear();
        }

        @Override
        public int size() {
            int calculatedSize = GfshResultsBag.this.map.size() + (GfshResultsBag.this.numNulls > 0 ? 1 : 0);
            if (this.localLimit > -1) {
                return Math.min(this.localLimit, calculatedSize);
            }
            return calculatedSize;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return GfshResultsBag.this.numNulls > 0;
            }
            return GfshResultsBag.this.map.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            if (this.localLimit == 0) {
                return true;
            }
            if (GfshResultsBag.this.numNulls > 0) {
                return false;
            }
            return GfshResultsBag.this.map.isEmpty();
        }

        class LimitSetViewIterator
        extends SetViewIterator {
            private int currPos;

            LimitSetViewIterator() {
                this.currPos = 0;
            }

            @Override
            public Object next() {
                if (this.currPos == SetView.this.localLimit) {
                    throw new NoSuchElementException();
                }
                Object next2 = super.next();
                ++this.currPos;
                return next2;
            }

            @Override
            public boolean hasNext() {
                return this.currPos < SetView.this.localLimit && super.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.currPos == 0) {
                    throw new IllegalStateException("next() must be called before remove()");
                }
                Object object = GfshResultsBag.this.limitLock;
                synchronized (object) {
                    if (this.currentIsNull) {
                        GfshResultsBag.this.limit -= GfshResultsBag.this.numNulls;
                        GfshResultsBag.this.numNulls = 0;
                        SetView.this.localLimit--;
                    } else {
                        Object key2 = this.it.key();
                        int count = GfshResultsBag.this.map.remove(key2);
                        assert (count != 0) : "Attempted to remove an element that was not in the map.";
                        GfshResultsBag.this.limit -= count;
                        SetView.this.localLimit--;
                    }
                }
            }
        }

        public class SetViewIterator
        implements Iterator {
            boolean emitNull;
            final TObjectIntIterator it;
            boolean currentIsNull;

            public SetViewIterator() {
                this.emitNull = GfshResultsBag.this.numNulls > 0;
                this.it = GfshResultsBag.this.map.iterator();
                this.currentIsNull = false;
            }

            public Object next() {
                if (this.emitNull) {
                    this.emitNull = false;
                    this.currentIsNull = true;
                    return null;
                }
                this.it.advance();
                this.currentIsNull = false;
                return this.it.key();
            }

            @Override
            public boolean hasNext() {
                if (this.emitNull) {
                    return true;
                }
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                if (this.currentIsNull) {
                    GfshResultsBag.this.numNulls = 0;
                } else {
                    this.it.remove();
                }
            }
        }
    }

    protected class ResultsBagIterator
    implements Iterator {
        final TObjectIntIterator mapIterator;
        Object current;
        int currentDup;
        int dupLimit;

        protected ResultsBagIterator() {
            this.mapIterator = GfshResultsBag.this.map.iterator();
            this.current = null;
            this.currentDup = 0;
            this.dupLimit = GfshResultsBag.this.numNulls;
        }

        @Override
        public boolean hasNext() {
            return this.mapIterator.hasNext() || this.currentDup < this.dupLimit;
        }

        public Object next() {
            if (this.currentDup < this.dupLimit) {
                ++this.currentDup;
                return this.current;
            }
            this.mapIterator.advance();
            this.dupLimit = this.mapIterator.value();
            this.currentDup = 1;
            this.current = this.mapIterator.key();
            return this.current;
        }

        @Override
        public void remove() {
            --this.dupLimit;
            assert (this.dupLimit >= 0) : this.dupLimit;
            if (this.current == null) {
                GfshResultsBag.this.numNulls = this.dupLimit;
                assert (GfshResultsBag.this.numNulls >= 0) : GfshResultsBag.this.numNulls;
            } else if (this.dupLimit > 0) {
                this.mapIterator.setValue(this.dupLimit);
            } else {
                this.mapIterator.remove();
            }
            --GfshResultsBag.this.size;
            --this.currentDup;
            assert (GfshResultsBag.this.size >= 0) : GfshResultsBag.this.size;
            assert (this.currentDup >= 0) : this.currentDup;
        }
    }
}

