/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.pogo;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.MapLite;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

abstract class MapLiteSerializer
extends DataSerializer {
    MapLiteSerializer() {
    }

    public static void write(Class cls, Object object, DataOutput out) throws IOException {
        if (cls == String.class) {
            MapLiteSerializer.writeUTF((String)object, out);
        } else if (cls == Boolean.TYPE || cls == Boolean.class) {
            MapLiteSerializer.writeBoolean((Boolean)object, out);
        } else if (cls == Byte.TYPE || cls == Byte.class) {
            MapLiteSerializer.writeByte((Byte)object, out);
        } else if (cls == Character.TYPE || cls == Character.class) {
            MapLiteSerializer.writeCharacter((Character)object, out);
        } else if (cls == Double.TYPE || cls == Double.class) {
            MapLiteSerializer.writeDouble((Double)object, out);
        } else if (cls == Float.TYPE || cls == Float.class) {
            MapLiteSerializer.writeFloat((Float)object, out);
        } else if (cls == Integer.TYPE || cls == Integer.class) {
            MapLiteSerializer.writeInteger((Integer)object, out);
        } else if (cls == Long.TYPE || cls == Long.class) {
            MapLiteSerializer.writeLong((Long)object, out);
        } else if (cls == Short.TYPE || cls == Short.class) {
            MapLiteSerializer.writeShort((Short)object, out);
        } else if (cls == MapLite.class) {
            MapLiteSerializer.writeMapLite((MapLite)object, out);
        } else if (cls == Date.class) {
            MapLiteSerializer.writeObject((Date)object, out);
        } else if (cls == boolean[].class) {
            MapLiteSerializer.writeBooleanArray((boolean[])object, out);
        } else if (cls == byte[].class) {
            MapLiteSerializer.writeByteArray((byte[])object, out);
        } else if (cls == char[].class) {
            MapLiteSerializer.writeCharArray((char[])object, out);
        } else if (cls == double[].class) {
            MapLiteSerializer.writeDoubleArray((double[])object, out);
        } else if (cls == float[].class) {
            MapLiteSerializer.writeFloatArray((float[])object, out);
        } else if (cls == int[].class) {
            MapLiteSerializer.writeIntArray((int[])object, out);
        } else if (cls == long[].class) {
            MapLiteSerializer.writeLongArray((long[])object, out);
        } else if (cls == short[].class) {
            MapLiteSerializer.writeShortArray((short[])object, out);
        } else {
            MapLiteSerializer.writeObject(object, out);
        }
    }

    public static Object read(Class cls, DataInput in) throws IOException, ClassNotFoundException {
        Object value2 = cls == String.class ? MapLiteSerializer.readUTF(in) : (cls == Boolean.TYPE || cls == Boolean.class ? MapLiteSerializer.readBoolean(in) : (cls == Byte.TYPE || cls == Byte.class ? MapLiteSerializer.readByte(in) : (cls == Character.TYPE || cls == Character.class ? MapLiteSerializer.readCharacter(in) : (cls == Double.TYPE || cls == Double.class ? MapLiteSerializer.readDouble(in) : (cls == Float.TYPE || cls == Float.class ? MapLiteSerializer.readFloat(in) : (cls == Integer.TYPE || cls == Integer.class ? MapLiteSerializer.readInteger(in) : (cls == Long.TYPE || cls == Long.class ? MapLiteSerializer.readLong(in) : (cls == Short.TYPE || cls == Short.class ? MapLiteSerializer.readShort(in) : (cls == MapLite.class ? MapLiteSerializer.readMapLite(in) : (cls == Date.class ? MapLiteSerializer.readObject(in) : (cls == boolean[].class ? (Object)DataSerializer.readBooleanArray(in) : (cls == byte[].class ? (Object)DataSerializer.readByteArray(in) : (cls == char[].class ? DataSerializer.readCharacter(in) : (cls == double[].class ? (Object)DataSerializer.readByteArray(in) : (cls == float[].class ? (Object)DataSerializer.readByteArray(in) : (cls == int[].class ? (Object)DataSerializer.readByteArray(in) : (cls == long[].class ? (Object)DataSerializer.readByteArray(in) : (cls == short[].class ? (Object)DataSerializer.readByteArray(in) : DataSerializer.readObject(in)))))))))))))))))));
        return value2;
    }

    public static void writeByteArray(byte[] array, byte[] buffer, Deflater compressor, DataOutput output) throws IOException {
        compressor.setInput(array);
        compressor.finish();
        int compressedDataLength = compressor.deflate(buffer);
        DataSerializer.writeByteArray(buffer, compressedDataLength, output);
    }

    public static byte[] readByteArray(byte[] buffer, Inflater decompressor, DataInput input) throws IOException {
        byte[] compressedBuffer = DataSerializer.readByteArray(input);
        decompressor.setInput(compressedBuffer, 0, compressedBuffer.length);
        byte[] retval = null;
        try {
            int resultLength = decompressor.inflate(buffer);
            retval = new byte[resultLength];
            System.arraycopy(compressedBuffer, 0, retval, 0, resultLength);
        }
        catch (DataFormatException e) {
            throw new IOException("Unable to decompress the byte array due to a data format error. " + e.getMessage());
        }
        return retval;
    }

    public static String readUTF(DataInput input) throws IOException {
        byte header = input.readByte();
        if (header == 69) {
            return null;
        }
        return input.readUTF();
    }

    public static void writeUTF(String value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeByte(69);
        } else {
            output.writeByte(42);
            output.writeUTF(value2);
        }
    }

    public static Boolean readBoolean(DataInput input) throws IOException {
        return input.readBoolean();
    }

    public static void writeBoolean(Boolean value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(value2);
        }
    }

    public static Byte readByte(DataInput input) throws IOException {
        return input.readByte();
    }

    public static void writeByte(Byte value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeByte(0);
        } else {
            output.writeByte(value2.byteValue());
        }
    }

    public static Character readCharacter(DataInput input) throws IOException {
        return Character.valueOf(input.readChar());
    }

    public static void writeCharacter(Character value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeChar(0);
        } else {
            output.writeChar(value2.charValue());
        }
    }

    public static Double readDouble(DataInput input) throws IOException {
        return input.readDouble();
    }

    public static void writeDouble(Double value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeDouble(0.0);
        } else {
            output.writeDouble(value2);
        }
    }

    public static Float readFloat(DataInput input) throws IOException {
        return Float.valueOf(input.readFloat());
    }

    public static void writeFloat(Float value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeFloat(0.0f);
        } else {
            output.writeFloat(value2.floatValue());
        }
    }

    public static Integer readInteger(DataInput input) throws IOException {
        return input.readInt();
    }

    public static void writeInteger(Integer value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeInt(0);
        } else {
            output.writeInt(value2);
        }
    }

    public static Long readLong(DataInput input) throws IOException {
        return input.readLong();
    }

    public static void writeLong(Long value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeLong(0L);
        } else {
            output.writeLong(value2);
        }
    }

    public static Short readShort(DataInput input) throws IOException {
        return input.readShort();
    }

    public static void writeShort(Short value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeShort(0);
        } else {
            output.writeShort(value2.shortValue());
        }
    }

    public static MapLite readMapLite(DataInput input) throws ClassNotFoundException, IOException {
        byte header = input.readByte();
        if (header == 41) {
            return null;
        }
        MapLite fo = new MapLite();
        InternalDataSerializer.invokeFromData(fo, input);
        return fo;
    }

    public static void writeMapLite(MapLite value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeByte(41);
        } else {
            output.writeByte(4);
            InternalDataSerializer.invokeToData(value2, output);
        }
    }
}

