/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.misc.util;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ClassFinder;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyType;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyTypeManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SystemClassPathManager {
    private static final Class[] parameters = new Class[]{URL.class};

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        SystemClassPathManager.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        SystemClassPathManager.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public static void addJarsInDir(String dirPath) {
        File[] files;
        if (dirPath == null) {
            return;
        }
        File classDirFile = new File(dirPath);
        classDirFile.mkdirs();
        ArrayList<String> jarList = new ArrayList<String>();
        for (File file : files = classDirFile.listFiles()) {
            if (!file.isFile()) continue;
            String fileName = file.getName();
            jarList.add(file.getAbsolutePath());
        }
        Collections.sort(jarList);
        String prevFileNameNoDate = "";
        ArrayList<File> datedFiles = new ArrayList<File>();
        ArrayList<File> notDatedFiles = new ArrayList<File>();
        for (int i = jarList.size() - 1; i >= 0; --i) {
            String filePath = (String)jarList.get(i);
            if (!filePath.endsWith(".jar")) continue;
            File file = new File(filePath);
            String fileName = file.getName();
            String nameNoExtension = fileName.substring(0, fileName.lastIndexOf(".jar"));
            int index2 = nameNoExtension.lastIndexOf(".v");
            if (index2 == -1) {
                notDatedFiles.add(file);
                continue;
            }
            String fileNameNoDate = nameNoExtension.substring(0, index2);
            if (fileNameNoDate.equals(prevFileNameNoDate)) continue;
            try {
                SystemClassPathManager.addFile(file);
                datedFiles.add(file);
            }
            catch (IOException e) {
                CacheFactory.getAnyInstance().getLogger().error(e);
            }
            prevFileNameNoDate = fileNameNoDate;
        }
        Collections.sort(notDatedFiles);
        for (File file : notDatedFiles) {
            try {
                SystemClassPathManager.addFile(file);
            }
            catch (IOException e) {
                CacheFactory.getAnyInstance().getLogger().error(e);
            }
        }
        SystemClassPathManager.registerKeyType(datedFiles);
        SystemClassPathManager.registerKeyType(notDatedFiles);
        datedFiles.clear();
        datedFiles = null;
        notDatedFiles.clear();
        notDatedFiles = null;
        jarList.clear();
        jarList = null;
    }

    private static void registerKeyType(List<File> files) {
        for (File file : files) {
            try {
                Class[] classes = ClassFinder.getAllClasses(file.getAbsolutePath());
                for (int j = 0; j < classes.length; ++j) {
                    Class cls = classes[j];
                    if (!KeyType.class.isAssignableFrom(cls) || !cls.getSimpleName().matches(".*_v\\d++$")) continue;
                    try {
                        Method method = cls.getMethod("getKeyType", null);
                        KeyType keyType = (KeyType)method.invoke((Object)cls, (Object[])null);
                        KeyTypeManager.registerSingleKeyType(keyType);
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }
}

