/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.misc.util;

public class StringUtil {
    public static String getShortClassName(String className) {
        if (className == null) {
            return null;
        }
        String shortName = null;
        int index2 = className.lastIndexOf(46);
        shortName = index2 == -1 || index2 >= className.length() - 1 ? className : className.substring(index2 + 1);
        return shortName;
    }

    public static String getShortClassName(Object obj) {
        if (obj == null) {
            return null;
        }
        return StringUtil.getShortClassName(obj.getClass().getName());
    }

    public static String trimLeft(String str, char c) {
        int len = str.length();
        int index2 = 0;
        while (index2 < len && str.charAt(index2++) == c) {
        }
        if (--index2 < 0) {
            return "";
        }
        if (index2 < len) {
            return str.substring(index2);
        }
        return str;
    }

    public static String trimRight(String str, char c) {
        int len = str.length();
        int index2 = len - 1;
        while (index2 >= 0 && str.charAt(index2--) == c) {
        }
        if (++index2 > len - 1) {
            return str;
        }
        if (index2 >= 0) {
            return str.substring(0, index2 + 1);
        }
        return "";
    }

    public static String trim(String str, char c) {
        return StringUtil.trimRight(StringUtil.trimLeft(str, c), c);
    }

    public static String replace(String str, String oldValue, String newValue) {
        if (str == null || oldValue == null || newValue == null) {
            return null;
        }
        int index2 = str.indexOf(oldValue);
        if (index2 != -1) {
            int oldValueLen = oldValue.length();
            int newValueLen = newValue.length();
            String tail = str;
            StringBuffer buffer = new StringBuffer(str.length() + newValueLen);
            do {
                String head = tail.substring(0, index2);
                buffer.append(head);
                buffer.append(newValue);
            } while ((index2 = (tail = tail.substring(index2 + oldValueLen)).indexOf(oldValue)) != -1);
            buffer.append(tail);
            str = buffer.toString();
        }
        return str;
    }

    public static String getLeftPaddedString(String value2, int maxSize, char pad) {
        int diff = maxSize - value2.length();
        StringBuffer buffer = new StringBuffer(maxSize);
        for (int i = 0; i < diff; ++i) {
            buffer.append(pad);
        }
        buffer.append(value2);
        return buffer.toString();
    }

    public static String getRightPaddedString(String value2, int maxSize, char pad) {
        int diff = maxSize - value2.length();
        StringBuffer buffer = new StringBuffer(maxSize);
        buffer.append(value2);
        for (int i = 0; i < diff; ++i) {
            buffer.append(pad);
        }
        return buffer.toString();
    }
}

