/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.misc.util;

import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.QueueDispatcherListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class QueueDispatcherThread
extends Thread {
    private List list = Collections.synchronizedList(new LinkedList());
    private QueueDispatcherListener queueDispatcherListener;
    private boolean shouldRun = true;

    public QueueDispatcherThread() {
        this.setDaemon(true);
    }

    public synchronized void enqueue(Object obj) {
        this.list.add(obj);
        this.notify();
    }

    public synchronized Object dequeue() throws InterruptedException {
        while (this.list.size() == 0) {
            this.wait(1000L);
        }
        return this.list.remove(0);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    public void setQueueDispatcherListener(QueueDispatcherListener listener) {
        this.queueDispatcherListener = listener;
    }

    public QueueDispatcherListener getQueueDispatcherListener() {
        return this.queueDispatcherListener;
    }

    @Override
    public synchronized void run() {
        while (this.shouldRun) {
            try {
                while (this.list.size() == 0 && this.shouldRun) {
                    this.wait(1000L);
                }
                int size2 = this.list.size();
                if (size2 <= 0) continue;
                for (int i = 0; i < size2; ++i) {
                    Object obj = this.list.remove(0);
                    if (this.queueDispatcherListener == null) continue;
                    this.queueDispatcherListener.objectDispatched(obj);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void terminate() {
        this.shouldRun = false;
    }
}

