/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.function.command;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.tools.gfsh.app.ServerExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.TreeMap;

public class which
implements ServerExecutable {
    private byte code = 0;
    private String codeMessage = null;
    static String major;
    static String minor;
    static String update;
    static String build;

    private static void determineGemFireVersion() {
        String gemfireVersion = GemFireVersion.getGemFireVersion();
        String[] split = gemfireVersion.split("\\.");
        block6: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    major = split[i];
                    continue block6;
                }
                case 1: {
                    minor = split[i];
                    continue block6;
                }
                case 2: {
                    update = split[i];
                    continue block6;
                }
                case 3: {
                    build = split[i];
                }
            }
        }
    }

    @Override
    public Object execute(String command, String regionPath, Object arg) throws Exception {
        GfshData data = new GfshData(null);
        Cache cache = CacheFactory.getAnyInstance();
        Object[] args = (Object[])arg;
        if (args.length < 0) {
            this.code = (byte)-1;
            this.codeMessage = "Key not specified";
            return data;
        }
        Object key2 = args[0];
        boolean recursive = false;
        if (args.length > 1) {
            recursive = (Boolean)args[1];
        }
        try {
            TreeMap map = new TreeMap();
            if (!recursive) {
                Object value2;
                if (regionPath == null || regionPath.equals("/")) {
                    this.code = (byte)-1;
                    this.codeMessage = "Invalid region path " + regionPath;
                    return data;
                }
                Region region = cache.getRegion(regionPath);
                if (region == null) {
                    this.code = (byte)-1;
                    this.codeMessage = "Undefined region " + regionPath;
                    return data;
                }
                DistributedMember primaryMember = null;
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr2 = (PartitionedRegion)region;
                    Region localRegion = PartitionRegionHelper.getLocalData((PartitionedRegion)region);
                    value2 = localRegion.get(key2);
                    primaryMember = PartitionRegionHelper.getPrimaryMemberForKey(region, key2);
                    int bucketId = pr2.getKeyInfo(key2).getBucketId();
                    DistributedMember member = cache.getDistributedSystem().getDistributedMember();
                    boolean isPrimary = member == primaryMember;
                    HashMap<String, Constable> prInfoMap = new HashMap<String, Constable>();
                    prInfoMap.put("BucketId", Integer.valueOf(bucketId));
                    prInfoMap.put("IsPrimary", Boolean.valueOf(isPrimary));
                    data.setUserData(prInfoMap);
                } else {
                    value2 = region.get(key2);
                }
                if (value2 != null) {
                    map.put(regionPath, value2);
                }
            } else {
                String[] regionPaths = RegionUtil.getAllRegionPaths(cache, true);
                for (int i = 0; i < regionPaths.length; ++i) {
                    if (!regionPaths[i].startsWith(regionPath)) continue;
                    Object value3 = null;
                    Region region = cache.getRegion(regionPaths[i]);
                    if (region instanceof PartitionedRegion) {
                        PartitionedRegion pr3 = (PartitionedRegion)region;
                        Region localRegion = PartitionRegionHelper.getLocalData(pr3);
                        value3 = localRegion.get(key2);
                    } else {
                        value3 = region.get(key2);
                    }
                    if (value3 == null) continue;
                    map.put(regionPaths[i], value3);
                }
            }
            data.setDataObject(map);
        }
        catch (Exception ex) {
            this.code = (byte)-1;
            this.codeMessage = ex.getMessage();
        }
        return data;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getCodeMessage() {
        return this.codeMessage;
    }

    static {
        which.determineGemFireVersion();
    }
}

