/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.function.command;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.tools.gfsh.app.ServerExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.MapMessage;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;

public class pr
implements ServerExecutable {
    private byte code = 0;
    private String codeMessage = null;

    @Override
    public Object execute(String command, String regionPath, Object arg) throws Exception {
        Cache cache = CacheFactory.getAnyInstance();
        Object[] args = (Object[])arg;
        GfshData data = new GfshData(null);
        try {
            if (regionPath == null || regionPath.equals("/")) {
                this.code = (byte)-1;
                this.codeMessage = "Invalid region path " + regionPath;
                return data;
            }
            Region region = cache.getRegion(regionPath);
            if (region == null) {
                this.code = (byte)-1;
                this.codeMessage = "Undefined region " + regionPath;
                return data;
            }
            if (!(region instanceof PartitionedRegion)) {
                this.code = (byte)-1;
                this.codeMessage = "Not a partitioned region: " + regionPath;
                return data;
            }
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            PartitionedRegion pr2 = (PartitionedRegion)region;
            if (pr2.getDataStore() == null) {
                this.code = 0;
                this.codeMessage = "No data store: " + regionPath;
                data.setUserData(pr2.getPartitionAttributes().getTotalNumBuckets());
                return data;
            }
            Set<BucketRegion> set2 = pr2.getDataStore().getAllLocalBucketRegions();
            ArrayList<MapMessage> primaryList = new ArrayList<MapMessage>();
            ArrayList<MapMessage> redundantList = new ArrayList<MapMessage>();
            for (BucketRegion br : set2) {
                MapMessage map = new MapMessage();
                map.put("BucketId", br.getId());
                map.put("Size", br.size());
                map.put("Bytes", br.getTotalBytes());
                InternalDistributedMember m = pr2.getBucketPrimary(br.getId());
                if (m.getId().equals(member.getId())) {
                    primaryList.add(map);
                    continue;
                }
                redundantList.add(map);
            }
            TreeMap<String, ArrayList<MapMessage>> map = new TreeMap<String, ArrayList<MapMessage>>();
            map.put("Primary", primaryList);
            map.put("Redundant", redundantList);
            data.setDataObject(map);
            data.setUserData(pr2.getPartitionAttributes().getTotalNumBuckets());
        }
        catch (Exception ex) {
            this.code = (byte)-1;
            this.codeMessage = ex.getMessage();
        }
        return data;
    }

    @Override
    public byte getCode() {
        return this.code;
    }

    @Override
    public String getCodeMessage() {
        return this.codeMessage;
    }
}

