/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import java.util.LinkedList;

public class zone
implements CommandExecutable {
    private Gfsh gfsh;

    public zone(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("zone [-?] <hours>");
        this.gfsh.println("     Set the zone difference. This value is added to all time-related data.");
        this.gfsh.println("     For example, set this value to -3 if the data in the cache is");
        this.gfsh.println("     timestamped in EST and you are running this program in PST.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("zone -?")) {
            this.help();
        } else {
            this.zone(command);
        }
    }

    private void zone(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 2) {
            this.gfsh.println("zone = " + this.gfsh.getZoneDifference() / 3600000L);
            this.gfsh.println("   Use zone <hours> to change the zone hour difference");
        } else {
            int hours = Integer.parseInt((String)list.get(1));
            this.gfsh.setZoneDifference((long)(hours * 60 * 60) * 1000L);
        }
    }
}

