/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class which
implements CommandExecutable {
    private Gfsh gfsh;

    public which(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("which [-p <region path>] [-r] <query predicate> | -k <number> | [-?]");
        this.gfsh.println("     Show the members and regions that have the specified key.");
        this.gfsh.println("     -p <region path> The region path in which to find the specified key.");
        this.gfsh.println("     -r Search recursively. It search all of the subregions including");
        this.gfsh.println("        the specified region or the current region if not specified.");
        this.gfsh.println("     -k <number>   Use an enumerated key. Use 'ls -k' to get the list");
        this.gfsh.println("            of enumerated keys. Only one key number is supported.");
        this.gfsh.println("     <query predicate>: field=val1 and field2='val1' \\");
        this.gfsh.println("                        and field3=to_date('<date>', '<format>'");
        this.gfsh.println("     Data formats: primitives, String, and java.util.Date");
        this.gfsh.println("         <decimal>b|B - Byte      (e.g., 1b)");
        this.gfsh.println("         <decimal>c|C - Character (e.g., 1c)");
        this.gfsh.println("         <decimal>s|S - Short     (e.g., 12s)");
        this.gfsh.println("         <decimal>i|I - Integer   (e.g., 15 or 15i)");
        this.gfsh.println("         <decimal>l|L - Long      (e.g., 20l");
        this.gfsh.println("         <decimal>f|F - Float     (e.g., 15.5 or 15.5f)");
        this.gfsh.println("         <decimal>d|D - Double    (e.g., 20.0d)");
        this.gfsh.println("         '<string with \\ delimiter>' (e.g., '\\'Wow!\\'!' Hello, world')");
        this.gfsh.println("         to_date('<date string>', '<simple date format>'");
        this.gfsh.println("                       (e.g., to_date('04/10/2009', 'MM/dd/yyyy')");
        this.gfsh.println("Examples: ");
        this.gfsh.println("      which 'string'  -- string key");
        this.gfsh.println("      which 10f  -- float key");
        this.gfsh.println("      which -k 1");
        this.gfsh.println("      which -p /foo/yong -r x=10.0 and y=1 and date=to_date('04/10/2009', 'MM/dd/yyyy')");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("which -?")) {
            this.help();
        } else {
            this.which(command);
        }
    }

    private Object getKeyFromInput(List list, int index2) throws Exception {
        String input = (String)list.get(index2);
        Object key2 = null;
        if (input.startsWith("'")) {
            int lastIndex = -1;
            lastIndex = !input.endsWith("'") ? input.length() : input.lastIndexOf("'");
            if (lastIndex <= 1) {
                this.gfsh.println("Error: Invalid key. Empty string not allowed.");
                return null;
            }
            key2 = input.substring(1, lastIndex);
        } else {
            key2 = this.gfsh.getQueryKey(list, index2);
        }
        return key2;
    }

    private void which(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 2) {
            this.gfsh.println("Error: 'which' requires a query predicate or key number");
            return;
        }
        String regionPath = this.gfsh.getCurrentPath();
        boolean recursive = false;
        Object key2 = null;
        for (int i = 1; i < list.size(); ++i) {
            String token = (String)list.get(i);
            if (token.equals("-p")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-p' requires region path");
                    return;
                }
                regionPath = (String)list.get(++i);
                continue;
            }
            if (token.equals("-r")) {
                recursive = true;
                continue;
            }
            if (token.equals("-k")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-k' requires key number");
                    return;
                }
                int keyNum = Integer.parseInt((String)list.get(++i));
                key2 = this.gfsh.getKeyFromKeyList(keyNum);
                break;
            }
            int inputIndex = i;
            key2 = this.getKeyFromInput(list, inputIndex);
            break;
        }
        if (key2 == null) {
            this.gfsh.println("Error: Key is not defined.");
            return;
        }
        this.executeWhich(regionPath, key2, recursive);
    }

    private void executeWhich(String regionPath, Object key2, boolean recursive) throws Exception {
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        Aggregator aggregator = this.gfsh.getAggregator();
        long startTime = System.currentTimeMillis();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("which", fullPath, new Object[]{key2, recursive}), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        int i = 0;
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            if (aggregateResults.getCode() == -1) {
                this.gfsh.println("Error: " + aggregateResults.getCodeMessage());
                if (!this.gfsh.isDebug() || aggregateResults.getException() == null) break;
                aggregateResults.getException().printStackTrace();
                break;
            }
            Object value2 = data.getDataObject();
            if (value2 == null) continue;
            MemberInfo memberInfo = data.getMemberInfo();
            Map map = (Map)value2;
            Set entrySet = map.entrySet();
            if (map == null || map.size() <= 0) continue;
            this.gfsh.print(++i + ". " + memberInfo.getMemberName() + " (" + memberInfo.getMemberId() + ")");
            Object obj = data.getUserData();
            if (obj != null) {
                if (obj instanceof Map) {
                    Map infoMap = (Map)obj;
                    boolean isPrimary = (Boolean)infoMap.get("IsPrimary");
                    int bucketId = (Integer)infoMap.get("BucketId");
                    if (isPrimary) {
                        this.gfsh.println(" -- BucketId=" + bucketId + " *Primary PR*");
                    } else {
                        this.gfsh.println(" -- BucketId=" + bucketId);
                    }
                }
            } else {
                this.gfsh.println();
            }
            PrintUtil.printEntries(map, map.size(), null, "Region", "Value", false, this.gfsh.isShowResults());
            this.gfsh.println();
        }
        if (i == 0) {
            this.gfsh.println("Key is not found.");
        }
        this.gfsh.println();
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }
}

