/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.Nextable;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.commands.next;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import java.util.LinkedList;
import java.util.List;

public class select
implements CommandExecutable,
Nextable {
    private static final int DEFAULT_LIMIT = 1000;
    private static final int MAX_LIMIT = 5000;
    private Gfsh gfsh;
    private int limit = 1000;

    public select(Gfsh gfsh) {
        this.gfsh = gfsh;
        gfsh.setSelectLimit(this.limit);
    }

    @Override
    public void help() {
        this.gfsh.println("select [-l <limit>|-show] | -?");
        this.gfsh.println("select <tuples where ...> | -?");
        this.gfsh.println("     Execute the specified query in the remote cache.");
        this.gfsh.println("     -l set the result set size limit, i.e.,");
        this.gfsh.println("        'select ... from ... limit <limit>'. Note that gfsh automatically");
        this.gfsh.println("        appends 'limit' to your select statement. Do not add your own limit.");
        this.gfsh.println("        The default limit is 1000. The allowed max limit is 5000.");
        this.gfsh.println("     -show Displays the select limit value.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String queryString = command;
        if (list.contains("-?")) {
            this.help();
        } else {
            for (int i = 1; i < list.size(); ++i) {
                String token = (String)list.get(i);
                if (token.equals("-l")) {
                    int val;
                    if (i + 1 >= list.size()) {
                        this.gfsh.println("Error: '-l' requires limit value");
                        return;
                    }
                    this.limit = (val = Integer.parseInt((String)list.get(++i))) > 5000 ? 5000 : (val < 0 ? 0 : val);
                    this.gfsh.setSelectLimit(this.limit);
                    return;
                }
                if (!token.equals("-show")) continue;
                this.select_show();
                return;
            }
            queryString = queryString + " limit " + this.limit;
            this.select(queryString, true);
        }
    }

    public List getRemoteKeys(String regionPath) throws Exception {
        List list = this.select("select * from " + regionPath + ".keySet limit " + this.limit, true);
        return list;
    }

    public void select_show() {
        this.gfsh.println("select limit = " + this.limit);
    }

    public List select(String queryString, boolean nextEnabled) throws Exception {
        long startTime = System.currentTimeMillis();
        CommandResults cr = this.gfsh.getCommandClient().execute(new QueryTask(queryString, this.gfsh.getFetchSize(), nextEnabled));
        long stopTime = System.currentTimeMillis();
        if (cr.getCode() == 1) {
            this.gfsh.println(cr.getCodeMessage());
            return null;
        }
        QueryResults results = (QueryResults)cr.getDataObject();
        if (results == null) {
            this.gfsh.println("No results");
            return null;
        }
        List list = null;
        Object obj = results.getResults();
        if (obj instanceof SelectResults) {
            SelectResults sr = (SelectResults)results.getResults();
            list = sr.asList();
            int startRowNum = results.getReturnedSize() - sr.size() + 1;
            if (this.gfsh.isShowResults()) {
                int rowsPrinted = PrintUtil.printSelectResults(sr, 0, startRowNum, sr.size());
                this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize() + ", Limit: " + this.limit);
                this.gfsh.println("   Results: " + sr.size() + ", Returned: " + results.getReturnedSize() + "/" + results.getActualSize());
                next n = (next)this.gfsh.getCommand("next");
                n.setCommand(this.getClass().getSimpleName());
            } else {
                this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize() + ", Limit: " + this.limit);
                this.gfsh.println("   Results: " + sr.size() + ", Returned: " + results.getReturnedSize() + "/" + results.getActualSize());
            }
        } else {
            this.gfsh.println("Results: " + obj);
        }
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
        return list;
    }

    @Override
    public List next(Object userData) throws Exception {
        this.select(null, true);
        return null;
    }
}

