/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.functions.util.RegionDestroyFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandClient;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RegionDestroyTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.util.LinkedList;
import java.util.List;

public class rmdir
implements CommandExecutable {
    private Gfsh gfsh;

    public rmdir(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("rmdir [-a|-g|-s] [-?] <region path>");
        this.gfsh.println("     Remove the local region if no options specified. The region path");
        this.gfsh.println("     can be absolute or relative.");
        this.gfsh.println("     -a Remove both the local region and the server region.");
        this.gfsh.println("        The region destroy will be distributed to other caches if the");
        this.gfsh.println("        scope is not Scope.LOCAL.");
        this.gfsh.println("     -g Remove globally. Remove the local region and all server");
        this.gfsh.println("        regions regardless of scope. This option also removes server");
        this.gfsh.println("        regions with Scope.LOCAL.");
        this.gfsh.println("     -s Remove only the server region. The local region is not destroyed.");
        this.gfsh.println("        The region destroy will be distributed to other caches if the");
        this.gfsh.println("        scope is not Scope.LOCAL.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("rmdir -?")) {
            this.help();
        } else if (command.startsWith("rmdir -a")) {
            this.rmdir_a(command);
        } else if (command.startsWith("rmdir -g")) {
            this.rmdir_g(command);
        } else if (command.startsWith("rmdir -s")) {
            this.rmdir_s(command);
        } else {
            this.rmdir_local(command);
        }
    }

    private void rmdir(String command) throws Exception {
        int index2 = command.indexOf(" ");
        if (index2 == -1) {
            this.gfsh.println("Error: rmdir requires a region path to remove");
        } else {
            Cache cache = this.gfsh.getCache();
            String newPath = command.substring(index2).trim();
            String fullPath = this.gfsh.getFullPath(newPath, this.gfsh.getCurrentPath());
            if (fullPath == null) {
                this.gfsh.println("Error: region path must be provided. mkdir <regionPath>");
            } else {
                Region region = cache.getRegion(fullPath);
                if (region == null) {
                    this.gfsh.println("Error: region does not exist - " + fullPath);
                    return;
                }
                region.close();
                this.gfsh.println("Region removed: " + fullPath);
            }
        }
    }

    private void rmdir_local(String command) {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        if (list.size() <= 1) {
            this.gfsh.println("Error: must specify a region path to remove");
            return;
        }
        regionPath = (String)list.get(1);
        this.remove_local(regionPath);
    }

    private void rmdir_a(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        if (list.size() <= 2) {
            this.gfsh.println("Error: must specify a region path to remove");
            return;
        }
        regionPath = (String)list.get(2);
        this.remove_server(regionPath, false);
        this.remove_local(regionPath);
    }

    private void rmdir_g(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        if (list.size() <= 2) {
            this.gfsh.println("Error: must specify a region path to remove");
            return;
        }
        regionPath = (String)list.get(2);
        this.remove_server(regionPath, true);
        this.remove_local(regionPath);
    }

    private void rmdir_s(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = null;
        if (list.size() <= 2) {
            this.gfsh.println("Error: must specify a region path to remove");
            return;
        }
        regionPath = (String)list.get(2);
        this.remove_server(regionPath, false);
    }

    private void remove_local(String regionPath) {
        if (regionPath == null) {
            return;
        }
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        if (fullPath == null) {
            this.gfsh.println("Error: invalid region path");
        } else if (fullPath.equals("/")) {
            this.gfsh.println("Error: cannot remove top level");
        } else {
            Region<Object, Object> region = this.gfsh.getCache().getRegion(fullPath);
            if (region == null) {
                this.gfsh.println("Error: undefined region path " + fullPath);
                return;
            }
            region.close();
            String[] currentSplit = currentPath.split("/");
            Cache cache = this.gfsh.getCache();
            Region currentRegion = null;
            if (currentSplit.length > 1) {
                region = cache.getRegion(currentSplit[1]);
                currentRegion = region;
                if (region != null) {
                    for (int i = 2; i < currentSplit.length && (region = region.getSubregion(currentSplit[i])) != null; ++i) {
                        currentRegion = region;
                    }
                }
            }
            if (currentRegion == null) {
                this.gfsh.setCurrentPath("/");
            } else {
                this.gfsh.setCurrentPath(currentRegion.getFullPath());
            }
            this.gfsh.setCurrentRegion(currentRegion);
            this.gfsh.println("Region removed from local VM: " + regionPath);
        }
    }

    private void remove_server(String regionPath, boolean global) throws Exception {
        if (regionPath == null) {
            return;
        }
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        if (fullPath == null) {
            this.gfsh.println("Error: invalid region path");
        } else if (fullPath.equals("/")) {
            this.gfsh.println("Error: cannot remove top level");
        } else {
            String confirmation = this.gfsh.getLine("This command will remove the region " + fullPath + " from the server(s). \nDo you want to proceed? (yes|no): ");
            if (!confirmation.equalsIgnoreCase("yes")) {
                this.gfsh.println("Command aborted.");
                return;
            }
            if (global) {
                Aggregator aggregator = this.gfsh.getAggregator();
                List aggregateList = (List)aggregator.aggregate(new RegionDestroyFunction(fullPath), this.gfsh.getAggregateRegionPath());
                int i = 1;
                for (CommandResults commandResults : aggregateList) {
                    MemberInfo memberInfo = (MemberInfo)commandResults.getDataObject();
                    this.gfsh.print(i + ". " + memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
                    if (commandResults.getCode() == 1) {
                        this.gfsh.println("error - " + commandResults.getCodeMessage());
                    } else {
                        Region region = RegionUtil.getRegion(fullPath, Scope.LOCAL, DataPolicy.NORMAL, null);
                        this.gfsh.println("region removed: " + region.getFullPath());
                    }
                    ++i;
                }
            } else {
                CommandClient commandClient = this.gfsh.getCommandClient();
                CommandResults commandResults = commandClient.execute(new RegionDestroyTask(fullPath));
                MemberInfo memberInfo = (MemberInfo)commandResults.getDataObject();
                this.gfsh.print(memberInfo.getMemberName() + "(" + memberInfo.getMemberId() + ")" + ": ");
                if (commandResults.getCode() == 1) {
                    this.gfsh.println("error - " + commandResults.getCodeMessage());
                } else {
                    Region region = RegionUtil.getRegion(regionPath, Scope.LOCAL, DataPolicy.NORMAL, null);
                    this.gfsh.println("region removed: " + region.getFullPath());
                }
            }
        }
    }
}

