/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.ObjectUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class rm
implements CommandExecutable {
    private Gfsh gfsh;

    public rm(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("rm [-a|-g] [-k] <key>|<enum list>");
        this.gfsh.println("     Remove keys locally and/or remotely. If no options are specified,");
        this.gfsh.println("     it removes <key> from the local region only.");
        this.gfsh.println("     -a Remove keys from both the local region and the server");
        this.gfsh.println("        region. This command will be distributed to other caches if");
        this.gfsh.println("        scope is not Scope.LOCAL.");
        this.gfsh.println("     -g Remove keys globally. Remote from the local region and all");
        this.gfsh.println("        server regions regardless of scope. This option also removes");
        this.gfsh.println("        keys from server regions with Scope.LOCAL.");
        this.gfsh.println("     -k Remove enumerated keys. If this option is not specified, then");
        this.gfsh.println("        <key> is expected.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("rm -?")) {
            this.help();
        } else {
            this.rm(command);
        }
    }

    private void rm(String command) throws Exception {
        block25: {
            Region region;
            int keyIndex;
            boolean enumerated;
            LinkedList list;
            block26: {
                block27: {
                    boolean removeAll;
                    block24: {
                        list = new LinkedList();
                        Gfsh.parseCommand(command, list);
                        String regionPath = null;
                        if (list.size() <= 1) {
                            this.gfsh.println("Error: must specify a region path to remove");
                            return;
                        }
                        regionPath = (String)list.get(1);
                        enumerated = false;
                        removeAll = false;
                        boolean removeServer = false;
                        keyIndex = 0;
                        for (int i = 1; i < list.size(); ++i) {
                            String val = (String)list.get(i);
                            if (val.equals("-a")) {
                                removeServer = true;
                                continue;
                            }
                            if (val.equals("-g")) {
                                removeAll = true;
                                continue;
                            }
                            if (val.equals("-k")) {
                                enumerated = true;
                                continue;
                            }
                            keyIndex = i;
                            break;
                        }
                        region = this.gfsh.getCurrentRegion();
                        if (!removeServer) break block24;
                        if (enumerated) {
                            Map keyMap = this.gfsh.getKeyMap(list, keyIndex);
                            Object[] keys = keyMap.values().toArray();
                            for (Object k : keyMap.values()) {
                                region.remove(k);
                                this.gfsh.println("removed server: " + ObjectUtil.getPrintableObject(k));
                            }
                        } else {
                            Object key2 = this.gfsh.getQueryKey(list, keyIndex);
                            region.remove(key2);
                            this.gfsh.println("removed server: " + ObjectUtil.getPrintableObject(key2));
                        }
                        break block25;
                    }
                    if (!removeAll) break block26;
                    if (!enumerated) break block27;
                    Map keyMap = this.gfsh.getKeyMap(list, keyIndex);
                    Object[] keys = keyMap.values().toArray();
                    boolean serverError = false;
                    List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction(command, this.gfsh.getCurrentPath(), keys), this.gfsh.getAggregateRegionPath());
                    for (Object k : keyMap.values()) {
                        try {
                            region.localDestroy(k);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        this.gfsh.println("removed all: " + ObjectUtil.getPrintableObject(k));
                    }
                    for (AggregateResults aggregateResults : results) {
                        if (aggregateResults.getCode() != -1) continue;
                        this.gfsh.println("Error from server: " + aggregateResults.getCodeMessage());
                    }
                    if (!serverError) break block25;
                    this.gfsh.println("Error: One or more keys may have not been removed from the server(s)");
                    break block25;
                }
                Object key3 = this.gfsh.getQueryKey(list, keyIndex);
                List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction(command, this.gfsh.getCurrentPath(), new Object[]{key3}), this.gfsh.getAggregateRegionPath());
                try {
                    region.localDestroy(key3);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                boolean serverError = false;
                for (AggregateResults aggregateResults : results) {
                    if (aggregateResults.getCode() != -1) continue;
                    this.gfsh.println("Error from server: " + aggregateResults.getCodeMessage());
                    serverError = true;
                }
                if (serverError) {
                    this.gfsh.println("Error: One or more keys may have not been removed from the server(s)");
                } else {
                    this.gfsh.println("removed: " + ObjectUtil.getPrintableObject(key3));
                }
                break block25;
            }
            if (enumerated) {
                Map keyMap = this.gfsh.getKeyMap(list, keyIndex);
                for (Object k : keyMap.values()) {
                    try {
                        region.localDestroy(k);
                        this.gfsh.println("removed local: " + ObjectUtil.getPrintableObject(k));
                    }
                    catch (EntryNotFoundException ex) {
                        this.gfsh.println("local (not found): " + ObjectUtil.getPrintableObject(k));
                    }
                }
            } else {
                Object key4 = this.gfsh.getQueryKey(list, keyIndex);
                try {
                    region.localDestroy(key4);
                    this.gfsh.println("removed local: " + ObjectUtil.getPrintableObject(key4));
                }
                catch (EntryNotFoundException ex) {
                    this.gfsh.println("local (not found): " + ObjectUtil.getPrintableObject(key4));
                }
            }
        }
    }
}

