/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RegionPathTask;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class refresh
implements CommandExecutable {
    private Gfsh gfsh;

    public refresh(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("refresh [-?]");
        this.gfsh.println("     Refresh the entire local cache. It fetches region");
        this.gfsh.println("     information from all servers and updates local regions.");
        this.gfsh.println("     It creates new regions found in the servers in the local VM.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("refresh -?")) {
            this.help();
        } else {
            this.refresh();
        }
    }

    @SuppressFBWarnings(value={"NM_METHOD_CONSTRUCTOR_CONFUSION"}, justification="This is method and not constructor")
    private void refresh() {
        CommandResults results;
        String[] regionPaths;
        if (!this.gfsh.isConnected()) {
            this.gfsh.println("Error: gfsh is not connected to a server. Use the 'connect' command to connect first. aborting refresh");
        }
        if ((regionPaths = (String[])(results = this.gfsh.getCommandClient().execute(new RegionPathTask(false, true))).getDataObject()) != null) {
            for (int i = 0; i < regionPaths.length; ++i) {
                Region region = this.gfsh.isLocator() ? RegionUtil.getRegion(regionPaths[i], Scope.LOCAL, DataPolicy.NORMAL, this.gfsh.getPool(), false) : RegionUtil.getRegion(regionPaths[i], Scope.LOCAL, DataPolicy.NORMAL, this.gfsh.getEndpoints());
            }
            this.gfsh.println("refreshed");
        }
        this.gfsh.refreshAggregatorRegion();
    }
}

