/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class rebalance
implements CommandExecutable {
    private Gfsh gfsh;

    public rebalance(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("rebalance -m <member id> [-s|-r] [-t <timeout in msec>] | [-?]");
        this.gfsh.println("     Rebalance partition regions held by the specified member.");
        this.gfsh.println("     By default, gfsh immediately returns after the rebalance command");
        this.gfsh.println("     execution. To determine the completion of rebalancing, excute");
        this.gfsh.println("     'size -m' or 'pr -b'. To wait for the rebalancing to complete,");
        this.gfsh.println("     supply the '-t' option with the timeout interval in msec.");
        this.gfsh.println("     -m <member id>  Execute the rebalance command on the specified member.");
        this.gfsh.println("           The member Ids can be obtained by executing 'size -m' or 'ls -m'.");
        this.gfsh.println("     -s Simulate rebalancing. Actual rebalancing is NOT performed.");
        this.gfsh.println("     -r Rebalance. Actual rebalancing is performed.");
        this.gfsh.println("     -t <timeout in msec> Timeout rebalbancing after the specified");
        this.gfsh.println("          time interval. Rebalancing will continue but gfsh will");
        this.gfsh.println("          timeout upon reaching the specified time interval. This option");
        this.gfsh.println("          must be used with the '-r' option. It has no effect with other");
        this.gfsh.println("          options.");
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("rebalance -?")) {
            this.help();
        } else {
            this.rebalance(command);
        }
    }

    private Object getKeyFromInput(List list, int index2) throws Exception {
        String input = (String)list.get(index2);
        Object key2 = null;
        if (input.startsWith("'")) {
            int lastIndex = -1;
            lastIndex = !input.endsWith("'") ? input.length() : input.lastIndexOf("'");
            if (lastIndex <= 1) {
                this.gfsh.println("Error: Invalid key. Empty string not allowed.");
                return null;
            }
            key2 = input.substring(1, lastIndex);
        } else {
            key2 = this.gfsh.getQueryKey(list, index2);
        }
        return key2;
    }

    private void rebalance(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 2) {
            this.gfsh.println("Error: 'rebalance' requries a key number or member id");
            return;
        }
        String regionPath = this.gfsh.getCurrentPath();
        boolean simulate = true;
        Object key2 = null;
        String memberId = null;
        long timeout = 0L;
        for (int i = 1; i < list.size(); ++i) {
            String token = (String)list.get(i);
            if (token.equals("-k")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-k' requires key number");
                    return;
                }
                int keyNum = Integer.parseInt((String)list.get(++i));
                key2 = this.gfsh.getKeyFromKeyList(keyNum);
                continue;
            }
            if (token.equals("-m")) {
                if (i + 1 >= list.size()) {
                    this.gfsh.println("Error: '-m' requires member Id");
                    return;
                }
                memberId = (String)list.get(++i);
                continue;
            }
            if (token.equals("-s")) {
                simulate = true;
                continue;
            }
            if (token.equals("-r")) {
                simulate = false;
                continue;
            }
            if (!token.equals("-t")) continue;
            if (i + 1 >= list.size()) {
                this.gfsh.println("Error: '-t' requires a timeout value");
                return;
            }
            timeout = Integer.parseInt((String)list.get(++i));
        }
        if (key2 == null && memberId == null) {
            this.gfsh.println("Error: member Id not defined.");
            return;
        }
        this.executeRebalance(regionPath, memberId, simulate, timeout);
    }

    private void executeRebalance(String regionPath, String memberId, boolean simulate, long timeout) throws Exception {
        String currentPath = this.gfsh.getCurrentPath();
        String fullPath = this.gfsh.getFullPath(regionPath, currentPath);
        Aggregator aggregator = this.gfsh.getAggregator();
        long startTime = System.currentTimeMillis();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("rebalance", regionPath, new Object[]{memberId, simulate, timeout}), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        int i = 0;
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            MemberInfo memberInfo = data.getMemberInfo();
            Object value2 = data.getDataObject();
            if (value2 != null) {
                String columnName = simulate ? "Simulated Stats" : "Rebalanced Stats";
                Map map = (Map)value2;
                Set entrySet = map.entrySet();
                if (map == null || map.size() <= 0) continue;
                this.gfsh.println(++i + ". " + memberInfo.getMemberName() + " (" + memberInfo.getMemberId() + ")");
                PrintUtil.printEntries(map, map.size(), null, columnName, "Value", false, this.gfsh.isShowResults());
                this.gfsh.println();
                continue;
            }
            if (!memberId.equals(memberInfo.getMemberId()) || simulate) continue;
            this.gfsh.println("Reblancing has been completed or is being performed by " + memberInfo.getMemberName() + " (" + memberInfo.getMemberId() + ")");
            this.gfsh.println("Use 'size -m' or 'pr -b' to view rebalance completion.");
            this.gfsh.println();
        }
        this.gfsh.println();
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }
}

