/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ReflectionUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.ObjectUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class put
implements CommandExecutable {
    private Gfsh gfsh;

    public put(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("put [-k] [-v] | [-?] (<key1>,<value1>)(<key2>,<value2>)...");
        this.gfsh.println("put (<key1>,<value1>)(<key2>,<value2>)...");
        this.gfsh.println("put -k (<key num1>,<value1>)(<key num2>,<value2>)...");
        this.gfsh.println("put -v (<key1>,<value num1>)(<key2>,<value num2>)...");
        this.gfsh.println("put -k -v (<key num1>,<value num1>)(<key num2>,<value num2>)...");
        this.gfsh.println("     Put entries in both local and remote regions.");
        this.gfsh.println("     All changes will be reflected in the server(s) also.");
        this.gfsh.println("     Keys are enumerated when one of the following commands");
        this.gfsh.println("     is executed: " + this.gfsh.getEnumCommands());
        this.gfsh.println();
        this.gfsh.println("     <key> and <value> support primitive, String, and java.util.Date");
        this.gfsh.println("     types. These types must be specifed with special tags as follows:");
        this.gfsh.println("         <decimal>b|B - Byte      (e.g., 1b)");
        this.gfsh.println("         <decimal>c|C - Character (e.g., 1c)");
        this.gfsh.println("         <decimal>s|S - Short     (e.g., 12s)");
        this.gfsh.println("         <decimal>i|I - Integer   (e.g., 15 or 15i)");
        this.gfsh.println("         <decimal>l|L - Long      (e.g., 20l)");
        this.gfsh.println("         <decimal>f|F - Float     (e.g., 15.5 or 15.5f)");
        this.gfsh.println("         <decimal>d|D - Double    (e.g., 20.0d)");
        this.gfsh.println("         '<string with \\ delimiter>' (e.g., '\\'Wow!\\'!' Hello, world')");
        this.gfsh.println("         to_date('<date string>', '<simple date format>')");
        this.gfsh.println("                       (e.g., to_date('04/10/2009', 'MM/dd/yyyy')");
        this.gfsh.println();
        this.gfsh.println("     If a suffix letter is not specifed then it is read as Integer");
        this.gfsh.println("     unless the decimal point or the letter 'e' or 'E' is specified,");
        this.gfsh.println("     in which case, it is read as Double. Note that if the <key> or");
        this.gfsh.println("     <value> class is used then a suffix letter is *not* required.");
        this.gfsh.println();
        this.gfsh.println("     <key> The key class defined by the 'key' command is used");
        this.gfsh.println("           to construct the key object.");
        this.gfsh.println("     <value> The value class defined by the 'value' command is used");
        this.gfsh.println("           to construct the value object.");
        this.gfsh.println("     The <key> and <value> objects are created using the following");
        this.gfsh.println("     format:");
        this.gfsh.println("         <property name1>=<property value1> and ");
        this.gfsh.println("         <property name2>=<property value2> and ...");
        this.gfsh.println();
        this.gfsh.println("     -k Put enumerated keys. If this option is not specified, then");
        this.gfsh.println("        <key> is expected.");
        this.gfsh.println("     -v Put enumerated values. If this option is not specified, then");
        this.gfsh.println("        <value> is expected.");
        this.gfsh.println();
        this.gfsh.println("     Examples:");
        this.gfsh.println("        put (15L, to_date('04/10/2009', 'MM/dd/yyyy')");
        this.gfsh.println("        put ('GEMSTONE', Price=125.50 and Date=to_date('04/09/2009',\\");
        this.gfsh.println("             'MM/dd/yyyy')");
        this.gfsh.println("        put -k -v (1, 5)  - puts the enum key 1 with the enum 5 value");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("put -?")) {
            this.help();
        } else {
            this.put(command);
        }
    }

    private void put(String command) throws Exception {
        Region region;
        LinkedList<String> list = new LinkedList<String>();
        Gfsh.parseCommand(command, list);
        boolean keyEnumerated = false;
        boolean valueEnumerated = false;
        int keyIndex = 0;
        for (int i = 1; i < list.size(); ++i) {
            String val = (String)list.get(i);
            if (val.equals("-k")) {
                keyEnumerated = true;
                continue;
            }
            if (val.equals("-v")) {
                valueEnumerated = true;
                continue;
            }
            keyIndex = i;
            break;
        }
        if ((region = this.gfsh.getCurrentRegion()) != null) {
            Map map = this.getEntryMap(list, keyEnumerated, valueEnumerated, keyIndex);
            region.putAll(map);
            PrintUtil.printEntries(region, map.keySet(), null);
        } else {
            this.gfsh.println("Error: Please 'cd' to the required region to perform put.");
        }
    }

    private int getEnclosingParenthesis(StringBuffer buffer, int startIndex) {
        int enclosedIndex = -1;
        int parenCount = 0;
        boolean inQuote = false;
        for (int i = startIndex; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == '(') {
                if (inQuote) continue;
                ++parenCount;
                continue;
            }
            if (c == ')') {
                if (!inQuote) {
                    --parenCount;
                }
                if (parenCount != 0) continue;
                enclosedIndex = i;
                break;
            }
            if (c != '\'') continue;
            inQuote = !inQuote;
        }
        return enclosedIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Map getEntryMap(List<String> list, boolean keyEnumerated, boolean valueEnumerated, int startIndex) throws Exception {
        String pairs = "";
        for (int i = startIndex; i < list.size(); ++i) {
            pairs = pairs + list.get(i) + " ";
        }
        Map keySetterMap = ReflectionUtil.getAllSettersMap(this.gfsh.getQueryKeyClass());
        Map valueSetterMap = ReflectionUtil.getAllSettersMap(this.gfsh.getValueClass());
        Region region = this.gfsh.getCurrentRegion();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        StringBuffer buffer = new StringBuffer(pairs);
        boolean keySearch = false;
        boolean fieldSearch = false;
        boolean openQuote = false;
        boolean delimiter = false;
        boolean quoted = false;
        boolean openParen = false;
        String fieldString = "";
        String valueString = "";
        String and = "";
        Object key2 = null;
        Object value2 = null;
        int i = 0;
        while (i < buffer.length()) {
            block52: {
                block58: {
                    int index2;
                    block59: {
                        char c;
                        block60: {
                            block47: {
                                block61: {
                                    block49: {
                                        block56: {
                                            block57: {
                                                block55: {
                                                    block54: {
                                                        block53: {
                                                            block48: {
                                                                block51: {
                                                                    block50: {
                                                                        c = buffer.charAt(i);
                                                                        if (c != '(') break block48;
                                                                        if (openQuote) break block49;
                                                                        String function = null;
                                                                        String functionCall = null;
                                                                        String functionString = null;
                                                                        if (valueString.length() > 0) {
                                                                            functionString = valueString;
                                                                        } else if (fieldString.length() > 0) {
                                                                            functionString = fieldString;
                                                                        }
                                                                        if (functionString != null) {
                                                                            int enclosedIndex = this.getEnclosingParenthesis(buffer, i);
                                                                            function = functionString.toLowerCase();
                                                                            if (enclosedIndex == -1) {
                                                                                throw new ParseException("Malformed function call: " + function, i);
                                                                            }
                                                                            functionCall = function + buffer.substring(i, enclosedIndex + 1);
                                                                            if (this.gfsh.isDebug()) {
                                                                                this.gfsh.println("functionCall = |" + functionCall + "|");
                                                                            }
                                                                            i = enclosedIndex;
                                                                        }
                                                                        if (functionCall == null) break block50;
                                                                        if (valueString.length() > 0) {
                                                                            valueString = functionCall;
                                                                            break block51;
                                                                        } else if (fieldString.length() > 0) {
                                                                            fieldString = functionCall;
                                                                        }
                                                                        break block51;
                                                                    }
                                                                    key2 = null;
                                                                    value2 = null;
                                                                    keySearch = true;
                                                                    fieldSearch = true;
                                                                    fieldString = "";
                                                                    valueString = "";
                                                                }
                                                                quoted = false;
                                                                break block52;
                                                            }
                                                            if (c != '=') break block53;
                                                            if (keySearch && key2 == null && !keyEnumerated) {
                                                                if (this.gfsh.getQueryKeyClass() == null) {
                                                                    throw new ClassNotFoundException("Undefined key class. Use the 'key' command to set the class name");
                                                                }
                                                                key2 = this.gfsh.getQueryKeyClass().newInstance();
                                                            }
                                                            if (!keySearch && value2 == null && !valueEnumerated) {
                                                                if (this.gfsh.getValueClass() == null) {
                                                                    throw new ClassNotFoundException("Undefined value class. Use the 'value' command to set the class name");
                                                                }
                                                                value2 = this.gfsh.getValueClass().newInstance();
                                                            }
                                                            fieldSearch = false;
                                                            break block52;
                                                        }
                                                        if (c != ')') break block54;
                                                        if (openQuote) break block49;
                                                        if (this.gfsh.isDebug()) {
                                                            this.gfsh.println("v: field = " + fieldString);
                                                            this.gfsh.println("v: value = " + valueString);
                                                            this.gfsh.println();
                                                        }
                                                        if (valueEnumerated) {
                                                            Object k = this.gfsh.getKeyFromKeyList(Integer.parseInt(fieldString));
                                                            if (k == null) {
                                                                this.gfsh.println("Error: value not found in the cache for the key number " + fieldString);
                                                                this.gfsh.println("       run 'key -l' to view the enumerated keys.");
                                                                map.clear();
                                                                return map;
                                                            }
                                                            value2 = region.get(k);
                                                            if (key2 == null) {
                                                                this.gfsh.println("Error: value not in the cache - " + fieldString);
                                                                map.clear();
                                                                return map;
                                                            }
                                                            if (this.gfsh.isDebug()) {
                                                                this.gfsh.println("k = " + k);
                                                                this.gfsh.println("key = " + key2);
                                                                this.gfsh.println("value = " + value2);
                                                            }
                                                        } else if (valueString.length() == 0) {
                                                            value2 = ObjectUtil.getPrimitive(this.gfsh, fieldString, quoted);
                                                        } else {
                                                            this.updateObject(valueSetterMap, value2, fieldString, valueString);
                                                        }
                                                        map.put(key2, value2);
                                                        fieldSearch = true;
                                                        quoted = false;
                                                        fieldString = "";
                                                        valueString = "";
                                                        key2 = null;
                                                        and = "";
                                                        break block52;
                                                    }
                                                    if (c != '\\') break block55;
                                                    delimiter = true;
                                                    break block52;
                                                }
                                                if (c != '\'') break block56;
                                                if (!delimiter) break block57;
                                                delimiter = false;
                                                break block49;
                                            }
                                            if (openQuote) {
                                                quoted = true;
                                            }
                                            openQuote = !openQuote;
                                            break block52;
                                        }
                                        if (c != ' ' || openQuote) break block49;
                                        boolean andExpected = false;
                                        if (keySearch) {
                                            if (this.gfsh.isDebug()) {
                                                this.gfsh.println("k: field = " + fieldString);
                                                this.gfsh.println("k: value = " + valueString);
                                                this.gfsh.println();
                                            }
                                            if (fieldString.length() > 0) {
                                                this.updateObject(keySetterMap, key2, fieldString, valueString);
                                                andExpected = true;
                                            }
                                        } else {
                                            if (this.gfsh.isDebug()) {
                                                this.gfsh.println("v: field = " + fieldString);
                                                this.gfsh.println("v: value = " + valueString);
                                                this.gfsh.println();
                                            }
                                            if (fieldString.length() > 0) {
                                                this.updateObject(valueSetterMap, value2, fieldString, valueString);
                                                andExpected = true;
                                            }
                                        }
                                        if (!andExpected) break block58;
                                        and = "";
                                        index2 = -1;
                                        break block59;
                                    }
                                    if (c != ',' || openQuote) break block60;
                                    fieldString = fieldString.trim();
                                    valueString = valueString.trim();
                                    if (this.gfsh.isDebug()) {
                                        this.gfsh.println("k: field = " + fieldString);
                                        this.gfsh.println("k: value = " + valueString);
                                        this.gfsh.println();
                                    }
                                    if (!keySearch) break block61;
                                    if (keyEnumerated) {
                                        key2 = this.gfsh.getKeyFromKeyList(Integer.parseInt(fieldString));
                                        if (key2 == null) {
                                            this.gfsh.println("Error: value not found in the cache for the key number " + fieldString);
                                            this.gfsh.println("       run 'key -l' to view the enumerated keys.");
                                            map.clear();
                                            return map;
                                        }
                                        break block47;
                                    } else if (valueString.length() == 0) {
                                        key2 = ObjectUtil.getPrimitive(this.gfsh, fieldString, quoted);
                                        break block47;
                                    } else {
                                        this.updateObject(keySetterMap, key2, fieldString, valueString);
                                    }
                                    break block47;
                                }
                                if (valueEnumerated) {
                                    Object k = this.gfsh.getKeyFromKeyList(Integer.parseInt(fieldString));
                                    value2 = region.get(k);
                                    if (value2 == null) {
                                        this.gfsh.println("Error: undefined value num " + fieldString);
                                        map.clear();
                                        return map;
                                    }
                                } else if (valueString.length() == 0) {
                                    value2 = ObjectUtil.getPrimitive(this.gfsh, fieldString, quoted);
                                } else {
                                    this.updateObject(valueSetterMap, value2, fieldString, valueString);
                                }
                            }
                            fieldSearch = true;
                            keySearch = false;
                            quoted = false;
                            fieldString = "";
                            valueString = "";
                            and = "";
                            break block52;
                        }
                        if (fieldSearch) {
                            fieldString = fieldString + c;
                            break block52;
                        } else if (!quoted) {
                            valueString = valueString + c;
                        }
                        break block52;
                    }
                    for (int j = i; j < buffer.length(); ++j) {
                        and = and + buffer.charAt(j);
                        if ((and = and.trim().toLowerCase()).equals("and")) {
                            index2 = j;
                            break;
                        }
                        if (and.length() > 3) break;
                    }
                    if (index2 != -1) {
                        i = index2;
                    }
                }
                fieldSearch = true;
                fieldString = "";
                valueString = "";
                and = "";
                quoted = false;
            }
            ++i;
        }
        return map;
    }

    private Object getFunctionValue(String functionCall) throws ParseException {
        if (functionCall.startsWith("to_date")) {
            return this.gfsh.getDate(functionCall);
        }
        return null;
    }

    private void updateObject(Map<String, Method> setterMap, Object obj, String field, String value2) throws Exception {
        String setterMethodName = "set" + field.trim();
        Method setterMethod = setterMap.get(setterMethodName);
        if (setterMethod == null) {
            return;
        }
        Class<?>[] types = setterMethod.getParameterTypes();
        Class<?> arg = types[0];
        if (arg == Byte.TYPE || arg == Byte.class) {
            setterMethod.invoke(obj, Byte.parseByte(value2));
        } else if (arg == Character.TYPE || arg == Character.class) {
            setterMethod.invoke(obj, Character.valueOf(value2.charAt(0)));
        } else if (arg == Short.TYPE || arg == Short.class) {
            setterMethod.invoke(obj, Short.parseShort(value2));
        } else if (arg == Integer.TYPE || arg == Integer.class) {
            setterMethod.invoke(obj, Integer.parseInt(value2));
        } else if (arg == Long.TYPE || arg == Long.class) {
            setterMethod.invoke(obj, Long.parseLong(value2));
        } else if (arg == Float.TYPE || arg == Float.class) {
            setterMethod.invoke(obj, Float.valueOf(Float.parseFloat(value2)));
        } else if (arg == Double.TYPE || arg == Double.class) {
            setterMethod.invoke(obj, Double.parseDouble(value2));
        } else if (arg == Date.class) {
            Date date = this.gfsh.getDate(value2);
            if (date == null) {
                this.gfsh.println("   Unable to parse date.");
            } else {
                setterMethod.invoke(obj, date);
            }
        } else if (arg == String.class) {
            setterMethod.invoke(obj, value2);
        } else {
            this.gfsh.println("   Unsupported type: " + setterMethod.getName() + "(" + arg.getName() + ")");
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        String command = "put (x=123 and y='2' and z=123, a='hello, world' and b=12)(x='abc' and y='de' and z=456, a='test1' and b=99')";
        ArrayList<String> list = new ArrayList<String>();
        Gfsh gfsh = new Gfsh(new String[0]);
        put p = new put(gfsh);
        p.getEntryMap(list, false, false, 1);
    }
}

