/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.Aggregator;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.MemberInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.commands.next;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class pr
implements CommandExecutable {
    private Gfsh gfsh;

    public pr(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("pr -b | -?");
        this.gfsh.println("     -b    Display partitioned region bucket information");
        this.gfsh.println();
    }

    private void usage() {
        this.gfsh.println("pr -b | -?");
    }

    @Override
    public void execute(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 2) {
            this.usage();
            return;
        }
        if (list.contains("-?")) {
            this.help();
        } else if (command.contains("-b")) {
            this.pr_b(command);
        } else {
            String queryString = command;
            this.pr(command, true);
        }
    }

    private void pr_b(String command) throws Exception {
        String regionPath = this.gfsh.getCurrentPath();
        Aggregator aggregator = this.gfsh.getAggregator();
        long startTime = System.currentTimeMillis();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction("pr", regionPath, new Object[]{"-b"}), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        int primaryBucketCount = 0;
        int redundantBucketCount = 0;
        int totalNumBuckets = 0;
        int i = 0;
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            totalNumBuckets = (Integer)data.getUserData();
            Object value2 = data.getDataObject();
            if (value2 == null) continue;
            MemberInfo memberInfo = data.getMemberInfo();
            Map map = (Map)value2;
            List primaryList = (List)map.get("Primary");
            this.gfsh.println(++i + ". Primary Buckets - " + memberInfo.getMemberName() + " (" + memberInfo.getMemberId() + ")");
            PrintUtil.printMappableList(primaryList, "BucketId");
            this.gfsh.println();
            List redundantList = (List)map.get("Redundant");
            this.gfsh.println(i + ". Redundant Buckets - " + memberInfo.getMemberName() + " (" + memberInfo.getMemberId() + ")");
            PrintUtil.printMappableList(redundantList, "BucketId");
            this.gfsh.println();
            primaryBucketCount += primaryList.size();
            redundantBucketCount += redundantList.size();
        }
        this.gfsh.println();
        this.gfsh.println("   Primary Bucket Count: " + primaryBucketCount);
        this.gfsh.println(" Redundant Bucket Count: " + redundantBucketCount);
        this.gfsh.println("total-num-buckets (max): " + totalNumBuckets);
        this.gfsh.println();
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }

    private void printMappableList(MemberInfo memberInfo, List<Mappable> list, int row) throws Exception {
        String columnName = "Bucket";
        if (list != null) {
            this.gfsh.println(row + ". " + memberInfo.getMemberName() + " (" + memberInfo.getMemberId() + ")");
            PrintUtil.printMappableList(list);
            this.gfsh.println();
        }
    }

    public List getRemoteKeys(String regionPath) throws Exception {
        List list = this.pr("select e.key from " + regionPath + ".entries e", true);
        return list;
    }

    public List pr(String queryString, boolean nextEnabled) throws Exception {
        long startTime = System.currentTimeMillis();
        CommandResults cr = this.gfsh.getCommandClient().execute(new QueryTask(queryString, this.gfsh.getFetchSize(), nextEnabled, true));
        long stopTime = System.currentTimeMillis();
        if (cr.getCode() == 1) {
            this.gfsh.println(cr.getCodeMessage());
            return null;
        }
        QueryResults results = (QueryResults)cr.getDataObject();
        if (results == null) {
            this.gfsh.println("No results");
            return null;
        }
        List list = null;
        Object obj = results.getResults();
        if (obj instanceof SelectResults) {
            SelectResults sr = (SelectResults)results.getResults();
            list = sr.asList();
            int startRowNum = results.getReturnedSize() - sr.size() + 1;
            if (this.gfsh.isShowResults()) {
                int rowsPrinted = PrintUtil.printSelectResults(sr, 0, startRowNum, sr.size());
                this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
                this.gfsh.println("   Results: " + sr.size() + ", Returned: " + results.getReturnedSize() + "/" + results.getActualSize());
                next n = (next)this.gfsh.getCommand("next");
                n.setCommand("select");
            } else {
                this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
                this.gfsh.println("   Results: " + sr.size() + ", Returned: " + results.getReturnedSize() + "/" + results.getActualSize());
            }
        } else {
            this.gfsh.println("Results: " + obj);
        }
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
        return list;
    }
}

