/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.Nextable;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.functions.util.LocalRegionInfoFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.ListMessage;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.MapMessage;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.commands.next;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshData;
import com.gemstone.gemfire.internal.tools.gfsh.app.function.GfshFunction;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ls
implements CommandExecutable,
Nextable {
    private static final String HIDDEN_REGION_NAME_PREFIX = "_";
    private static final int TYPE_LOCAL_REGION = 0;
    private static final int TYPE_REMOTE_REGION = 1;
    public static final int TYPE_REMOTE_KEYS = 2;
    private Gfsh gfsh;
    private Region localRegion;
    private Iterator localRegionIterator;
    private List localKeyList;
    private int lastRowPrinted = 0;

    public ls(Gfsh gfsh) {
        this.gfsh = gfsh;
        gfsh.addEnumCommand("ls -e");
        gfsh.addEnumCommand("ls -k");
        gfsh.addEnumCommand("ls -s");
    }

    @Override
    public void help() {
        this.gfsh.println("ls [-a|-c|-e|-k|-m|-p|-r|-s] [region path] | [-?]");
        this.gfsh.println("     List subregions or region entries in the current path or in the");
        this.gfsh.println("     specified path. If no option specified, then it lists all region");
        this.gfsh.println("     names except the hidden region names. A hidden region name begins");
        this.gfsh.println("     with the prefix _ (1 underscore).");
        this.gfsh.println("     -a  List all regions. This option lists all regions including the region");
        this.gfsh.println("         names that begin with the prefix _");
        this.gfsh.println("         (1 underscore).");
        this.gfsh.println("     -c  List cache server information.");
        this.gfsh.println("     -e  List local entries up to the fetch size.");
        this.gfsh.println("     -k  List server keys up to the fetch size. The keys are enumerated. Use");
        this.gfsh.println("         the key numbers to get values using the 'get -k' command.");
        this.gfsh.println("         If partitioned region, then it displays the entries in only the");
        this.gfsh.println("         connected server's local dataset due to the potentially large size");
        this.gfsh.println("         of the partitioned region.");
        this.gfsh.println("     -m  List region info of all peer members.");
        this.gfsh.println("     -p  List the local data set of the partitioned region entries in the");
        this.gfsh.println("         server up to the fetch size. If the region is not a partitioned");
        this.gfsh.println("         region then print the region entries (same as 'ls -s' in that case.)");
        this.gfsh.println("     -r  Recursively list all sub-region paths.");
        this.gfsh.println("     -s  List server entries up to the fetch size. If partitioned region,");
        this.gfsh.println("         then it displays the entries in only the connected server's local");
        this.gfsh.println("         dataset due to the potentially large size of the partitioned region.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("ls -?")) {
            this.help();
            return;
        }
        this.localKeyList = null;
        if (command.startsWith("ls -a")) {
            this.ls_a(command);
        } else if (command.startsWith("ls -c")) {
            this.ls_c(command);
        } else if (command.startsWith("ls -e")) {
            this.ls_e(command);
        } else if (command.startsWith("ls -k")) {
            this.ls_k(command);
        } else if (command.startsWith("ls -m")) {
            this.ls_m(command);
        } else if (command.startsWith("ls -r")) {
            this.ls_r(command);
        } else if (command.startsWith("ls -s")) {
            this.ls_s(command);
        } else if (command.startsWith("ls -p")) {
            this.ls_p(command);
        } else if (command.startsWith("ls")) {
            this.ls(command);
        }
    }

    private void ls_a(String command) throws Exception {
        String regionPath;
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() == 2) {
            regionPath = this.gfsh.getCurrentPath();
        } else {
            regionPath = (String)list.get(2);
            if (!this.isRegionArgValid(regionPath)) {
                return;
            }
        }
        this.listRegions(regionPath, true);
    }

    private void ls_c(String command) throws Exception {
        String regionPath = this.retrievePath(command);
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: invalid region \"/\". Change to a valid region or specify the region path, i.e. ls -c /foo");
            return;
        }
        if (!this.isRegionArgValid(regionPath)) {
            return;
        }
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        long startTime = System.currentTimeMillis();
        List results = (List)this.gfsh.getAggregator().aggregate(new GfshFunction(command, regionPath, null), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        for (AggregateResults aggregateResults : results) {
            GfshData data = (GfshData)aggregateResults.getDataObject();
            ListMessage message = (ListMessage)data.getDataObject();
            this.gfsh.println("--------------------------------------");
            this.gfsh.println("MemberId = " + data.getMemberInfo().getMemberId());
            this.gfsh.println("MemberName = " + data.getMemberInfo().getMemberName());
            this.gfsh.println("Host = " + data.getMemberInfo().getHost());
            this.gfsh.println("Pid = " + data.getMemberInfo().getPid());
            this.gfsh.println();
            Mappable[] mappables = message.getAllMappables();
            for (int i = 0; i < mappables.length; ++i) {
                Set keySet = mappables[i].getKeys();
                ArrayList keyList = new ArrayList(keySet);
                Collections.sort(keyList);
                for (String key2 : keyList) {
                    Object value2 = mappables[i].getValue(key2);
                    this.gfsh.println("   " + key2 + " = " + value2);
                }
                this.gfsh.println();
            }
            this.gfsh.println("--------------------------------------");
            this.gfsh.println();
        }
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }

    private void ls_m(String command) throws Exception {
        String regionPath = this.retrievePath(command);
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: invalid region \"/\". Change to a valid region or specify the region path, i.e. ls -a /foo");
            return;
        }
        if (!this.isRegionArgValid(regionPath)) {
            return;
        }
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        long startTime = System.currentTimeMillis();
        List<Mappable> resultList = (List<Mappable>)this.gfsh.getAggregator().aggregate(new LocalRegionInfoFunction(regionPath), this.gfsh.getAggregateRegionPath());
        long stopTime = System.currentTimeMillis();
        resultList = this.gfsh.setMemberList(resultList);
        boolean isPR = false;
        int totalRegionSize = 0;
        for (int i = 0; i < resultList.size(); ++i) {
            MapMessage info = (MapMessage)resultList.get(i);
            try {
                if (info.getByte("Code") == -1) {
                    this.gfsh.println("Error: " + info.getString("CodeMessage"));
                    return;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            isPR = info.getBoolean("IsPR");
            if (!isPR) continue;
            totalRegionSize += info.getInt("RegionSize");
        }
        PrintUtil.printMappableList(resultList);
        if (isPR) {
            this.gfsh.println("Total Region Size: " + totalRegionSize);
        }
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
    }

    private void ls_k(String command) throws Exception {
        String regionPath = this.retrievePath(command);
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: invalid region \"/\". Change to a valid region or specify the region path, i.e. ls -k /foo");
            return;
        }
        if (!this.isRegionArgValid(regionPath)) {
            return;
        }
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        this.localKeyList = this.listRegionKeys(regionPath, true, true);
        this.gfsh.setLsKeyList(this.localKeyList);
        next n = (next)this.gfsh.getCommand("next");
        n.setCommand(this.getClass().getSimpleName(), 2);
    }

    private void ls_r(String command) throws Exception {
        String[] regionPaths;
        String regionPath = this.retrievePath(command);
        if (regionPath.equals("/")) {
            regionPaths = RegionUtil.getAllRegionPaths(this.gfsh.getCache(), true);
        } else {
            if (!this.isRegionArgValid(regionPath)) {
                return;
            }
            regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
            Region<?, ?> region = RegionUtil.getLocalRegion(regionPath);
            regionPaths = RegionUtil.getAllRegionPaths(region, true);
        }
        for (int i = 0; i < regionPaths.length; ++i) {
            this.gfsh.println(regionPaths[i]);
        }
    }

    private void ls_s(String command) throws Exception {
        String regionPath = this.retrievePath(command);
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: invalid region \"/\". Change to a valid region or specify the region path, i.e. ls -k /foo");
            return;
        }
        if (!this.isRegionArgValid(regionPath)) {
            return;
        }
        this.listRegionEntries(regionPath, true, true);
    }

    private void ls_p(String command) throws Exception {
        String regionPath = this.retrievePath(command);
        if (regionPath.equals("/")) {
            this.gfsh.println("Error: invalid region \"/\". Change to a valid region or specify the region path, i.e. ls -k /foo");
            return;
        }
        if (!this.isRegionArgValid(regionPath)) {
            return;
        }
        this.listRegionEntries(regionPath, true, true);
    }

    private void ls(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String path = list.size() == 1 ? this.gfsh.getCurrentPath() : (String)list.get(1);
        this.listRegions(path, false);
    }

    private void listRegions(String path, boolean listAllRegions) throws Exception {
        Set<Region<?, ?>> regionSet;
        Region region = null;
        if (path.equals("/")) {
            regionSet = this.gfsh.getCache().rootRegions();
        } else {
            path = this.gfsh.getFullPath(path, this.gfsh.getCurrentPath());
            region = this.gfsh.getCache().getRegion(path);
            if (region == null) {
                this.gfsh.println("Error: Region undefined. Invalid path: " + path + ". Use absolute path.");
                return;
            }
            regionSet = region.subregions(false);
        }
        if (regionSet.size() == 0) {
            this.gfsh.println("Subregions: none");
        } else {
            this.gfsh.println("Subregions:");
        }
        ArrayList<String> regionList = new ArrayList<String>();
        for (Region<?, ?> rgn : regionSet) {
            String name = rgn.getName();
            if (!listAllRegions && name.startsWith(HIDDEN_REGION_NAME_PREFIX)) continue;
            regionList.add(name);
        }
        Collections.sort(regionList);
        block1: for (String name : regionList) {
            for (Region<?, ?> rgn : regionSet) {
                String regionName = rgn.getName();
                if (!name.equals(regionName)) continue;
                this.gfsh.println("   " + name);
                if (!rgn.getAttributes().getStatisticsEnabled()) continue block1;
                CacheStatistics stats = rgn.getStatistics();
                this.gfsh.println("      " + stats);
                continue block1;
            }
        }
        this.gfsh.println();
    }

    public List listRegionKeys(String regionPath, boolean nextEnabled, boolean isPRLocalData) throws Exception {
        ArrayList keyList;
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        boolean keysOnly = true;
        long startTime = System.currentTimeMillis();
        CommandResults cr = this.gfsh.getCommandClient().execute(new QueryTask(regionPath, this.gfsh.getFetchSize(), nextEnabled, isPRLocalData, keysOnly));
        long stopTime = System.currentTimeMillis();
        if (cr.getCode() == 1) {
            this.gfsh.println(cr.getCodeMessage());
            return null;
        }
        QueryResults results = (QueryResults)cr.getDataObject();
        if (results == null) {
            this.gfsh.println("No results");
            return null;
        }
        if (regionPath == null) {
            this.localKeyList = null;
            this.lastRowPrinted = 0;
        }
        if ((keyList = this.localKeyList) == null) {
            this.localKeyList = keyList = new ArrayList();
        }
        List list = (List)results.getResults();
        if (this.gfsh.isShowResults()) {
            this.lastRowPrinted = PrintUtil.printList(list, 0, 1, list.size(), results.getActualSize(), keyList);
        } else {
            this.gfsh.println(" Fetch size: " + this.gfsh.getFetchSize());
            this.gfsh.println("   Returned: " + list.size() + "/" + results.getActualSize());
        }
        if (results.isPR()) {
            this.gfsh.println("Partitioned region local dataset retrieval. The actual size maybe larger.");
        }
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
        this.gfsh.setLsKeyList(keyList);
        next n = (next)this.gfsh.getCommand("next");
        n.setCommand(this.getClass().getSimpleName(), 1);
        return keyList;
    }

    public List listRegionEntries(String regionPath, boolean nextEnabled, boolean isPRLocalData) throws Exception {
        ArrayList keyList;
        regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        long startTime = System.currentTimeMillis();
        CommandResults cr = this.gfsh.getCommandClient().execute(new QueryTask(regionPath, this.gfsh.getFetchSize(), nextEnabled, isPRLocalData));
        long stopTime = System.currentTimeMillis();
        if (cr.getCode() == 1) {
            this.gfsh.println(cr.getCodeMessage());
            return null;
        }
        QueryResults results = (QueryResults)cr.getDataObject();
        if (results == null) {
            this.gfsh.println("No results");
            return null;
        }
        if (regionPath == null) {
            this.localKeyList = null;
            this.lastRowPrinted = 0;
        }
        if ((keyList = this.localKeyList) == null) {
            this.localKeyList = keyList = new ArrayList();
        }
        Map map = (Map)results.getResults();
        if (this.gfsh.isShowResults()) {
            this.lastRowPrinted = PrintUtil.printEntries(map, 0, 1, map.size(), results.getActualSize(), keyList);
        } else {
            this.gfsh.println(" Fetch size: " + this.gfsh.getFetchSize());
            this.gfsh.println("   Returned: " + map.size() + "/" + results.getActualSize());
        }
        if (results.isPR()) {
            this.gfsh.println("Partitioned region local dataset retrieval. The actual size maybe larger.");
        }
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
        }
        this.gfsh.setLsKeyList(keyList);
        next n = (next)this.gfsh.getCommand("next");
        n.setCommand(this.getClass().getSimpleName(), 1);
        return keyList;
    }

    @Override
    public List next(Object userData) throws Exception {
        int nexType = (Integer)userData;
        if (nexType == 0) {
            if (this.localRegion == null) {
                return null;
            }
            int rowsPrinted = PrintUtil.printEntries(this.localRegion, this.localRegionIterator, this.lastRowPrinted, this.lastRowPrinted + 1, this.gfsh.getFetchSize(), this.localKeyList);
            this.lastRowPrinted += rowsPrinted;
        } else if (nexType == 1) {
            CommandResults cr = this.gfsh.getCommandClient().execute(new QueryTask(null, this.gfsh.getFetchSize(), true));
            QueryResults results = (QueryResults)cr.getDataObject();
            Map map = (Map)results.getResults();
            if (map != null) {
                int rowsPrinted = PrintUtil.printEntries(map, this.lastRowPrinted, this.lastRowPrinted + 1, map.size(), results.getActualSize(), this.localKeyList);
                if (results.isPR()) {
                    this.gfsh.println("Partitioned region local dataset retrieval. The actual size maybe larger.");
                }
                this.lastRowPrinted += rowsPrinted;
            }
        } else if (nexType == 2) {
            CommandResults cr = this.gfsh.getCommandClient().execute(new QueryTask(null, this.gfsh.getFetchSize(), true));
            QueryResults results = (QueryResults)cr.getDataObject();
            List list = (List)results.getResults();
            if (list != null) {
                int rowsPrinted = PrintUtil.printList(list, this.lastRowPrinted, this.lastRowPrinted + 1, list.size(), results.getActualSize(), this.localKeyList);
                if (results.isPR()) {
                    this.gfsh.println("Partitioned region local dataset retrieval. The actual size maybe larger.");
                }
                this.lastRowPrinted += rowsPrinted;
            }
            if (this.localKeyList == null) {
                this.localKeyList = list;
            } else if (list != null) {
                this.localKeyList.addAll(list);
            }
        }
        next n = (next)this.gfsh.getCommand("next");
        n.setCommand(this.getClass().getSimpleName(), nexType);
        return null;
    }

    private void ls_e(String command) throws Exception {
        String regionPath = this.retrievePath(command);
        this.localRegion = null;
        if (!regionPath.equals("/")) {
            if (!this.isRegionArgValid(regionPath)) {
                return;
            }
            regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
            this.localRegion = this.gfsh.getCache().getRegion(regionPath);
            this.localKeyList = new ArrayList();
            this.localRegionIterator = this.localRegion.entrySet().iterator();
            this.lastRowPrinted = PrintUtil.printEntries(this.localRegion, this.localRegionIterator, 0, 1, this.gfsh.getFetchSize(), this.localKeyList);
            this.gfsh.setLsKeyList(this.localKeyList);
            next n = (next)this.gfsh.getCommand("next");
            n.setCommand(this.getClass().getSimpleName(), 0);
            this.gfsh.println();
        }
    }

    private boolean isOption(Object object) {
        Pattern pattern = Pattern.compile("^-[acmkrspe]");
        Matcher matcher = pattern.matcher(object.toString());
        return matcher.matches();
    }

    private boolean isRegionArgValid(String regionPath) {
        String fullRegionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath());
        Region<?, ?> region = RegionUtil.getLocalRegion(fullRegionPath);
        if (region == null) {
            if (this.isOption(regionPath)) {
                this.gfsh.println("Error: ls does not support mulitple options");
            } else {
                this.gfsh.println("Error: region does not exist - " + regionPath);
            }
            return false;
        }
        return true;
    }

    private String retrievePath(String command) {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        String regionPath = list.size() == 2 ? this.gfsh.getCurrentPath() : (String)list.get(2);
        return regionPath;
    }
}

