/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.Nextable;
import com.gemstone.gemfire.internal.tools.gfsh.app.commands.next;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.PrintUtil;
import java.util.LinkedList;
import java.util.List;

public class local
implements CommandExecutable,
Nextable {
    private Gfsh gfsh;
    private SelectResults selectResults;
    int lastRowPrinted = 0;

    public local(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("local [-?] <query>");
        this.gfsh.println("     Execute the specified query on the local cache.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("local -?")) {
            this.help();
        } else {
            this.local(command);
        }
    }

    @Override
    public List next(Object userData) throws Exception {
        if (this.selectResults == null) {
            return null;
        }
        if (this.gfsh.isShowResults()) {
            int rowsPrinted = PrintUtil.printSelectResults(this.selectResults, this.lastRowPrinted, this.lastRowPrinted + 1, this.gfsh.getFetchSize());
            this.lastRowPrinted += rowsPrinted;
            this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
            this.gfsh.println("   Results: " + this.selectResults.size() + ", Returned: " + this.lastRowPrinted + "/" + this.selectResults.size());
        } else {
            this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
            this.gfsh.println("    Results: " + this.selectResults.size());
        }
        return null;
    }

    private void local(String command) throws Exception {
        LinkedList list = new LinkedList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 2) {
            this.gfsh.println("Error: local requires a query statment");
        } else {
            String queryString = "";
            for (int i = 1; i < list.size(); ++i) {
                queryString = queryString + list.get(i) + " ";
            }
            QueryService queryService = this.gfsh.getCache().getQueryService();
            Query query = queryService.newQuery(queryString);
            long startTime = System.currentTimeMillis();
            Object obj = query.execute();
            long stopTime = System.currentTimeMillis();
            this.selectResults = null;
            if (obj instanceof SelectResults) {
                this.selectResults = (SelectResults)obj;
                if (this.gfsh.isShowResults()) {
                    int rowsPrinted;
                    this.lastRowPrinted = rowsPrinted = PrintUtil.printSelectResults(this.selectResults, 0, 1, this.gfsh.getFetchSize());
                    this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
                    this.gfsh.println("   Results: " + this.selectResults.size() + ", Returned: " + this.lastRowPrinted + "/" + this.selectResults.size());
                    next n = (next)this.gfsh.getCommand("next");
                    n.setCommand(this.getClass().getSimpleName());
                } else {
                    this.gfsh.println("Fetch size: " + this.gfsh.getFetchSize());
                    this.gfsh.println("   Results: " + this.selectResults.size());
                }
            } else {
                this.gfsh.println("Results: " + obj);
            }
            if (this.gfsh.isShowTime()) {
                this.gfsh.println("elapsed (msec): " + (stopTime - startTime));
            }
        }
    }
}

