/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.DBUtil;
import java.util.ArrayList;

public class db
implements CommandExecutable {
    private Gfsh gfsh;
    private DBUtil dbUtil;

    public db(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("db [{<region path> | <oql>} {in | out} {<table name> | <sql>}]");
        this.gfsh.println("   [-k [<primary column>]]");
        this.gfsh.println("   [-v [primary column]]");
        this.gfsh.println("   [-b <batch size>]");
        this.gfsh.println("db [-driver <jdbc driver>]");
        this.gfsh.println("   [-url <jdbc url>]");
        this.gfsh.println("   [-u <user name>]");
        this.gfsh.println("   [-p <password>]");
        this.gfsh.println("db [-?]");
        this.gfsh.println("   Load database contents into a region or store region contents to.");
        this.gfsh.println("   a database table. db has 2 distinctive commands. 'db -driver...'");
        this.gfsh.println("   to initialize database and 'db region_path...' to load/store ");
        this.gfsh.println("   from/to database. Note that if the region is a partitioned region");
        this.gfsh.println("   then the 'out' option retrieves data only from the local dataset");
        this.gfsh.println("   the connected server due to the potentially large size of the");
        this.gfsh.println("   partitioend region.");
        this.gfsh.println();
        this.gfsh.println("   {<region path> | <oql>} region path or OQL query statement. <region path>");
        this.gfsh.println("               stores all of the region entries into the database table.");
        this.gfsh.println("               If <oql>, the query tuples must match table column names.");
        this.gfsh.println("   {in | out} 'in' for load data into the region from the database");
        this.gfsh.println("              'out' for store data out to the database from the region.");
        this.gfsh.println("   {<table name> | <sql>} table name or SQL query statement. <table name>");
        this.gfsh.println("              loads the entire table contents.");
        this.gfsh.println();
        this.gfsh.println("   Requirements:");
        this.gfsh.println("      The data class must have getter and setter methods for the matching");
        this.gfsh.println("      query tuples. db supports case-insensitive table column names.");
        this.gfsh.println("   Examples:");
        this.gfsh.println("      To connect to a dababase:");
        this.gfsh.println("         db -driver com.mysql.jdbc.Driver -url jdbc:mysql://localhost/market \\");
        this.gfsh.println("         -u root -p root");
        this.gfsh.println("      To store the /prices region entries to the price_table database table:");
        this.gfsh.println("         db /prices out price_table");
        this.gfsh.println("      To load database query results to a region:");
        this.gfsh.println("         db /prices in \"select * from price_table");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("db -?")) {
            this.help();
        } else {
            this.db(command);
        }
    }

    public String getDbInitCommand() {
        String dbSettings = null;
        if (this.dbUtil != null) {
            String url = this.dbUtil.getUrl();
            String driverName = this.dbUtil.getDriverName();
            String userName = this.dbUtil.getUserName();
            if (url == null || driverName == null) {
                return null;
            }
            dbSettings = "db ";
            if (url != null) {
                dbSettings = dbSettings + "-url " + url;
            }
            if (driverName != null) {
                dbSettings = dbSettings + " -driver " + driverName;
            }
            if (userName != null) {
                dbSettings = dbSettings + " -u " + userName;
            }
        }
        return dbSettings;
    }

    private void db(String command) throws Exception {
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        boolean optionSpecified = false;
        String driver = null;
        String url = null;
        String user = null;
        String password = null;
        boolean storeKeys = false;
        boolean storeValues = false;
        boolean isKeyPrimary = false;
        boolean isValuePrimary = false;
        String primaryColumn = null;
        int batchSize = 1000;
        for (int i = 0; i < list.size(); ++i) {
            String val = (String)list.get(i);
            if (val.equals("-driver")) {
                if (list.size() > ++i) {
                    driver = (String)list.get(i);
                }
                optionSpecified = true;
                continue;
            }
            if (val.equals("-url")) {
                if (list.size() > ++i) {
                    url = (String)list.get(i);
                }
                optionSpecified = true;
                continue;
            }
            if (val.equals("-u")) {
                if (list.size() > ++i) {
                    user = (String)list.get(i);
                }
                optionSpecified = true;
                continue;
            }
            if (val.equals("-p")) {
                if (list.size() > ++i) {
                    password = (String)list.get(i);
                }
                optionSpecified = true;
                continue;
            }
            if (val.equals("-k")) {
                storeKeys = true;
                if (list.size() <= i + 1 || ((String)list.get(i + 1)).startsWith("-")) continue;
                primaryColumn = (String)list.get(++i);
                isKeyPrimary = true;
                continue;
            }
            if (val.equals("-v")) {
                storeValues = true;
                if (list.size() <= i + 1 || ((String)list.get(i + 1)).startsWith("-")) continue;
                primaryColumn = (String)list.get(++i);
                isValuePrimary = true;
                continue;
            }
            if (!val.equals("-b") || list.size() <= ++i) continue;
            val = (String)list.get(i);
            batchSize = Integer.parseInt(val);
        }
        if (optionSpecified) {
            if (driver == null) {
                this.gfsh.println("Error: -driver not specified.");
                return;
            }
            if (url == null) {
                this.gfsh.println("Error: -url not specified.");
                return;
            }
            this.dbUtil = DBUtil.initialize(driver, url, user, password);
            if (this.dbUtil != null) {
                this.gfsh.println("Database connected.");
            }
            return;
        }
        if (this.dbUtil == null) {
            this.gfsh.println("Error: Not connected to database.");
            return;
        }
        if (list.size() < 4) {
            this.gfsh.println("Error: incomplete db command. Run db -? for help.");
            return;
        }
        Object fullPath = null;
        String regionPath = (String)list.get(1);
        String directionType = (String)list.get(2);
        Cache cache = CacheFactory.getAnyInstance();
        Region region = null;
        String oql = null;
        if (!regionPath.startsWith("select ")) {
            region = cache.getRegion(regionPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath()));
            if (region == null) {
                this.gfsh.println("Error: region undefined - " + regionPath);
                return;
            }
        } else {
            oql = regionPath;
        }
        boolean isIn = false;
        if (directionType.equalsIgnoreCase("in")) {
            isIn = true;
        } else if (directionType.equalsIgnoreCase("out")) {
            isIn = false;
        } else {
            this.gfsh.println("Error: invalid direction type - " + directionType);
            return;
        }
        if (isIn) {
            String sql = (String)list.get(3);
            this.dbIn(region, sql, primaryColumn);
        } else {
            String tableName = (String)list.get(3);
            if (!storeKeys && !storeValues) {
                storeValues = true;
            }
            if (isValuePrimary) {
                isKeyPrimary = false;
            }
            int storeType = 1;
            if (storeKeys && storeValues) {
                storeType = 2;
            } else if (storeKeys) {
                storeType = 0;
            }
            this.dbOut(regionPath, tableName, storeType, primaryColumn, isKeyPrimary, batchSize);
        }
    }

    private void dbIn(Region region, String sql, String primaryColumn) throws Exception {
        long startTime = System.currentTimeMillis();
        int rowCount = this.dbUtil.loadDB(this.gfsh, region, this.gfsh.getQueryKeyClass(), this.gfsh.getValueClass(), sql, primaryColumn);
        long stopTime = System.currentTimeMillis();
        this.gfsh.println("db in complete");
        this.gfsh.println("       To (region): " + region.getFullPath());
        this.gfsh.println("   From (database): " + sql);
        this.gfsh.println("         Row count: " + rowCount);
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("    elapsed (msec): " + (stopTime - startTime));
        }
    }

    private void dbOut(String regionPath, String tableName, int storeType, String primaryColumn, boolean isKeyPrimary, int batchSize) throws Exception {
        long startTime = System.currentTimeMillis();
        int rowCount = this.dbUtil.storeDB(this.gfsh, regionPath, tableName, storeType, primaryColumn, isKeyPrimary, batchSize);
        long stopTime = System.currentTimeMillis();
        if (rowCount == -1) {
            return;
        }
        this.gfsh.println("db out complete");
        this.gfsh.println("   From (region): " + regionPath);
        this.gfsh.println("   To (database): " + tableName);
        this.gfsh.println("       Row count: " + rowCount);
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("  elapsed (msec): " + (stopTime - startTime));
        }
    }
}

