/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.InstantiatorClassLoader;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ClassFinder;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyType;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyTypeManager;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class classloader
implements CommandExecutable {
    private Gfsh gfsh;

    public classloader(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("class [-c <fully-qualified class name>] [-id <class id>]");
        this.gfsh.println("      [-d  <DataSerializables.txt>");
        this.gfsh.println("      [-jar <jar paths>]");
        this.gfsh.println("      [-dir <dir path>]");
        this.gfsh.println("      [-?]");
        this.gfsh.println("   Load Instantiator registered data classes. All data classes");
        this.gfsh.println("   that use a static block to register class ids via Instantiator");
        this.gfsh.println("   must be preloaded using this command. Note that this command");
        this.gfsh.println("   is NOT equivalent to setting CLASSPATH. As always, the classes");
        this.gfsh.println("   and jar files must be in the class path before starting gfsh.");
        this.gfsh.println("   Please run 'gfsh -?' to see more details.");
        this.gfsh.println("     -c <fully-qualified class name> Load the specified class.");
        this.gfsh.println("           The specified class typically contains a static block");
        this.gfsh.println("           that registers class ids using GemFire Instantiator.");
        this.gfsh.println("     -id <class id> if the class ID for the cass name specified with");
        this.gfsh.println("            the option '-c' is not defined by Instantiator then");
        this.gfsh.println("            the '-id' option must be used to assign the class id");
        this.gfsh.println("            that matches the instantiator class id defined in the");
        this.gfsh.println("            server's cache.xml file. This options is supported for");
        this.gfsh.println("            GFE 6.x or greater.");
        this.gfsh.println("     -d <DataSerializables.txt> Load the classes listed");
        this.gfsh.println("           in the specified file. The file path can be relative");
        this.gfsh.println("           or absolute.");
        this.gfsh.println("     -jar <jar paths> Load all classes in the jar paths. The jar paths");
        this.gfsh.println("            can be separated by ',', ';', or ':'. The jar paths");
        this.gfsh.println("            can be relative or absolute.");
        this.gfsh.println("     -dir <directory> Load all classes in the directory.");
        this.gfsh.println("            The directory path can be relative or absolute.");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("class -?")) {
            this.help();
        } else if (command.startsWith("class -c")) {
            this.class_c(command);
        } else if (command.startsWith("class -id")) {
            this.class_c(command);
        } else if (command.startsWith("class -dir")) {
            this.class_dir(command);
        } else if (command.startsWith("class -d")) {
            this.class_d(command);
        } else if (command.startsWith("class -jar")) {
            this.class_jar(command);
        } else {
            this.gfsh.println("Error: invalid command - " + command);
        }
    }

    private void class_c(String command) {
        block15: {
            ArrayList list = new ArrayList();
            Gfsh.parseCommand(command, list);
            if (list.size() < 2) {
                this.gfsh.println("Error: must specify an option. Run 'class -?' for options");
                return;
            }
            if (list.size() < 3) {
                if (list.get(1).equals("-c")) {
                    this.gfsh.println("Error: must specify a fully-qualified class name");
                } else if (list.get(1).equals("-id")) {
                    this.gfsh.println("Error: must specify the class id");
                }
                return;
            }
            String className = null;
            boolean classIdSpecified = false;
            int classId = 0;
            for (int i = 1; i < list.size(); ++i) {
                String val = (String)list.get(i);
                if (val.equals("-c")) {
                    if (list.size() <= ++i) {
                        this.gfsh.println("Error: class name not specified");
                        return;
                    }
                    className = (String)list.get(i);
                    continue;
                }
                if (!val.equals("-id")) continue;
                if (list.size() <= ++i) {
                    this.gfsh.println("Error: class id not specified");
                    return;
                }
                classIdSpecified = true;
                try {
                    classId = Integer.parseInt((String)list.get(i));
                    continue;
                }
                catch (Exception ex) {
                    this.gfsh.println("Error: " + ex.getMessage());
                }
            }
            if (className == null) {
                this.gfsh.println("Error: class name not specified");
                return;
            }
            try {
                final Class<?> clazz = Class.forName(className);
                if (classIdSpecified) {
                    Instantiator.register(new Instantiator(clazz, classId){

                        @Override
                        public DataSerializable newInstance() {
                            DataSerializable obj;
                            block2: {
                                obj = null;
                                try {
                                    obj = (DataSerializable)clazz.newInstance();
                                }
                                catch (Exception ex) {
                                    classloader.this.gfsh.println("Error: unable to create a new instance of " + clazz.getCanonicalName());
                                    if (!classloader.this.gfsh.isDebug()) break block2;
                                    ex.printStackTrace();
                                }
                            }
                            return obj;
                        }
                    });
                }
                this.gfsh.println("class loaded: " + clazz.getName());
            }
            catch (Exception e) {
                this.gfsh.println("Error: " + e.getClass().getSimpleName() + " - " + e.getMessage());
                if (!this.gfsh.isDebug()) break block15;
                e.printStackTrace();
            }
        }
    }

    private void class_d(String command) {
        block3: {
            ArrayList list = new ArrayList();
            Gfsh.parseCommand(command, list);
            if (list.size() < 3) {
                this.gfsh.println("Error: must specify the file path of DataSerializables.txt");
                return;
            }
            String filePath = (String)list.get(2);
            try {
                InstantiatorClassLoader.loadDataSerializables(filePath);
                this.gfsh.println();
                this.gfsh.println("application classes successfully loaded: " + filePath);
            }
            catch (Exception e) {
                this.gfsh.println("Error: " + e.getClass().getSimpleName() + " - " + e.getMessage() + ". Aborted.");
                if (!this.gfsh.isDebug()) break block3;
                e.printStackTrace();
            }
        }
    }

    private void class_jar(String command) {
        block8: {
            ArrayList list = new ArrayList();
            Gfsh.parseCommand(command, list);
            if (list.size() < 3) {
                this.gfsh.println("Error: must specify the jar paths");
                return;
            }
            String jarPaths = (String)list.get(2);
            if (jarPaths == null) {
                return;
            }
            if ((jarPaths = jarPaths.trim()).length() == 0) {
                return;
            }
            String pathSeparator = System.getProperty("path.separator");
            try {
                jarPaths = jarPaths.replace(pathSeparator.charAt(0), ',');
                String[] split = jarPaths.split(",");
                URL[] url = new URL[split.length];
                ArrayList<String> classNameList = new ArrayList<String>();
                for (int i = 0; i < split.length; ++i) {
                    String path = split[i];
                    File file = new File(path);
                    URI uri = file.toURI();
                    url[i] = uri.toURL();
                    String[] classNames = ClassFinder.getAllClassNames(path);
                    for (int j = 0; j < classNames.length; ++j) {
                        classNameList.add(classNames[j]);
                    }
                }
                URLClassLoader cl = new URLClassLoader(url);
                for (String className : classNameList) {
                    Class<?> cls = Class.forName(className, true, cl);
                    if (!KeyType.class.isAssignableFrom(cls) || cls.getSimpleName().matches(".*_v\\d++$")) continue;
                    Method method = cls.getMethod("getKeyType", null);
                    KeyType keyType = (KeyType)method.invoke(cls, (Object[])null);
                    KeyTypeManager.registerKeyType(keyType);
                }
                this.gfsh.println();
                this.gfsh.println("application classes successfully loaded from: " + jarPaths);
            }
            catch (Exception ex) {
                this.gfsh.println("Error: " + ex.getClass().getSimpleName() + " - " + ex.getMessage());
                if (!this.gfsh.isDebug()) break block8;
                ex.printStackTrace();
            }
        }
    }

    private void class_dir(String command) {
        block9: {
            ArrayList list = new ArrayList();
            Gfsh.parseCommand(command, list);
            if (list.size() < 3) {
                this.gfsh.println("Error: must specify the directory path");
                return;
            }
            String dirPath = (String)list.get(2);
            if (dirPath == null) {
                return;
            }
            if ((dirPath = dirPath.trim()).length() == 0) {
                return;
            }
            File file = new File(dirPath);
            if (!file.exists()) {
                return;
            }
            ArrayList<File> jarFileList = this.getJarFiles(file);
            try {
                ArrayList<String> classNameList = new ArrayList<String>();
                URL[] url = new URL[jarFileList.size()];
                int i = 0;
                for (File file2 : jarFileList) {
                    URI uri = file2.toURI();
                    url[i++] = uri.toURL();
                    String[] classNames = ClassFinder.getAllClassNames(file2.getAbsolutePath());
                    for (int j = 0; j < classNames.length; ++j) {
                        classNameList.add(classNames[j]);
                    }
                }
                URLClassLoader cl = new URLClassLoader(url);
                for (String className : classNameList) {
                    Class.forName(className, true, cl);
                }
                this.gfsh.println();
                this.gfsh.println("application classes successfully loaded from: " + dirPath);
            }
            catch (Exception ex) {
                this.gfsh.println("Error: " + ex.getClass().getSimpleName() + " - " + ex.getMessage());
                if (!this.gfsh.isDebug()) break block9;
                ex.printStackTrace();
            }
        }
    }

    private ArrayList<File> getJarFiles(File dir) {
        return this.getJarFiles(dir, new ArrayList<File>());
    }

    private ArrayList<File> getJarFiles(File dir, ArrayList<File> fileList) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory() && pathname.getName().endsWith(".jar");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            fileList.add(files[i]);
        }
        File[] dirs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        for (int i = 0; i < dirs.length; ++i) {
            fileList = this.getJarFiles(dirs[i], fileList);
        }
        return fileList;
    }
}

