/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.commands;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.tools.gfsh.app.CommandExecutable;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ReflectionUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.ObjectUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.OutputUtil;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class bcp
implements CommandExecutable {
    private Gfsh gfsh;

    public bcp(Gfsh gfsh) {
        this.gfsh = gfsh;
    }

    @Override
    public void help() {
        this.gfsh.println("bcp <region path> {in | out} <data file>");
        this.gfsh.println("    [-k] [-v]");
        this.gfsh.println("    [-r <row terminator>]");
        this.gfsh.println("    [-t <field terminator>]");
        this.gfsh.println("    [-F <first row>]");
        this.gfsh.println("    [-L <last row>]");
        this.gfsh.println("    [-b <batch size>]");
        this.gfsh.println("    [-d <date format>]");
        this.gfsh.println("    [-f <value key field>]");
        this.gfsh.println("    Bulk-copy region entries to a file or bulk-copy file contents to region.");
        this.gfsh.println("    The region path can be absolute or relative. Note that if the region is");
        this.gfsh.println("    a partitioned region then the 'out' option retrieves data only from");
        this.gfsh.println("    the local dataset of the connected server due to the potentially large");
        this.gfsh.println("    size of the partitioend region.");
        this.gfsh.println("    -k Copy key fields. If both -k and -v are specified then the key field");
        this.gfsh.println("       takes precedence.");
        this.gfsh.println("    -v Copy value fields. If both -k and -v are specified then the key field");
        this.gfsh.println("       takes precedence.");
        this.gfsh.println("    -r Row terminator character. Default: platform specific.");
        this.gfsh.println("    -t Field terminator charater. Default: ,");
        this.gfsh.println("    -F The number of the first row in the file to load.");
        this.gfsh.println("    -L The number of the last row in the file to load.");
        this.gfsh.println("    -b The batch size. Default: 1000");
        this.gfsh.println("    -d The date format (conforms to SimpleDateFormat). Teh format must be");
        this.gfsh.println("       enclosed in double quotes. Default: \"EEE MMM dd HH:mm:ss zzz yyyy\"");
        this.gfsh.println("    -f The name of the key field to store or load.");
        this.gfsh.println("    Default:");
        this.gfsh.println("        bcp <region path> out <file> -v -r \\n -t , -F 1 -b 1000 \\");
        this.gfsh.println("            -d \"EEE MMM dd HH:mm:ss zzz yyyy\"");
        this.gfsh.println("    Example:");
        this.gfsh.println("        bcp /prices out price_out -t ,");
        this.gfsh.println();
    }

    @Override
    public void execute(String command) throws Exception {
        if (command.startsWith("bcp -?")) {
            this.help();
        } else {
            this.bcp(command);
        }
    }

    private void bcp(String command) throws Exception {
        String fullPath;
        ArrayList list = new ArrayList();
        Gfsh.parseCommand(command, list);
        if (list.size() < 4) {
            this.gfsh.println("Error: incomplete bcp command. Run bcp -? for help.");
            return;
        }
        String regionPath = (String)list.get(1);
        String directionType = (String)list.get(2);
        String filePath = (String)list.get(3);
        Cache cache = CacheFactory.getAnyInstance();
        Region region = cache.getRegion(fullPath = this.gfsh.getFullPath(regionPath, this.gfsh.getCurrentPath()));
        if (region == null) {
            this.gfsh.println("Error: region undefined - " + fullPath);
            return;
        }
        boolean isIn = false;
        if (directionType.equalsIgnoreCase("in")) {
            isIn = true;
        } else if (directionType.equalsIgnoreCase("out")) {
            isIn = false;
        } else {
            this.gfsh.println("Error: invalid direction type - " + directionType);
            return;
        }
        File file = new File(filePath);
        if (isIn) {
            if (!file.exists()) {
                this.gfsh.println("Error: input file does not exist - " + file.getAbsolutePath());
                return;
            }
        } else if (file.exists()) {
            this.gfsh.println("Error: output file already exists - " + file.getAbsolutePath());
            return;
        }
        String fieldTerminator = ",";
        String rowTerminator = "\n";
        int firstRow = 1;
        int lastRow = -1;
        int batchSize = 1000;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        String valueKeyFieldName = null;
        boolean printKeys = false;
        boolean printValues = false;
        for (int i = 0; i < list.size(); ++i) {
            String val = (String)list.get(i);
            if (val.equals("-t")) {
                if (list.size() <= ++i) continue;
                fieldTerminator = (String)list.get(i);
                continue;
            }
            if (val.equals("-r")) {
                if (list.size() <= ++i) continue;
                rowTerminator = (String)list.get(i);
                rowTerminator = "\r\n";
                continue;
            }
            if (val.equals("-F")) {
                if (list.size() <= ++i) continue;
                val = (String)list.get(i);
                firstRow = Integer.parseInt(val);
                continue;
            }
            if (val.equals("-L")) {
                if (list.size() <= ++i) continue;
                val = (String)list.get(i);
                lastRow = Integer.parseInt(val);
                continue;
            }
            if (val.equals("-b")) {
                if (list.size() <= ++i) continue;
                val = (String)list.get(i);
                batchSize = Integer.parseInt(val);
                continue;
            }
            if (val.equals("-d")) {
                if (list.size() <= ++i) continue;
                String str = (String)list.get(i);
                dateFormat = new SimpleDateFormat(str);
                continue;
            }
            if (val.equals("-f")) {
                if (list.size() <= ++i) continue;
                valueKeyFieldName = (String)list.get(i);
                continue;
            }
            if (val.equals("-k")) {
                printKeys = true;
                continue;
            }
            if (!val.equals("-v")) continue;
            printValues = true;
        }
        if (isIn) {
            this.bcpIn(region, file, fieldTerminator, rowTerminator, firstRow, lastRow, batchSize, valueKeyFieldName);
        } else {
            if (!printKeys && !printValues) {
                printValues = true;
            }
            this.bcpOut(fullPath, file, fieldTerminator, rowTerminator, firstRow, lastRow, batchSize, printKeys, printValues, dateFormat, valueKeyFieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bcpIn(Region region, File file, String fieldTerminator, String rowTerminator, int firstRow, int lastRow, int batchSize, String valueKeyFieldName) throws Exception {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            this.bcpIn(region, reader, file, fieldTerminator, rowTerminator, firstRow, lastRow, batchSize, valueKeyFieldName);
        }
    }

    private void bcpIn(Region region, BufferedReader reader, File file, String fieldTerminator, String rowTerminator, int firstRow, int lastRow, int batchSize, String valueKeyFieldName) throws Exception {
        if (lastRow < 0) {
            lastRow = Integer.MAX_VALUE;
        }
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        String[] keyMethodNames = new String[]{};
        String[] valueMethodNames = null;
        Map keySetterMap = null;
        Map valueSetterMap = null;
        Object key2 = null;
        Object value2 = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        Method valueKeyGetterMethod = null;
        String line = reader.readLine();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int count = 0;
        int rowCount = 0;
        long startTime = System.currentTimeMillis();
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("#")) {
                if (line.startsWith("#%key")) {
                    int endIndex = line.indexOf(fieldTerminator);
                    String keyClassName = endIndex == -1 ? line.substring(5) : line.substring(5, endIndex);
                    keyClassName = keyClassName.trim();
                    keyClass = Class.forName(keyClassName);
                } else if (line.startsWith("#%value_key")) {
                    if (valueKeyFieldName == null) {
                        int endIndex = line.indexOf(fieldTerminator);
                        valueKeyFieldName = endIndex == -1 ? line.substring(11) : line.substring(11, endIndex);
                    }
                    valueKeyFieldName = valueKeyFieldName.trim();
                    Map valueGetterMap = ReflectionUtil.getAllGettersMap(valueClass);
                    valueKeyGetterMethod = (Method)valueGetterMap.get("get" + valueKeyFieldName);
                } else if (line.startsWith("#%value")) {
                    int endIndex = line.indexOf(fieldTerminator);
                    String valueClassName = endIndex == -1 ? line.substring(7) : line.substring(7, endIndex);
                    valueClassName = valueClassName.trim();
                    valueClass = Class.forName(valueClassName);
                } else if (line.startsWith("#%date_format")) {
                    int endIndex = line.indexOf(fieldTerminator);
                    String dateFormatString = endIndex == -1 ? line.substring(13) : line.substring(13, endIndex);
                    dateFormatString = dateFormatString.trim();
                    dateFormat = new SimpleDateFormat(dateFormatString);
                } else if (line.startsWith("#|")) {
                    int i;
                    String keyHeader = null;
                    String valueHeader = null;
                    String header = line.substring(2);
                    int index2 = header.indexOf("#|");
                    if (index2 != -1) {
                        if (keyClass != null) {
                            keyHeader = header.substring(0, index2);
                            keyMethodNames = keyHeader.split(",");
                            for (i = 0; i < keyMethodNames.length; ++i) {
                                keyMethodNames[i] = "set" + keyMethodNames[i];
                            }
                            keySetterMap = ReflectionUtil.getAllSettersMap(keyClass);
                        }
                        index2 += 2;
                    } else {
                        index2 = 0;
                    }
                    if (valueClass != null) {
                        valueHeader = header.substring(index2);
                        valueMethodNames = valueHeader.split(",");
                        for (i = 0; i < valueMethodNames.length; ++i) {
                            valueMethodNames[i] = "set" + valueMethodNames[i];
                        }
                        valueSetterMap = ReflectionUtil.getAllSettersMap(valueClass);
                    }
                }
            } else if (firstRow <= ++count && count <= lastRow) {
                String[] tokens = bcp.getTokens(line);
                boolean j = false;
                if (keyClass != null) {
                    key2 = this.updateObject(keyClass, keySetterMap, keyMethodNames, tokens, 0, dateFormat);
                }
                if (valueClass != null) {
                    value2 = this.updateObject(valueClass, valueSetterMap, valueMethodNames, tokens, keyMethodNames.length, dateFormat);
                }
                if (keyClass == null && valueKeyGetterMethod != null) {
                    key2 = valueKeyGetterMethod.invoke(value2, (Object[])null);
                }
                if (key2 == null) {
                    this.gfsh.println("Error: key is undefined. Use the option '-f' to specify the column (field) name.");
                    return;
                }
                map.put(key2, value2);
                if (map.size() == batchSize) {
                    region.putAll(map);
                    rowCount += map.size();
                    map.clear();
                }
            } else if (count > lastRow) break;
            line = reader.readLine();
        }
        if (map.size() > 0) {
            region.putAll(map);
            rowCount += map.size();
        }
        long stopTime = System.currentTimeMillis();
        this.gfsh.println("bcp in complete");
        this.gfsh.println("       To (region): " + region.getFullPath());
        this.gfsh.println("       From (file): " + file.getAbsolutePath());
        this.gfsh.println("         Row count: " + rowCount);
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("    elapsed (msec): " + (stopTime - startTime));
        }
    }

    private Object updateObject(Class clazz, Map<String, Method> setterMap, String[] setterMethodNames, String[] tokens, int startTokenIndex, SimpleDateFormat dateFormat) throws Exception {
        String value2 = tokens[startTokenIndex];
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Byte.parseByte(value2);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf(value2.charAt(0));
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Short.parseShort(value2);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.parseInt(value2);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long.parseLong(value2);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(Float.parseFloat(value2));
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.parseDouble(value2);
        }
        if (clazz == Date.class) {
            return dateFormat.parse(value2);
        }
        if (clazz == String.class) {
            return value2;
        }
        Object obj = clazz.newInstance();
        for (int i = 0; i < setterMethodNames.length; ++i) {
            ObjectUtil.updateObject(this.gfsh, setterMap, obj, setterMethodNames[i], tokens[startTokenIndex + i], dateFormat, true);
        }
        return obj;
    }

    private static String[] getTokens(String line) {
        ArrayList<String> list = new ArrayList<String>();
        boolean openQuote = false;
        String value2 = "";
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == ',') {
                if (!openQuote) {
                    if ((value2 = value2.trim()).startsWith("\"") && value2.indexOf(" ") != -1 && (value2 = value2.substring(1)).endsWith("\"")) {
                        value2 = value2.substring(0, value2.length() - 1);
                    }
                    list.add(value2);
                    value2 = "";
                    continue;
                }
            } else if (c == '\"') {
                openQuote = !openQuote;
            }
            value2 = value2 + c;
        }
        list.add(value2);
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bcpOut(String regionPath, File file, String fieldTerminator, String rowTerminator, int firstRow, int lastRow, int batchSize, boolean printKeys, boolean printValues, SimpleDateFormat dateFormat, String valueKeyFieldName) throws IOException {
        try (PrintWriter writer = new PrintWriter(file);){
            this.bcpOut(regionPath, writer, file, fieldTerminator, rowTerminator, firstRow, lastRow, batchSize, printKeys, printValues, dateFormat, valueKeyFieldName);
        }
    }

    private void bcpOut(String regionPath, PrintWriter writer, File file, String fieldTerminator, String rowTerminator, int firstRow, int lastRow, int batchSize, boolean printKeys, boolean printValues, SimpleDateFormat dateFormat, String valueKeyFieldName) throws IOException {
        Map map;
        int totalPrinted = 0;
        int actualSize = 0;
        boolean printHeader = true;
        int printType = 1;
        if (printKeys && printValues) {
            printType = 2;
        } else if (printKeys) {
            printType = 0;
        }
        String taskRegionPath = regionPath;
        long startTime = System.currentTimeMillis();
        do {
            CommandResults cr;
            if ((cr = this.gfsh.getCommandClient().execute(new QueryTask(taskRegionPath, batchSize, true))).getCode() == 1) {
                this.gfsh.println(cr.getCodeMessage());
                return;
            }
            QueryResults results = (QueryResults)cr.getDataObject();
            if (results == null || results.getResults() == null) {
                this.gfsh.println("No results");
                return;
            }
            map = (Map)results.getResults();
            if (map.size() == 0) {
                this.gfsh.println("Region empty. File not created.");
                writer.close();
                file.delete();
                return;
            }
            OutputUtil.printEntries(writer, map, fieldTerminator, rowTerminator, firstRow, lastRow, printType, printHeader, dateFormat, valueKeyFieldName);
            actualSize = results.getActualSize();
            taskRegionPath = null;
            printHeader = false;
        } while ((totalPrinted += map.size()) < actualSize);
        long stopTime = System.currentTimeMillis();
        writer.close();
        this.gfsh.println("bcp out complete");
        this.gfsh.println("   From (region): " + regionPath);
        this.gfsh.println("       To (file): " + file.getAbsolutePath());
        this.gfsh.println("       Row count: " + totalPrinted);
        if (this.gfsh.isShowTime()) {
            this.gfsh.println("  elapsed (msec): " + (stopTime - startTime));
        }
    }

    public static void main(String[] args) {
        int i;
        String line = "H\"B\"AN,23.82,300,23.79,800,\"Thu, \"test\", 'helo' Jun 08 09:41:19 EDT 2006\",99895,1094931009,82,99895,8,HBAN";
        String[] tokens = bcp.getTokens(line);
        System.out.println(line);
        for (i = 0; i < tokens.length; ++i) {
            System.out.print(tokens[i] + ",");
        }
        System.out.println();
        for (i = 0; i < tokens.length; ++i) {
            System.out.println(tokens[i]);
        }
    }
}

