/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.command;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandException;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandResultsListener;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RegionCreateTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.RegionDestroyTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.data.RegionAttributeInfo;
import com.gemstone.gemfire.internal.tools.gfsh.command.AbstractCommandTask;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import com.gemstone.gemfire.internal.tools.gfsh.util.RegionUtil;
import java.util.ArrayList;
import java.util.UUID;

public class CommandClient {
    private static final String KEY_DEFAULT = "_command";
    private static final String KEY_BROADCAST = "_bcast";
    private Region outboxRegion;
    private String outboxRegionFullPath;
    private String endpoints;
    private Pool pool;
    private Region inboxRegion;
    private boolean inboxEnabled = false;
    private ArrayList commandResultsListenerList = new ArrayList(5);
    private CommandResultsListener[] commandResultsListeners = new CommandResultsListener[0];

    public CommandClient(String outboxRegionFullPath, String poolNameOrEndpoints) throws CacheException {
        this(outboxRegionFullPath, poolNameOrEndpoints, CommandClient.isPoolName(poolNameOrEndpoints));
    }

    public CommandClient(String outboxRegionFullPath, String poolNameOrEndpoints, boolean isPool) {
        this.init(outboxRegionFullPath, poolNameOrEndpoints, isPool);
    }

    private static boolean isPoolName(String poolNameOrEndpoints) {
        return poolNameOrEndpoints.indexOf(":") != -1;
    }

    private void init(String outboxRegionFullPath, String poolNameOrEndpoints, boolean isPool) {
        this.outboxRegionFullPath = outboxRegionFullPath == null ? "__command" : outboxRegionFullPath;
        if (isPool) {
            this.pool = PoolManager.find(poolNameOrEndpoints);
            this.outboxRegion = RegionUtil.getRegion(this.outboxRegionFullPath, Scope.LOCAL, DataPolicy.EMPTY, this.pool, false);
        } else {
            this.endpoints = poolNameOrEndpoints;
            this.outboxRegion = RegionUtil.getRegion(this.outboxRegionFullPath, Scope.LOCAL, DataPolicy.EMPTY, this.endpoints, false);
        }
    }

    public CommandClient(String outboxRegionFullPath, Pool pool) throws CacheException {
        this.outboxRegionFullPath = outboxRegionFullPath == null ? "__command" : outboxRegionFullPath;
        this.pool = pool;
        this.outboxRegion = RegionUtil.getRegion(this.outboxRegionFullPath, Scope.LOCAL, DataPolicy.EMPTY, pool, false);
    }

    public CommandClient(String poolNameOrEndpoints) throws CacheException {
        this(null, poolNameOrEndpoints);
    }

    public CommandClient(Pool pool) {
        this.pool = pool;
    }

    private CommandResults execute(CommandTask task, boolean isBroadcast) {
        if (this.isClosed()) {
            return null;
        }
        if (this.isInboxEnabled() && task instanceof AbstractCommandTask) {
            ((AbstractCommandTask)task).setResultSetRegionPath(this.inboxRegion.getFullPath());
        }
        if (isBroadcast) {
            return (CommandResults)this.outboxRegion.get(KEY_BROADCAST, task);
        }
        return (CommandResults)this.outboxRegion.get(KEY_DEFAULT, task);
    }

    public CommandResults execute(CommandTask task) {
        return this.execute(task, false);
    }

    public CommandResults broadcast(CommandTask task) {
        return this.execute(task, true);
    }

    public void execute(CommandTask task, Object dataObject) {
        if (this.isClosed()) {
            return;
        }
        this.outboxRegion.put(task, dataObject);
    }

    public void setInboxEnabled(boolean inboxEnabled) throws CommandException {
        if (this.isClosed()) {
            return;
        }
        this.inboxEnabled = inboxEnabled;
        this.setUniqueInbox(this.outboxRegion.getFullPath());
    }

    public boolean isInboxEnabled() {
        return this.inboxEnabled;
    }

    public void close() throws CommandException {
        CommandResults results = null;
        if (this.inboxRegion != null) {
            results = this.broadcast(new RegionDestroyTask(this.inboxRegion.getFullPath()));
            this.inboxRegion = null;
            this.inboxEnabled = false;
        }
        if (this.outboxRegion != null) {
            this.outboxRegion.localDestroyRegion();
            this.outboxRegion = null;
        }
        if (results != null && results.getCode() == 1) {
            throw new CommandException("Server may have not destroyed the client command region(s)", results.getException());
        }
    }

    public boolean isClosed() {
        return this.outboxRegion == null;
    }

    public String getInboxRegionFullPath() {
        if (this.inboxRegion == null) {
            return null;
        }
        return this.inboxRegion.getFullPath();
    }

    private String createUniqueRegionName() throws Exception {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    private void setUniqueInbox(String regionFullPath) throws CommandException {
        if (regionFullPath == null) {
            this.inboxRegion = null;
            return;
        }
        try {
            String inboxPath = regionFullPath + "/" + this.createUniqueRegionName();
            RegionAttributeInfo attrInfo = new RegionAttributeInfo();
            attrInfo.setAttribute("scope", "local");
            attrInfo.setAttribute("data-policy", "empty");
            CommandResults results = this.broadcast(new RegionCreateTask(inboxPath, attrInfo));
            if (results.getCode() == 1) {
                throw new CommandException("Unable to create a CommandResults reply region in the server.", results.getException());
            }
            this.inboxRegion = this.endpoints != null ? RegionUtil.getRegion(inboxPath, Scope.LOCAL, DataPolicy.DEFAULT, this.endpoints, false) : RegionUtil.getRegion(inboxPath, Scope.LOCAL, DataPolicy.DEFAULT, this.pool, false);
            this.inboxRegion.getAttributesMutator().addCacheListener(new ReplyListener());
            this.inboxRegion.registerInterestRegex(".*");
        }
        catch (Exception ex) {
            throw new CommandException(ex);
        }
    }

    public SelectResults query(String queryString) throws CommandException {
        if (this.isClosed()) {
            return null;
        }
        try {
            return this.outboxRegion.query(queryString);
        }
        catch (Exception ex) {
            throw new CommandException(ex);
        }
    }

    public String getOutboxRegionFullPath() {
        return this.outboxRegionFullPath;
    }

    public String getEndpoints() {
        return this.endpoints;
    }

    public Pool getPool() {
        return this.pool;
    }

    public String getPoolName() {
        if (this.pool == null) {
            return null;
        }
        return this.pool.getName();
    }

    public void addCommandResultsListener(CommandResultsListener commandResultsListener) {
        this.commandResultsListenerList.add(commandResultsListener);
        this.commandResultsListeners = this.commandResultsListenerList.toArray(new CommandResultsListener[0]);
    }

    public void removeCommandResultsListener(CommandResultsListener commandResultsListener) {
        this.commandResultsListenerList.remove(commandResultsListener);
        this.commandResultsListeners = this.commandResultsListenerList.toArray(new CommandResultsListener[0]);
    }

    protected void fireCommandResults(CommandResults results) {
        CommandResultsListener[] listeners = this.commandResultsListeners;
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].commandResultsReceived(results);
        }
    }

    class ReplyListener
    extends CacheListenerAdapter {
        ReplyListener() {
        }

        private void handleReplyReceived(EntryEvent entryEvent) {
            CommandResults results = (CommandResults)entryEvent.getNewValue();
            CommandClient.this.fireCommandResults(results);
        }

        @Override
        public void afterCreate(EntryEvent entryEvent) {
            this.handleReplyReceived(entryEvent);
        }

        @Override
        public void afterUpdate(EntryEvent entryEvent) {
            this.handleReplyReceived(entryEvent);
        }
    }
}

