/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.task;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorException;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorPeer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.Indexer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.IndexerManager;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.DataSerializerEx;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class QueryTask
implements CommandTask,
AggregateFunction {
    private static final long serialVersionUID = 1L;
    public static final byte TYPE_KEYS = 0;
    public static final byte TYPE_VALUES = 1;
    public static final byte TYPE_KEYS_VALUES = 2;
    public static final byte ERROR_NO_ERROR = 0;
    public static final byte ERROR_REGION_UNDEFINED = -2;
    public static final byte ERROR_INDEX_UNDEFINED = -3;
    public static final byte ERROR_AGGREGATOR = -3;
    public static final byte SUCCESS_RR = 1;
    public static final byte SUCCESS_PR = 2;
    private volatile transient boolean aggregationExecuted = false;
    private final Object aggregationExecutedLock = new Object();
    private String regionPath;
    private Object queryKey;
    private byte queryType = (byte)2;
    private static Set<Integer> routingKeySet;

    public QueryTask() {
    }

    public QueryTask(String regionPath, Object queryKey, byte queryType) {
        this.regionPath = regionPath;
        this.queryKey = queryKey;
        this.queryType = queryType;
    }

    @Override
    public CommandResults runTask(Object userData) {
        Cache cache = CacheFactory.getAnyInstance();
        cache.getLogger().fine("QueryTask.runTask(): regionPath = " + this.regionPath + ", type = " + this.queryType + ", queryKey = " + this.queryKey);
        CommandResults results = new CommandResults();
        Region region = cache.getRegion(this.regionPath);
        if (region == null) {
            results.setCode((byte)-2);
            results.setCodeMessage("The specified region " + this.regionPath + " is undefined.");
            return results;
        }
        if (region instanceof PartitionedRegion) {
            AggregatorPeer aggregator = new AggregatorPeer((PartitionedRegion)region);
            try {
                Object obj = aggregator.aggregate(this);
                results.setCode((byte)2);
                results.setDataObject(obj);
            }
            catch (AggregatorException ex) {
                results.setCode((byte)-3);
                results.setCodeMessage("Unabled to create aggregator: " + ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            Indexer indexer = IndexerManager.getIndexerManager().getIndexer(this.regionPath);
            if (indexer == null) {
                results.setCode((byte)-3);
                results.setCodeMessage("The indexer for the specified region " + this.regionPath + " is undefined.");
                return results;
            }
            results.setCode((byte)1);
            results.setDataObject(this.run(indexer));
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateResults run(FunctionContext context) {
        AggregateResults results = null;
        Object object = this.aggregationExecutedLock;
        synchronized (object) {
            if (!this.aggregationExecuted) {
                results = new AggregateResults();
                Indexer indexer = IndexerManager.getIndexerManager().getIndexer(this.regionPath);
                results.setDataObject(this.run(indexer));
                this.aggregationExecuted = true;
            }
        }
        return results;
    }

    @Override
    public Object aggregate(List list) {
        ArrayList<byte[]> aggregateResults = null;
        switch (this.queryType) {
            case 0: {
                try {
                    Collection<Object> aggregateSet = null;
                    for (AggregateResults results : list) {
                        byte[] blob = (byte[])results.getDataObject();
                        if (blob == null) continue;
                        Set set = (Set)BlobHelper.deserializeBlob(blob);
                        if (aggregateSet == null) {
                            aggregateSet = set;
                            continue;
                        }
                        aggregateSet.addAll(set);
                    }
                    aggregateResults = aggregateSet;
                }
                catch (Exception ex) {
                    CacheFactory.getAnyInstance().getLogger().warning("Error occurred while deserializing to blob: " + ex.getMessage(), ex);
                }
                break;
            }
            case 1: {
                try {
                    Collection<Object> aggregateCollection = null;
                    for (AggregateResults results : list) {
                        byte[] blob = (byte[])results.getDataObject();
                        if (blob == null) continue;
                        Collection collection = (Collection)BlobHelper.deserializeBlob(blob);
                        if (aggregateCollection == null) {
                            aggregateCollection = collection;
                            continue;
                        }
                        aggregateCollection.addAll(collection);
                    }
                    aggregateResults = aggregateCollection;
                }
                catch (Exception ex) {
                    CacheFactory.getAnyInstance().getLogger().warning("Error occurred while deserializing to blob: " + ex.getMessage(), ex);
                }
                break;
            }
            default: {
                ArrayList<byte[]> aggregateList = new ArrayList<byte[]>(list.size());
                for (AggregateResults results : list) {
                    byte[] blob;
                    if (results == null || (blob = (byte[])results.getDataObject()) == null) continue;
                    aggregateList.add(blob);
                }
                aggregateResults = aggregateList;
                break;
            }
        }
        return aggregateResults;
    }

    @Override
    public Object aggregateDistributedSystems(Object[] results) {
        return null;
    }

    private Object run(Indexer indexer) {
        Object dataObject = null;
        switch (this.queryType) {
            case 0: {
                dataObject = this.queryKeys(indexer);
                break;
            }
            case 1: {
                dataObject = this.queryValues(indexer);
                break;
            }
            default: {
                dataObject = this.queryKeysValues(indexer);
            }
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object queryKeys(Indexer indexer) {
        byte[] blob = null;
        Map map = indexer.query(this.queryKey);
        if (map != null) {
            try {
                Map map2 = map;
                synchronized (map2) {
                    blob = BlobHelper.serializeToBlob(new HashSet(map.keySet()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        map = null;
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object queryValues(Indexer indexer) {
        byte[] blob = null;
        Map map = indexer.query(this.queryKey);
        if (map != null) {
            try {
                Map map2 = map;
                synchronized (map2) {
                    blob = BlobHelper.serializeToBlob(new HashSet(map.values()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        map = null;
        return blob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object queryKeysValues(Indexer indexer) {
        byte[] blob = null;
        Map map = indexer.query(this.queryKey);
        if (map != null) {
            try {
                Map map2 = map;
                synchronized (map2) {
                    blob = BlobHelper.serializeToBlob(map);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return blob;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionPath = DataSerializerEx.readUTF(in);
        this.queryKey = DataSerializer.readObject(in);
        this.queryType = in.readByte();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializerEx.writeUTF(this.regionPath, out);
        DataSerializer.writeObject(this.queryKey, out);
        out.writeByte(this.queryType);
    }

    static {
        int numVMs = Integer.getInteger("indexer.aggregator.routingKeySize", 4);
        routingKeySet = new CopyOnWriteArraySet<Integer>();
        for (int i = 0; i < numVMs; ++i) {
            routingKeySet.add(i);
        }
    }
}

