/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.task;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateFunction;
import com.gemstone.gemfire.internal.tools.gfsh.aggregator.AggregateResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorException;
import com.gemstone.gemfire.internal.tools.gfsh.app.aggregator.AggregatorPeer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.IndexInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.Indexer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.IndexerManager;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.DataSerializerEx;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IndexInfoTask
implements CommandTask,
AggregateFunction {
    private static final long serialVersionUID = 1L;
    private volatile transient boolean aggregationExecuted = false;
    private final Object aggregationExecutedLock = new Object();
    private String regionPath;

    public IndexInfoTask() {
    }

    public IndexInfoTask(String regionPath) {
        this.regionPath = regionPath;
    }

    @Override
    public CommandResults runTask(Object userData) {
        Cache cache = CacheFactory.getAnyInstance();
        cache.getLogger().fine("IndexInfoTask.runTask(): regionPath = " + this.regionPath);
        CommandResults results = new CommandResults();
        Region region = cache.getRegion(this.regionPath);
        if (region == null) {
            results.setCode((byte)-2);
            results.setCodeMessage("The specified region " + this.regionPath + " is undefined.");
            return results;
        }
        if (region instanceof PartitionedRegion) {
            AggregatorPeer aggregator = new AggregatorPeer((PartitionedRegion)region);
            try {
                Object obj = aggregator.aggregate(this);
                results.setCode((byte)2);
                results.setDataObject(obj);
            }
            catch (AggregatorException ex) {
                results.setCode((byte)-3);
                results.setCodeMessage("Unabled to create aggregator: " + ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            results.setCode((byte)1);
            results.setDataObject(this.getIndexInfo());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateResults run(FunctionContext context) {
        AggregateResults results = null;
        Object object = this.aggregationExecutedLock;
        synchronized (object) {
            if (!this.aggregationExecuted) {
                results = new AggregateResults();
                results.setDataObject(this.getIndexInfo());
                this.aggregationExecuted = true;
            }
        }
        return results;
    }

    @Override
    public Object aggregate(List list) {
        ArrayList<IndexInfo> aggregateList = null;
        for (AggregateResults results : list) {
            if (results == null) continue;
            if (aggregateList == null) {
                aggregateList = new ArrayList<IndexInfo>(list.size());
            }
            aggregateList.add((IndexInfo)results.getDataObject());
        }
        return aggregateList;
    }

    @Override
    public Object aggregateDistributedSystems(Object[] results) {
        return null;
    }

    private IndexInfo getIndexInfo() {
        Indexer indexer = IndexerManager.getIndexerManager().getIndexer(this.regionPath);
        return indexer.getIndexInfo();
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.regionPath = DataSerializerEx.readUTF(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializerEx.writeUTF(this.regionPath, out);
    }
}

