/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.index;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.IndexInfo;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.LookupServiceException;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.task.IndexInfoTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.task.QuerySizeTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.index.task.QueryTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.CommandClient;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LookupService {
    CommandClient commandClient;

    public LookupService(String poolNameOrEndpoints) {
        this(null, poolNameOrEndpoints);
    }

    public LookupService(String commandRegionPath, String poolNameOrEndpoints) {
        try {
            this.commandClient = new CommandClient(commandRegionPath, poolNameOrEndpoints);
        }
        catch (Exception ex) {
            throw new LookupServiceException("Unable to create LookupService due to a cache exception: " + ex.getMessage(), ex);
        }
    }

    public LookupService(CommandClient commandClient) {
        this.commandClient = commandClient;
    }

    public String getCommandRegionPath() {
        if (this.commandClient == null) {
            return null;
        }
        return this.commandClient.getOutboxRegionFullPath();
    }

    public String getEndpoints() {
        if (this.commandClient == null) {
            return null;
        }
        return this.commandClient.getEndpoints();
    }

    public String getPoolName() {
        if (this.commandClient == null) {
            return null;
        }
        return this.commandClient.getPoolName();
    }

    public Map entryMap(String regionPath, Object queryKey) {
        try {
            CommandResults results = this.commandClient.execute(new QueryTask(regionPath, queryKey, 2));
            Map resultMap = null;
            switch (results.getCode()) {
                case 1: {
                    byte[] blob = (byte[])results.getDataObject();
                    if (blob == null) break;
                    resultMap = (Map)BlobHelper.deserializeBlob(blob);
                    break;
                }
                case 2: {
                    List list = (List)results.getDataObject();
                    try {
                        for (byte[] blob : list) {
                            if (blob == null) continue;
                            Map map = (Map)BlobHelper.deserializeBlob(blob);
                            if (resultMap == null) {
                                resultMap = map;
                                continue;
                            }
                            resultMap.putAll(map);
                        }
                        break;
                    }
                    catch (Exception ex) {
                        CacheFactory.getAnyInstance().getLogger().warning("Error occurred while deserializing to blob: " + ex.getMessage(), ex);
                    }
                }
            }
            return resultMap;
        }
        catch (Exception ex) {
            throw new LookupServiceException("Unable to retrieve the entry map due to a cache exception: " + ex.getMessage(), ex);
        }
    }

    public Set keySet(String regionPath, Object queryKey) {
        try {
            CommandResults results = this.commandClient.execute(new QueryTask(regionPath, queryKey, 0));
            Set keys = null;
            switch (results.getCode()) {
                case 1: {
                    byte[] blob = (byte[])results.getDataObject();
                    if (blob == null) break;
                    keys = (Set)BlobHelper.deserializeBlob(blob);
                    break;
                }
                case 2: {
                    try {
                        List list = (List)results.getDataObject();
                        for (byte[] blob : list) {
                            if (blob == null) continue;
                            Set set = (Set)BlobHelper.deserializeBlob(blob);
                            if (keys == null) {
                                keys = set;
                                continue;
                            }
                            keys.addAll(set);
                        }
                        break;
                    }
                    catch (Exception ex) {
                        CacheFactory.getAnyInstance().getLogger().warning("Error occurred while deserializing to blob: " + ex.getMessage(), ex);
                    }
                }
            }
            return keys;
        }
        catch (Exception ex) {
            throw new LookupServiceException("Unable to retrieve the key set due to a cache exception: " + ex.getMessage(), ex);
        }
    }

    public Collection values(String regionPath, Object queryKey) {
        try {
            CommandResults results = this.commandClient.execute(new QueryTask(regionPath, queryKey, 1));
            Collection values = null;
            switch (results.getCode()) {
                case 1: {
                    byte[] blob = (byte[])results.getDataObject();
                    if (blob == null) break;
                    values = (Collection)BlobHelper.deserializeBlob(blob);
                    break;
                }
                case 2: {
                    try {
                        List list = (List)results.getDataObject();
                        for (byte[] blob : list) {
                            if (blob == null) continue;
                            Collection col = (Collection)BlobHelper.deserializeBlob(blob);
                            if (values == null) {
                                values = col;
                                continue;
                            }
                            values.addAll(col);
                        }
                        break;
                    }
                    catch (Exception ex) {
                        CacheFactory.getAnyInstance().getLogger().warning("Error occurred while deserializing to blob: " + ex.getMessage(), ex);
                    }
                }
            }
            return values;
        }
        catch (Exception ex) {
            throw new LookupServiceException("Unable to retrieve the values to a cache exception: " + ex.getMessage(), ex);
        }
    }

    public IndexInfo[] getIndexInfoArray(String regionPath) {
        try {
            IndexInfo[] indexInfoArray = null;
            CommandResults results = this.commandClient.execute(new IndexInfoTask(regionPath));
            switch (results.getCode()) {
                case 1: {
                    IndexInfo indexInfo = (IndexInfo)results.getDataObject();
                    if (indexInfo == null) break;
                    indexInfoArray = new IndexInfo[]{indexInfo};
                    break;
                }
                case 2: {
                    List list = (List)results.getDataObject();
                    if (list == null) break;
                    indexInfoArray = list.toArray(new IndexInfo[0]);
                }
            }
            return indexInfoArray;
        }
        catch (Exception ex) {
            throw new LookupServiceException("Unable to retrieve index info due to a cache exception: " + ex.getMessage(), ex);
        }
    }

    public int size(String regionPath, Object queryKey) {
        try {
            CommandResults results = this.commandClient.execute(new QuerySizeTask(regionPath, queryKey));
            return (Integer)results.getDataObject();
        }
        catch (Exception ex) {
            throw new LookupServiceException("Unable to retrieve the size due to a cache exception: " + ex.getMessage(), ex);
        }
    }

    public void close() {
        try {
            this.commandClient.close();
        }
        catch (Exception ex) {
            throw new LookupServiceException("Exception raised while closing LookupService: " + ex.getMessage(), ex);
        }
    }
}

