/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.data;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.InvalidTypeException;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Listable;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ListMessage
implements Listable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final StringBuffer spaces = new StringBuffer("                               ");
    private ArrayList entryList = new ArrayList(10);

    @Override
    public void add(Listable listable) {
        this.entryList.add(listable);
    }

    @Override
    public void add(Mappable mappable) {
        this.entryList.add(mappable);
    }

    @Override
    public void add(String value2) {
        this.entryList.add(value2);
    }

    @Override
    public void add(boolean value2) {
        this.entryList.add(value2);
    }

    @Override
    public void add(byte value2) {
        this.entryList.add(value2);
    }

    @Override
    public void add(short value2) {
        this.entryList.add(value2);
    }

    @Override
    public void add(int value2) {
        this.entryList.add(value2);
    }

    @Override
    public void add(long value2) {
        this.entryList.add(value2);
    }

    @Override
    public void add(float value2) {
        this.entryList.add(new Float(value2));
    }

    @Override
    public void add(double value2) {
        this.entryList.add(new Double(value2));
    }

    @Override
    public Object getValue(int index2) throws IndexOutOfBoundsException {
        return this.entryList.get(index2);
    }

    @Override
    public boolean getBoolean(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public byte getByte(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Byte) {
            return (Byte)value2;
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public char getChar(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Character) {
            return ((Character)value2).charValue();
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public short getShort(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Short) {
            return (Short)value2;
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public int getInt(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public long getLong(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Long) {
            return ((Long)value2).intValue();
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public float getFloat(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Float) {
            return ((Float)value2).intValue();
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public double getDouble(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof Double) {
            return ((Double)value2).intValue();
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public String getString(int index2) throws IndexOutOfBoundsException, InvalidTypeException {
        Object value2 = this.getValue(index2);
        if (value2 instanceof String) {
            return (String)value2;
        }
        throw new InvalidTypeException("The value at index " + index2 + " has the type " + value2.getClass().getName());
    }

    @Override
    public boolean hasListable() {
        Iterator iterator = this.entryList.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Listable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMappable() {
        Iterator iterator = this.entryList.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Mappable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object remove(int index2) {
        return this.entryList.remove(index2);
    }

    @Override
    public int size() {
        return this.entryList.size();
    }

    public Collection values() {
        return this.entryList;
    }

    @Override
    public Collection getValues() {
        return this.entryList;
    }

    @Override
    public Object[] getAllValues() {
        return this.entryList.toArray();
    }

    @Override
    public Object[] getAllPrimitives() {
        ArrayList primitiveList = new ArrayList();
        for (Object value2 : this.entryList) {
            if (value2 instanceof Listable) continue;
            primitiveList.add(value2);
        }
        return primitiveList.toArray();
    }

    @Override
    public int getPrimitiveCount() {
        Iterator iterator = this.entryList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            if (iterator.next() instanceof Listable) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Listable[] getAllListables() {
        ArrayList listMessageList = new ArrayList();
        for (Object value2 : this.entryList) {
            if (!(value2 instanceof Listable)) continue;
            listMessageList.add(value2);
        }
        return listMessageList.toArray(new Listable[0]);
    }

    @Override
    public Mappable[] getAllMappables() {
        ArrayList listMessageList = new ArrayList();
        for (Object value2 : this.entryList) {
            if (!(value2 instanceof Mappable)) continue;
            listMessageList.add(value2);
        }
        return listMessageList.toArray(new Mappable[0]);
    }

    @Override
    public int getListableCount() {
        Iterator iterator = this.entryList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Listable)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getMappableCount() {
        Iterator iterator = this.entryList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Mappable)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void clear() {
        this.entryList.clear();
    }

    private void convertToString(StringBuffer buffer, Listable message, int level) {
        Object[] values = message.getAllValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Listable) {
                buffer.append(spaces.substring(0, level * 3) + values[i] + "*****" + "\n");
                this.convertToString(buffer, (Listable)values[i], level + 1);
                continue;
            }
            buffer.append(spaces.substring(0, level * 3) + values[i] + "\n");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        this.convertToString(buffer, this, 0);
        return buffer.toString();
    }

    private void dump(PrintWriter writer, Listable message, int level) {
        Object[] values = message.getAllValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Listable) {
                writer.println(spaces.substring(0, level * 3) + values[i] + "*****");
                this.dump(writer, (Listable)values[i], level + 1);
            }
            if (values[i] instanceof Listable) {
                writer.println(spaces.substring(0, level * 3) + values[i] + "*****");
                this.dump(writer, (Mappable)values[i], level + 1);
                continue;
            }
            writer.println(spaces.substring(0, level * 3) + values[i]);
        }
    }

    private void dump(PrintWriter writer, Mappable message, int level) {
        Map.Entry[] entries = message.getAllEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getValue() instanceof Mappable) {
                writer.println(spaces.substring(0, level * 3) + entries[i].getKey() + "*****");
                this.dump(writer, (Mappable)entries[i].getValue(), level + 1);
                continue;
            }
            if (entries[i].getValue() instanceof Listable) {
                writer.println(spaces.substring(0, level * 3) + entries[i].getKey() + "*****");
                this.dump(writer, (Listable)entries[i].getValue(), level + 1);
                continue;
            }
            writer.println(spaces.substring(0, level * 3) + entries[i].getKey() + " = " + entries[i].getValue());
        }
    }

    @Override
    public void dump(OutputStream out) {
        if (out == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(out);
        this.dump(writer, this, 0);
        writer.flush();
    }

    public void dump() {
        PrintWriter writer = new PrintWriter(System.out);
        this.dump(writer, this, 0);
        writer.flush();
    }

    @Override
    public Object clone() {
        ListMessage dup = new ListMessage();
        dup.entryList = (ArrayList)this.entryList.clone();
        return dup;
    }

    @Override
    public void fromData(DataInput dataInput) throws IOException, ClassNotFoundException {
        this.entryList = DataSerializer.readArrayList(dataInput);
    }

    @Override
    public void toData(DataOutput dataOutput) throws IOException {
        DataSerializer.writeArrayList(this.entryList, dataOutput);
    }
}

