/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.data;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.InvalidTypeException;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.ListMap;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Listable;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ListMapMessage
implements Mappable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final StringBuffer spaces = new StringBuffer("                               ");
    private ListMap map = new ListMap();

    @Override
    public void put(String name, Mappable mappable) {
        this.map.put(name, mappable);
    }

    @Override
    public void put(String name, Listable listable) {
        this.map.put(name, listable);
    }

    @Override
    public void put(String name, String value2) {
        this.map.put(name, value2);
    }

    @Override
    public void put(String name, boolean value2) {
        this.map.put(name, (Object)value2);
    }

    @Override
    public void put(String name, byte value2) {
        this.map.put(name, (Object)value2);
    }

    @Override
    public void put(String name, short value2) {
        this.map.put(name, (Object)value2);
    }

    @Override
    public void put(String name, int value2) {
        this.map.put(name, (Object)value2);
    }

    @Override
    public void put(String name, long value2) {
        this.map.put(name, (Object)value2);
    }

    @Override
    public void put(String name, float value2) {
        this.map.put(name, new Float(value2));
    }

    @Override
    public void put(String name, double value2) {
        this.map.put(name, new Double(value2));
    }

    @Override
    public Object getValue(String name) {
        return this.map.get(name);
    }

    @Override
    public boolean getBoolean(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Boolean) {
            return (Boolean)value2;
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public byte getByte(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Byte) {
            return (Byte)value2;
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public char getChar(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Character) {
            return ((Character)value2).charValue();
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public short getShort(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Short) {
            return (Short)value2;
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public int getInt(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public long getLong(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Long) {
            return (Long)value2;
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public float getFloat(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Float) {
            return ((Float)value2).floatValue();
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public double getDouble(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof Double) {
            return (Double)value2;
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public String getString(String name) throws NoSuchFieldException, InvalidTypeException {
        Object value2 = this.map.get(name);
        if (value2 == null) {
            throw new NoSuchFieldException("The field " + name + " is not found.");
        }
        if (value2 instanceof String) {
            return (String)value2;
        }
        throw new InvalidTypeException("The field " + name + " has the type " + value2.getClass().getName());
    }

    @Override
    public boolean hasMappable() {
        Map.Entry[] entries = this.getAllEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i].getValue() instanceof Mappable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasListable() {
        Map.Entry[] entries = this.getAllEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i].getValue() instanceof Listable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object remove(String name) {
        return this.map.remove(name);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    @Override
    public Collection getValues() {
        return this.map.values();
    }

    public Set keys() {
        return this.map.keySet();
    }

    @Override
    public Set getKeys() {
        return this.map.keySet();
    }

    @Override
    public Set getEntries() {
        return this.map.entrySet();
    }

    @Override
    public Map.Entry[] getAllEntries() {
        return this.map.entrySet().toArray(new Map.Entry[0]);
    }

    @Override
    public Map.Entry[] getAllPrimitives() {
        Map.Entry[] entries = this.getAllEntries();
        Map.Entry[] messages = new Map.Entry[entries.length];
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getValue() instanceof Mappable) continue;
            messages[count++] = entries[i];
        }
        Map.Entry[] m = new Map.Entry[count];
        System.arraycopy(messages, 0, m, 0, count);
        return m;
    }

    @Override
    public int getPrimitiveCount() {
        Map.Entry[] entries = this.getAllEntries();
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getValue() instanceof Mappable) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Map.Entry[] getAllMappables() {
        Map.Entry[] entries = this.getAllEntries();
        Map.Entry[] messages = new Map.Entry[entries.length];
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i].getValue() instanceof Mappable)) continue;
            messages[count++] = entries[i];
        }
        Map.Entry[] m = new Map.Entry[count];
        System.arraycopy(messages, 0, m, 0, count);
        return m;
    }

    @Override
    public Map.Entry[] getAllListables() {
        Map.Entry[] entries = this.getAllEntries();
        Map.Entry[] messages = new Map.Entry[entries.length];
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i].getValue() instanceof Listable)) continue;
            messages[count++] = entries[i];
        }
        Map.Entry[] m = new Map.Entry[count];
        System.arraycopy(messages, 0, m, 0, count);
        return m;
    }

    @Override
    public int getMappableCount() {
        Map.Entry[] entries = this.getAllEntries();
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i].getValue() instanceof Mappable)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getListableCount() {
        Map.Entry[] entries = this.getAllEntries();
        int count = 0;
        for (int i = 0; i < entries.length; ++i) {
            if (!(entries[i].getValue() instanceof Listable)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    private void convertToString(StringBuffer buffer, Mappable message, int level) {
        Map.Entry[] entries = message.getAllEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getValue() instanceof Mappable) {
                buffer.append(spaces.substring(0, level * 3) + entries[i].getKey() + "*****" + "\n");
                this.convertToString(buffer, (Mappable)entries[i].getValue(), level + 1);
                continue;
            }
            buffer.append(spaces.substring(0, level * 3) + entries[i].getKey() + " = " + entries[i].getValue() + "\n");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        this.convertToString(buffer, this, 0);
        return buffer.toString();
    }

    private void dump(PrintWriter writer, Mappable message, int level) {
        Map.Entry[] entries = message.getAllEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getValue() instanceof Mappable) {
                writer.println(spaces.substring(0, level * 3) + entries[i].getKey() + "*****");
                this.dump(writer, (Mappable)entries[i].getValue(), level + 1);
                continue;
            }
            writer.println(spaces.substring(0, level * 3) + entries[i].getKey() + " = " + entries[i].getValue());
        }
    }

    @Override
    public void dump(OutputStream out) {
        if (out == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(out);
        this.dump(writer, this, 0);
        writer.flush();
    }

    public void dump() {
        PrintWriter writer = new PrintWriter(System.out);
        this.dump(writer, this, 0);
        writer.flush();
    }

    @Override
    public Object clone() {
        ListMapMessage dup = new ListMapMessage();
        dup.map = (ListMap)this.map.clone();
        return dup;
    }

    @Override
    public void fromData(DataInput dataInput) throws IOException, ClassNotFoundException {
        InternalDataSerializer.invokeFromData(this.map, dataInput);
    }

    @Override
    public void toData(DataOutput dataOutput) throws IOException {
        InternalDataSerializer.invokeToData(this.map, dataOutput);
    }
}

