/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.data;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ListMap
extends AbstractMap
implements Cloneable,
DataSerializable {
    private static final long serialVersionUID = 1L;
    protected ListSet entrySet = new ListSet();

    @Override
    public Object put(Object key2, Object value2) {
        Map.Entry entry = new ListEntry(key2);
        entry = (Map.Entry)this.entrySet.putEntry(entry);
        return entry.setValue(value2);
    }

    @Override
    public Set entrySet() {
        return this.entrySet;
    }

    @Override
    public Object clone() {
        ListMap result = null;
        try {
            result = (ListMap)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void fromData(DataInput dataInput) throws IOException, ClassNotFoundException {
        int size2 = dataInput.readInt();
        for (int i = 0; i < size2; ++i) {
            String key2 = DataSerializer.readString(dataInput);
            Object value2 = DataSerializer.readObject(dataInput);
            this.put(key2, value2);
        }
    }

    @Override
    public void toData(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.entrySet.size());
        for (Map.Entry entry : this.entrySet) {
            DataSerializer.writeObject(entry.getKey(), dataOutput);
            DataSerializer.writeObject(entry.getValue(), dataOutput);
        }
    }

    protected static class ListEntry
    implements Map.Entry,
    Serializable {
        protected Object key = null;
        protected Object value = null;

        public ListEntry(Object pKey) {
            this.key = pKey;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object pValue) {
            Object prevValue = this.value;
            this.value = pValue;
            return prevValue;
        }

        @Override
        public boolean equals(Object o) {
            boolean retVal = false;
            Object otherKey = o;
            if (o instanceof ListEntry) {
                otherKey = ((ListEntry)o).getKey();
            }
            retVal = this.key == null && otherKey == null || this.key != null && this.key.equals(otherKey);
            return retVal;
        }

        @Override
        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }
    }

    protected static class ListSet
    extends AbstractSet
    implements Serializable {
        protected ArrayList entryList = new ArrayList();

        @Override
        public Iterator iterator() {
            return this.entryList.iterator();
        }

        @Override
        public int size() {
            return this.entryList.size();
        }

        @Override
        public boolean add(Object o) {
            boolean retVal = false;
            if (!this.entryList.contains(o)) {
                retVal = this.entryList.add(o);
            }
            return retVal;
        }

        public Object putEntry(Object entry) {
            Object retVal = entry;
            int index2 = this.entryList.indexOf(entry);
            if (index2 >= 0) {
                retVal = this.entryList.get(index2);
            } else {
                this.entryList.add(entry);
            }
            return retVal;
        }
    }
}

