/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.cache.data;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.GenericMap;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.InvalidTypeException;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;

public class GenericMessage
implements GenericMap,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final StringBuffer spaces = new StringBuffer("                               ");
    private static int CHUNK_SIZE_IN_BYTES = 100000;
    private ArrayList entryList = new ArrayList(10);

    @Override
    public GenericMap.Entry add(String key2, GenericMap value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 1));
    }

    @Override
    public GenericMap.Entry add(String key2, Mappable value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 2));
    }

    @Override
    public GenericMap.Entry add(String key2, String value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 11));
    }

    @Override
    public GenericMap.Entry add(String key2, boolean value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 10));
    }

    @Override
    public GenericMap.Entry add(String key2, byte value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 3));
    }

    @Override
    public GenericMap.Entry add(String key2, short value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 9));
    }

    @Override
    public GenericMap.Entry add(String key2, int value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 7));
    }

    @Override
    public GenericMap.Entry add(String key2, long value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, value2, 8));
    }

    @Override
    public GenericMap.Entry add(String key2, float value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, new Float(value2), 6));
    }

    @Override
    public GenericMap.Entry add(String key2, double value2) {
        if (key2 == null) {
            return null;
        }
        return this.addEntry(new GenericMap.Entry(key2, new Double(value2), 5));
    }

    @Override
    public GenericMap.Entry addEntry(GenericMap.Entry entry) {
        if (entry == null) {
            return null;
        }
        this.entryList.add(entry);
        return entry;
    }

    @Override
    public GenericMap.Entry getEntry(int index2) {
        if (index2 < 0 || index2 >= this.entryList.size()) {
            return null;
        }
        return (GenericMap.Entry)this.entryList.get(index2);
    }

    @Override
    public GenericMap.Entry getEntry(String key2) {
        if (key2 == null) {
            return null;
        }
        GenericMap.Entry[] array = this.entryList.toArray(new GenericMap.Entry[0]);
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getKey().equals(key2)) continue;
            return array[i];
        }
        return null;
    }

    @Override
    public Object getValue(String key2) {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public boolean getBoolean(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 10 && !(val instanceof Boolean)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return (Boolean)val;
    }

    @Override
    public byte getByte(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 3 && !(val instanceof Byte)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return (Byte)val;
    }

    @Override
    public char getChar(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 4 && !(val instanceof Character)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return ((Character)val).charValue();
    }

    @Override
    public short getShort(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 9 && !(val instanceof Short)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return (Short)val;
    }

    @Override
    public int getInt(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 7 && !(val instanceof Integer)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return (Integer)val;
    }

    @Override
    public long getLong(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 8 && !(val instanceof Long)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return (Long)val;
    }

    @Override
    public float getFloat(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 8 && !(val instanceof Long)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return ((Long)val).longValue();
    }

    @Override
    public double getDouble(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (val == null) {
            throw new NullPointerException("The field " + key2 + " has null value.");
        }
        if (entry.getType() != 5 && !(val instanceof Double)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return (Double)val;
    }

    @Override
    public String getString(String key2) throws NoSuchFieldException, InvalidTypeException {
        GenericMap.Entry entry = this.getEntry(key2);
        if (entry == null) {
            throw new NoSuchFieldException("The field " + key2 + " is not found.");
        }
        Object val = entry.getValue();
        if (entry.getType() != 11 && !(val instanceof String)) {
            throw new InvalidTypeException("The field " + key2 + " has the type " + val.getClass().getName());
        }
        return (String)val;
    }

    @Override
    public GenericMap.Entry getEntryAt(int index2) {
        if (index2 < 0 && index2 >= this.size()) {
            return null;
        }
        return (GenericMap.Entry)this.entryList.get(index2);
    }

    @Override
    public Object getValueAt(int index2) {
        GenericMap.Entry entry = this.getEntryAt(index2);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public String getNameAt(int index2) {
        GenericMap.Entry entry = this.getEntryAt(index2);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public int indexOf(String key2) {
        if (key2 == null) {
            return -1;
        }
        int index2 = -1;
        GenericMap.Entry[] array = this.entryList.toArray(new GenericMap.Entry[0]);
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].getKey().equals(key2)) continue;
            index2 = i;
            break;
        }
        return index2;
    }

    @Override
    public int lastIndexOf(String key2) {
        if (key2 == null) {
            return -1;
        }
        int index2 = -1;
        GenericMap.Entry[] array = this.entryList.toArray(new GenericMap.Entry[0]);
        for (int i = array.length - 1; i >= 0; --i) {
            if (!array[i].getKey().equals(key2)) continue;
            index2 = i;
            break;
        }
        return index2;
    }

    @Override
    public GenericMap.Entry getLastEntry() {
        if (this.entryList.size() > 0) {
            return (GenericMap.Entry)this.entryList.get(this.entryList.size() - 1);
        }
        return null;
    }

    @Override
    public Object getLastValue() {
        GenericMap.Entry entry = this.getLastEntry();
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public GenericMap.Entry getFirstEntry() {
        if (this.entryList.size() > 0) {
            return (GenericMap.Entry)this.entryList.get(0);
        }
        return null;
    }

    @Override
    public Object getFirstValue() {
        GenericMap.Entry entry = this.getFirstEntry();
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public boolean hasGenericData() {
        GenericMap.Entry[] data = this.getAllEntries();
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i].getValue() instanceof GenericMap)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(GenericMap.Entry entry) {
        return this.entryList.remove(entry);
    }

    @Override
    public GenericMap.Entry remove(int index2) {
        return (GenericMap.Entry)this.entryList.remove(index2);
    }

    @Override
    public Collection getEntries() {
        return this.entryList;
    }

    @Override
    public int size() {
        return this.entryList.size();
    }

    @Override
    public GenericMap.Entry[] getAllEntries() {
        return this.entryList.toArray(new GenericMap.Entry[0]);
    }

    @Override
    public GenericMap.Entry[] getAllPrimitives() {
        GenericMap.Entry[] data = this.getAllEntries();
        GenericMap.Entry[] messages = new GenericMap.Entry[data.length];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getValue() instanceof GenericMap) continue;
            messages[count++] = data[i];
        }
        GenericMap.Entry[] m = new GenericMap.Entry[count];
        System.arraycopy(messages, 0, m, 0, count);
        return m;
    }

    @Override
    public int getPrimitiveCount() {
        GenericMap.Entry[] data = this.getAllEntries();
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getValue() instanceof GenericMap) continue;
            ++count;
        }
        return count;
    }

    @Override
    public GenericMap.Entry[] getAllGenericData() {
        GenericMap.Entry[] data = this.getAllEntries();
        GenericMap.Entry[] messages = new GenericMap.Entry[data.length];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i].getValue() instanceof GenericMap)) continue;
            messages[count++] = data[i];
        }
        GenericMap.Entry[] m = new GenericMap.Entry[count];
        System.arraycopy(messages, 0, m, 0, count);
        return m;
    }

    @Override
    public int getGenericDataCount() {
        GenericMap.Entry[] data = this.getAllEntries();
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i].getValue() instanceof GenericMap)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void clear() {
        this.entryList.clear();
    }

    private void convertToString(StringBuffer buffer, GenericMap message, int level) {
        GenericMap.Entry[] data = message.getAllEntries();
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getType() == 2) {
                buffer.append(spaces.substring(0, level * 3) + data[i].getKey() + "*****" + "\n");
                this.convertToString(buffer, (GenericMap)data[i].getValue(), level + 1);
                continue;
            }
            buffer.append(spaces.substring(0, level * 3) + data[i].getKey() + " = " + data[i].getValue() + "\n");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        this.convertToString(buffer, this, 0);
        return buffer.toString();
    }

    private void dump(PrintWriter writer, GenericMap message, int level) {
        GenericMap.Entry[] data = message.getAllEntries();
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getType() == 2) {
                writer.println(spaces.substring(0, level * 3) + data[i].getKey() + "*****");
                this.dump(writer, (GenericMap)data[i].getValue(), level + 1);
                continue;
            }
            writer.println(spaces.substring(0, level * 3) + data[i].getKey() + " = " + data[i].getValue());
        }
    }

    @Override
    public void dump(OutputStream out) {
        if (out == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(out);
        this.dump(writer, this, 0);
        writer.flush();
    }

    public void dump() {
        PrintWriter writer = new PrintWriter(System.out);
        this.dump(writer, this, 0);
        writer.flush();
    }

    private static byte[] serializeDataSerializable(DataSerializable obj) throws IOException {
        byte[] ba = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(CHUNK_SIZE_IN_BYTES);
        DataOutputStream dos = new DataOutputStream(baos);
        DataSerializer.writeObject(obj, dos);
        dos.flush();
        ba = baos.toByteArray();
        return ba;
    }

    private static Object deserializeDataSerializable(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        DataInputStream dis = new DataInputStream(bais);
        Object obj = DataSerializer.readObject(dis);
        return obj;
    }

    private byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.flush();
        byte[] array = baos.toByteArray();
        baos.close();
        return array;
    }

    private Object deserialize(byte[] objArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(objArray);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object obj = ois.readObject();
        return obj;
    }

    @Override
    public Object clone() {
        GenericMessage dup = new GenericMessage();
        dup.entryList = (ArrayList)this.entryList.clone();
        return dup;
    }

    @Override
    public void fromData(DataInput dataInput) throws IOException, ClassNotFoundException {
        int count = dataInput.readInt();
        for (int i = 0; i < count; ++i) {
            byte type = dataInput.readByte();
            String key2 = DataSerializer.readString(dataInput);
            Object value2 = DataSerializer.readObject(dataInput);
            GenericMap.Entry entry = new GenericMap.Entry(key2, value2, type);
            this.entryList.add(entry);
        }
    }

    @Override
    public void toData(DataOutput dataOutput) throws IOException {
        int count = this.entryList.size();
        dataOutput.writeInt(count);
        for (GenericMap.Entry entry : this.entryList) {
            dataOutput.writeByte(entry.getType());
            DataSerializer.writeString(entry.getKey(), dataOutput);
            DataSerializer.writeObject(entry.getValue(), dataOutput);
        }
    }
}

